/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class SocketRstTest
extends AbstractSocketTest {
    protected void assertRstOnCloseException(IOException cause, Channel clientChannel) {
        if (Locale.getDefault() == Locale.US || Locale.getDefault() == Locale.UK) {
            Assert.assertTrue((String)("actual message: " + cause.getMessage()), (boolean)cause.getMessage().contains("reset"));
        }
    }

    @Test(timeout=3000L)
    public void testSoLingerZeroCausesOnlyRstOnClose() throws Throwable {
        this.run();
    }

    public void testSoLingerZeroCausesOnlyRstOnClose(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        final AtomicReference serverChannelRef = new AtomicReference();
        final AtomicReference throwableRef = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        sb.childOption(ChannelOption.SO_LINGER, (Object)0);
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                serverChannelRef.compareAndSet(null, ch);
                latch.countDown();
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        throwableRef.compareAndSet(null, cause);
                    }

                    public void channelInactive(ChannelHandlerContext ctx) {
                        latch2.countDown();
                    }
                }});
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect(sc.localAddress()).sync().channel();
        latch.await();
        ((Channel)serverChannelRef.get()).close();
        latch2.await();
        Throwable cause = (Throwable)throwableRef.get();
        Assert.assertTrue((String)("actual [type, message]: [" + cause.getClass() + ", " + cause.getMessage() + "]"), (boolean)(cause instanceof IOException));
        this.assertRstOnCloseException((IOException)cause, cc);
    }

    @Test(timeout=3000L)
    public void testNoRstIfSoLingerOnClose() throws Throwable {
        this.run();
    }

    public void testNoRstIfSoLingerOnClose(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        final AtomicReference serverChannelRef = new AtomicReference();
        final AtomicReference throwableRef = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);
        final CountDownLatch latch2 = new CountDownLatch(1);
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                serverChannelRef.compareAndSet(null, ch);
                latch.countDown();
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        throwableRef.compareAndSet(null, cause);
                    }

                    public void channelInactive(ChannelHandlerContext ctx) {
                        latch2.countDown();
                    }
                }});
            }
        });
        Channel sc = sb.bind().sync().channel();
        cb.connect(sc.localAddress()).syncUninterruptibly();
        latch.await();
        ((Channel)serverChannelRef.get()).close();
        latch2.await();
        Assert.assertNull(throwableRef.get());
    }
}

