/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOption;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.DatagramPacket;
import io.netty.testsuite.transport.socket.AbstractDatagramTest;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class DatagramUnicastTest
extends AbstractDatagramTest {
    @Test
    public void testSimpleSend() throws Throwable {
        this.run();
    }

    public void testSimpleSend(Bootstrap sb, Bootstrap cb) throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        sb.handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

            public void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
                Assert.assertEquals((long)1L, (long)((ByteBuf)msg.content()).readInt());
                latch.countDown();
            }
        });
        cb.handler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            public void channelRead0(ChannelHandlerContext ctx, Object msgs) throws Exception {
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.bind().sync().channel();
        cc.writeAndFlush((Object)new DatagramPacket(Unpooled.copyInt((int)1), this.addr)).sync();
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        sc.close().sync();
        cc.close().sync();
    }

    @Test
    public void testSimpleSendWithoutBind() throws Throwable {
        this.run();
    }

    public void testSimpleSendWithoutBind(Bootstrap sb, Bootstrap cb) throws Throwable {
        final CountDownLatch latch = new CountDownLatch(1);
        sb.handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

            public void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) throws Exception {
                Assert.assertEquals((long)1L, (long)((ByteBuf)msg.content()).readInt());
                latch.countDown();
            }
        });
        cb.handler((ChannelHandler)new SimpleChannelInboundHandler<Object>(){

            public void channelRead0(ChannelHandlerContext ctx, Object msgs) throws Exception {
            }
        });
        cb.option(ChannelOption.DATAGRAM_CHANNEL_ACTIVE_ON_REGISTRATION, (Object)true);
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.register().sync().channel();
        cc.writeAndFlush((Object)new DatagramPacket(Unpooled.copyInt((int)1), this.addr)).sync();
        Assert.assertTrue((boolean)latch.await(10L, TimeUnit.SECONDS));
        sc.close().sync();
        cc.close().sync();
    }
}

