/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.util;

import io.netty.util.NetUtil;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.Channel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.junit.rules.TestName;

public final class TestUtils {
    private static final int START_PORT = 32768;
    private static final int END_PORT = 65536;
    private static final int NUM_CANDIDATES = 32768;
    private static final List<Integer> PORTS = new ArrayList<Integer>();
    private static Iterator<Integer> portIterator;

    private static int nextCandidatePort() {
        if (portIterator == null || !portIterator.hasNext()) {
            portIterator = PORTS.iterator();
        }
        return portIterator.next();
    }

    public static int getFreePort() {
        for (int i = 0; i < 32768; ++i) {
            int port = TestUtils.nextCandidatePort();
            try {
                ServerSocket ss = new ServerSocket();
                ss.setReuseAddress(false);
                ss.bind(new InetSocketAddress(port));
                ss.close();
                ss = new ServerSocket();
                ss.setReuseAddress(false);
                ss.bind(new InetSocketAddress(NetUtil.LOCALHOST, port));
                ss.close();
                return port;
            }
            catch (IOException iOException) {
                continue;
            }
        }
        throw new RuntimeException("unable to find a free port");
    }

    public static boolean isSctpSupported() {
        String os = System.getProperty("os.name").toLowerCase(Locale.UK);
        if ("unix".equals(os) || "linux".equals(os) || "sun".equals(os) || "solaris".equals(os)) {
            block6: {
                try {
                    Class<?> sctpChannelClass = Class.forName("com.sun.nio.sctp.SctpChannel");
                    Channel channel = (Channel)sctpChannelClass.getMethod("open", new Class[0]).invoke(null, new Object[0]);
                    try {
                        channel.close();
                    }
                    catch (IOException iOException) {}
                }
                catch (UnsupportedOperationException e) {
                    System.out.print("Not supported: " + e.getMessage());
                    return false;
                }
                catch (Throwable t) {
                    if (t instanceof IOException) break block6;
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    public static String testMethodName(TestName testName) {
        String testMethodName = testName.getMethodName();
        if (testMethodName.contains("[")) {
            testMethodName = testMethodName.substring(0, testMethodName.indexOf(91));
        }
        return testMethodName;
    }

    private TestUtils() {
    }

    static {
        for (int i = 32768; i < 65536; ++i) {
            PORTS.add(i);
        }
        Collections.shuffle(PORTS);
    }
}

