/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.socket.SocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.SslHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import io.netty.testsuite.util.BogusSslContextFactory;
import io.netty.util.ReferenceCountUtil;
import java.io.IOException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLEngine;
import org.junit.Assert;
import org.junit.Test;

public class SocketSslGreetingTest
extends AbstractSocketTest {
    private static final LogLevel LOG_LEVEL = LogLevel.TRACE;
    private final ByteBuf greeting = (ByteBuf)ReferenceCountUtil.releaseLater((Object)Unpooled.buffer().writeByte(97));

    @Test(timeout=30000L)
    public void testSslGreeting() throws Throwable {
        this.run();
    }

    public void testSslGreeting(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        final ServerHandler sh = new ServerHandler();
        final ClientHandler ch = new ClientHandler();
        sb.childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel sch) throws Exception {
                SSLEngine sse = BogusSslContextFactory.getServerContext().createSSLEngine();
                sse.setUseClientMode(false);
                ChannelPipeline p = sch.pipeline();
                p.addLast(new ChannelHandler[]{new SslHandler(sse)});
                p.addLast("logger", (ChannelHandler)new LoggingHandler(LOG_LEVEL));
                p.addLast(new ChannelHandler[]{sh});
            }
        });
        cb.handler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel sch) throws Exception {
                SSLEngine cse = BogusSslContextFactory.getClientContext().createSSLEngine();
                cse.setUseClientMode(true);
                ChannelPipeline p = sch.pipeline();
                p.addLast(new ChannelHandler[]{new SslHandler(cse)});
                p.addLast("logger", (ChannelHandler)new LoggingHandler(LOG_LEVEL));
                p.addLast(new ChannelHandler[]{ch});
            }
        });
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        ch.latch.await();
        sh.channel.close().awaitUninterruptibly();
        cc.close().awaitUninterruptibly();
        sc.close().awaitUninterruptibly();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null && !(ch.exception.get() instanceof IOException)) {
            throw ch.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
        if (ch.exception.get() != null) {
            throw ch.exception.get();
        }
    }

    private class ServerHandler
    extends SimpleChannelInboundHandler<String> {
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();

        private ServerHandler() {
        }

        protected void channelRead0(ChannelHandlerContext ctx, String msg) throws Exception {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
            this.channel.writeAndFlush((Object)SocketSslGreetingTest.this.greeting.duplicate().retain());
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (SocketSslGreetingTest.this.logger.isWarnEnabled()) {
                SocketSslGreetingTest.this.logger.warn("Unexpected exception from the server side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }

    private class ClientHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        final AtomicReference<Throwable> exception = new AtomicReference();
        final CountDownLatch latch = new CountDownLatch(1);

        private ClientHandler() {
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf buf) throws Exception {
            Assert.assertEquals((Object)SocketSslGreetingTest.this.greeting, (Object)buf);
            this.latch.countDown();
            ctx.close();
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (SocketSslGreetingTest.this.logger.isWarnEnabled()) {
                SocketSslGreetingTest.this.logger.warn("Unexpected exception from the client side", cause);
            }
            this.exception.compareAndSet(null, cause);
            ctx.close();
        }
    }
}

