/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ChannelFactory;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioDatagramChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.testsuite.transport.TestsuitePermutation;
import io.netty.util.concurrent.DefaultThreadFactory;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ThreadFactory;

public final class SocketTestPermutation {
    private static final int BOSSES = 2;
    private static final int WORKERS = 3;
    private static final EventLoopGroup nioBossGroup = new NioEventLoopGroup(2, (ThreadFactory)new DefaultThreadFactory("testsuite-nio-boss", true));
    private static final EventLoopGroup nioWorkerGroup = new NioEventLoopGroup(3, (ThreadFactory)new DefaultThreadFactory("testsuite-nio-worker", true));
    private static final EventLoopGroup oioBossGroup = new OioEventLoopGroup(Integer.MAX_VALUE, (ThreadFactory)new DefaultThreadFactory("testsuite-oio-boss", true));
    private static final EventLoopGroup oioWorkerGroup = new OioEventLoopGroup(Integer.MAX_VALUE, (ThreadFactory)new DefaultThreadFactory("testsuite-oio-worker", true));

    private SocketTestPermutation() {
    }

    static List<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> socket() {
        ArrayList<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>> list = new ArrayList<TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>>();
        List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> sbfs = SocketTestPermutation.serverSocket();
        List<TestsuitePermutation.BootstrapFactory<Bootstrap>> cbfs = SocketTestPermutation.clientSocket();
        for (TestsuitePermutation.BootstrapFactory<ServerBootstrap> sbf : sbfs) {
            for (TestsuitePermutation.BootstrapFactory<Bootstrap> cbf : cbfs) {
                final TestsuitePermutation.BootstrapFactory<ServerBootstrap> sbf0 = sbf;
                final TestsuitePermutation.BootstrapFactory<Bootstrap> cbf0 = cbf;
                list.add(new TestsuitePermutation.BootstrapComboFactory<ServerBootstrap, Bootstrap>(){

                    @Override
                    public ServerBootstrap newServerInstance() {
                        return (ServerBootstrap)sbf0.newInstance();
                    }

                    @Override
                    public Bootstrap newClientInstance() {
                        return (Bootstrap)cbf0.newInstance();
                    }
                });
            }
        }
        list.remove(list.size() - 1);
        return list;
    }

    static List<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> datagram() {
        ArrayList<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>> list = new ArrayList<TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>>();
        ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>> bfs = new ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>>();
        bfs.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(nioWorkerGroup)).channelFactory((ChannelFactory)new ChannelFactory<Channel>(){

                    public Channel newChannel() {
                        return new NioDatagramChannel(InternetProtocolFamily.IPv4);
                    }

                    public String toString() {
                        return NioDatagramChannel.class.getSimpleName() + ".class";
                    }
                });
            }
        });
        bfs.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(oioWorkerGroup)).channel(OioDatagramChannel.class);
            }
        });
        for (TestsuitePermutation.BootstrapFactory bootstrapFactory : bfs) {
            for (TestsuitePermutation.BootstrapFactory bootstrapFactory2 : bfs) {
                final TestsuitePermutation.BootstrapFactory sbf0 = bootstrapFactory;
                final TestsuitePermutation.BootstrapFactory cbf0 = bootstrapFactory2;
                list.add(new TestsuitePermutation.BootstrapComboFactory<Bootstrap, Bootstrap>(){

                    @Override
                    public Bootstrap newServerInstance() {
                        return (Bootstrap)sbf0.newInstance();
                    }

                    @Override
                    public Bootstrap newClientInstance() {
                        return (Bootstrap)cbf0.newInstance();
                    }
                });
            }
        }
        return list;
    }

    static List<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> serverSocket() {
        ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>> list = new ArrayList<TestsuitePermutation.BootstrapFactory<ServerBootstrap>>();
        list.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            @Override
            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(nioBossGroup, nioWorkerGroup).channel(NioServerSocketChannel.class);
            }
        });
        list.add(new TestsuitePermutation.BootstrapFactory<ServerBootstrap>(){

            @Override
            public ServerBootstrap newInstance() {
                return (ServerBootstrap)new ServerBootstrap().group(oioBossGroup, oioWorkerGroup).channel(OioServerSocketChannel.class);
            }
        });
        return list;
    }

    static List<TestsuitePermutation.BootstrapFactory<Bootstrap>> clientSocket() {
        ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>> list = new ArrayList<TestsuitePermutation.BootstrapFactory<Bootstrap>>();
        list.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(nioWorkerGroup)).channel(NioSocketChannel.class);
            }
        });
        list.add(new TestsuitePermutation.BootstrapFactory<Bootstrap>(){

            @Override
            public Bootstrap newInstance() {
                return (Bootstrap)((Bootstrap)new Bootstrap().group(oioWorkerGroup)).channel(OioSocketChannel.class);
            }
        });
        return list;
    }
}

