/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.util;

import io.netty.testsuite.util.BogusKeyStore;
import io.netty.testsuite.util.BogusTrustManagerFactory;
import java.security.KeyStore;
import java.security.Security;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;

public final class BogusSslContextFactory {
    private static final String PROTOCOL = "TLS";
    private static final SSLContext SERVER_CONTEXT;
    private static final SSLContext CLIENT_CONTEXT;

    public static SSLContext getServerContext() {
        return SERVER_CONTEXT;
    }

    public static SSLContext getClientContext() {
        return CLIENT_CONTEXT;
    }

    private BogusSslContextFactory() {
    }

    static {
        SSLContext clientContext;
        SSLContext serverContext;
        String algorithm = Security.getProperty("ssl.KeyManagerFactory.algorithm");
        if (algorithm == null) {
            algorithm = "SunX509";
        }
        try {
            KeyStore ks = KeyStore.getInstance("JKS");
            ks.load(BogusKeyStore.asInputStream(), BogusKeyStore.getKeyStorePassword());
            KeyManagerFactory kmf = KeyManagerFactory.getInstance(algorithm);
            kmf.init(ks, BogusKeyStore.getCertificatePassword());
            serverContext = SSLContext.getInstance(PROTOCOL);
            serverContext.init(kmf.getKeyManagers(), null, null);
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the server-side SSLContext", e);
        }
        try {
            clientContext = SSLContext.getInstance(PROTOCOL);
            clientContext.init(null, BogusTrustManagerFactory.getTrustManagers(), null);
        }
        catch (Exception e) {
            throw new Error("Failed to initialize the client-side SSLContext", e);
        }
        SERVER_CONTEXT = serverContext;
        CLIENT_CONTEXT = clientContext;
    }
}

