/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.transport.socket;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.DefaultFileRegion;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.testsuite.transport.socket.AbstractSocketTest;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;
import org.junit.Assert;
import org.junit.Test;

public class SocketFileRegionTest
extends AbstractSocketTest {
    private static final Random random = new Random();
    static final byte[] data = new byte[0xA00000];

    @Test
    public void testFileRegion() throws Throwable {
        this.run();
    }

    @Test
    public void testFileRegionVoidPromise() throws Throwable {
        this.run();
    }

    public void testFileRegion(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFileRegionTest.testFileRegion0(sb, cb, false);
    }

    public void testFileRegionVoidPromise(ServerBootstrap sb, Bootstrap cb) throws Throwable {
        SocketFileRegionTest.testFileRegion0(sb, cb, true);
    }

    private static void testFileRegion0(ServerBootstrap sb, Bootstrap cb, boolean voidPromise) throws Throwable {
        File file = File.createTempFile("netty-", ".tmp");
        file.deleteOnExit();
        FileOutputStream out = new FileOutputStream(file);
        out.write(data);
        out.close();
        SimpleChannelInboundHandler<Object> ch = new SimpleChannelInboundHandler<Object>(){

            public void channelRead0(ChannelHandlerContext ctx, Object msg) throws Exception {
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                ctx.close();
            }
        };
        TestHandler sh = new TestHandler();
        sb.childHandler((ChannelHandler)sh);
        cb.handler((ChannelHandler)ch);
        Channel sc = sb.bind().sync().channel();
        Channel cc = cb.connect().sync().channel();
        DefaultFileRegion region = new DefaultFileRegion(new FileInputStream(file).getChannel(), 0L, file.length());
        if (voidPromise) {
            Assert.assertEquals((Object)cc.voidPromise(), (Object)cc.writeAndFlush((Object)region, cc.voidPromise()));
        } else {
            Assert.assertNotEquals((Object)cc.voidPromise(), (Object)cc.writeAndFlush((Object)region));
        }
        while (sh.counter < data.length && sh.exception.get() == null) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {}
        }
        sh.channel.close().sync();
        cc.close().sync();
        sc.close().sync();
        if (sh.exception.get() != null && !(sh.exception.get() instanceof IOException)) {
            throw sh.exception.get();
        }
        if (sh.exception.get() != null) {
            throw sh.exception.get();
        }
    }

    static {
        random.nextBytes(data);
    }

    private static class TestHandler
    extends SimpleChannelInboundHandler<ByteBuf> {
        volatile Channel channel;
        final AtomicReference<Throwable> exception = new AtomicReference();
        volatile int counter;

        private TestHandler() {
        }

        public void channelActive(ChannelHandlerContext ctx) throws Exception {
            this.channel = ctx.channel();
        }

        public void channelRead0(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
            byte[] actual = new byte[in.readableBytes()];
            in.readBytes(actual);
            int lastIdx = this.counter;
            for (int i = 0; i < actual.length; ++i) {
                Assert.assertEquals((long)data[i + lastIdx], (long)actual[i]);
            }
            this.counter += actual.length;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            if (this.exception.compareAndSet(null, cause)) {
                ctx.close();
            }
        }
    }
}

