/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.netty.channel.unix;

import java.io.IOException;
import java.nio.channels.Selector;
import shaded.io.netty.channel.unix.LimitsStaticallyReferencedJniMethods;

public final class Unix {
    private static final Throwable UNAVAILABILITY_CAUSE;

    public static boolean isAvailable() {
        return UNAVAILABILITY_CAUSE == null;
    }

    public static void ensureAvailability() {
        if (UNAVAILABILITY_CAUSE != null) {
            throw (Error)new UnsatisfiedLinkError("failed to load the required native library").initCause(UNAVAILABILITY_CAUSE);
        }
    }

    public static Throwable unavailabilityCause() {
        return UNAVAILABILITY_CAUSE;
    }

    private Unix() {
    }

    static {
        Throwable cause = null;
        Selector selector = null;
        try {
            selector = Selector.open();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            try {
                LimitsStaticallyReferencedJniMethods.udsSunPathSize();
            }
            finally {
                try {
                    if (selector != null) {
                        selector.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }
        catch (Throwable error) {
            cause = error;
        }
        UNAVAILABILITY_CAUSE = cause;
    }
}

