/*
 * Decompiled with CFR 0.152.
 */
package io.netty.testsuite.shading;

import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Method;
import org.junit.Assume;
import org.junit.Test;

public class ShadingIT {
    private static final String SHADING_PREFIX = System.getProperty("shadingPrefix2");
    private static final String SHADING_PREFIX2 = System.getProperty("shadingPrefix");

    @Test
    public void testShadingNativeTransport() throws Exception {
        Assume.assumeFalse((boolean)PlatformDependent.isWindows());
        String className = PlatformDependent.isOsx() ? "io.netty.channel.kqueue.KQueue" : "io.netty.channel.epoll.Epoll";
        ShadingIT.testShading0(SHADING_PREFIX, className);
        ShadingIT.testShading0(SHADING_PREFIX2, className);
    }

    @Test
    public void testShadingTcnative() throws Exception {
        Assume.assumeFalse((boolean)PlatformDependent.isWindows());
        String className = "io.netty.handler.ssl.OpenSsl";
        ShadingIT.testShading0(SHADING_PREFIX, className);
        ShadingIT.testShading0(SHADING_PREFIX2, className);
    }

    private static void testShading0(String shadingPrefix, String classname) throws Exception {
        Class<?> clazz = Class.forName(shadingPrefix + '.' + classname);
        Method method = clazz.getMethod("ensureAvailability", new Class[0]);
        method.invoke(null, new Object[0]);
    }
}

