/*
 * Decompiled with CFR 0.152.
 */
package shaded2.io.netty.channel.epoll;

import java.io.IOException;
import java.util.BitSet;
import java.util.Queue;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import shaded2.io.netty.channel.EventLoopGroup;
import shaded2.io.netty.channel.EventLoopTaskQueueFactory;
import shaded2.io.netty.channel.SelectStrategy;
import shaded2.io.netty.channel.SingleThreadEventLoop;
import shaded2.io.netty.channel.epoll.AbstractEpollChannel;
import shaded2.io.netty.channel.epoll.Epoll;
import shaded2.io.netty.channel.epoll.EpollEventArray;
import shaded2.io.netty.channel.epoll.Native;
import shaded2.io.netty.channel.epoll.NativeDatagramPacketArray;
import shaded2.io.netty.channel.unix.FileDescriptor;
import shaded2.io.netty.channel.unix.IovArray;
import shaded2.io.netty.util.IntSupplier;
import shaded2.io.netty.util.collection.IntObjectHashMap;
import shaded2.io.netty.util.collection.IntObjectMap;
import shaded2.io.netty.util.concurrent.RejectedExecutionHandler;
import shaded2.io.netty.util.internal.ObjectUtil;
import shaded2.io.netty.util.internal.PlatformDependent;
import shaded2.io.netty.util.internal.logging.InternalLogger;
import shaded2.io.netty.util.internal.logging.InternalLoggerFactory;

class EpollEventLoop
extends SingleThreadEventLoop {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(EpollEventLoop.class);
    private final AtomicLong nextDeadlineNanos = new AtomicLong(-1L);
    private final AtomicInteger wakenUp = new AtomicInteger(1);
    private boolean pendingWakeup;
    private final FileDescriptor epollFd;
    private final FileDescriptor eventFd;
    private final FileDescriptor timerFd;
    private final IntObjectMap<AbstractEpollChannel> channels = new IntObjectHashMap<AbstractEpollChannel>(4096);
    private final BitSet pendingFlagChannels = new BitSet();
    private final boolean allowGrowing;
    private final EpollEventArray events;
    private IovArray iovArray;
    private NativeDatagramPacketArray datagramPacketArray;
    private final SelectStrategy selectStrategy;
    private final IntSupplier selectNowSupplier = new IntSupplier(){

        @Override
        public int get() throws Exception {
            return EpollEventLoop.this.epollWaitNow();
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    EpollEventLoop(EventLoopGroup parent, Executor executor, int maxEvents, SelectStrategy strategy, RejectedExecutionHandler rejectedExecutionHandler, EventLoopTaskQueueFactory queueFactory) {
        super(parent, executor, false, EpollEventLoop.newTaskQueue(queueFactory), EpollEventLoop.newTaskQueue(queueFactory), rejectedExecutionHandler);
        this.selectStrategy = ObjectUtil.checkNotNull(strategy, "strategy");
        if (maxEvents == 0) {
            this.allowGrowing = true;
            this.events = new EpollEventArray(4096);
        } else {
            this.allowGrowing = false;
            this.events = new EpollEventArray(maxEvents);
        }
        boolean success = false;
        FileDescriptor epollFd = null;
        FileDescriptor eventFd = null;
        FileDescriptor timerFd = null;
        try {
            this.epollFd = epollFd = Native.newEpollCreate();
            this.eventFd = eventFd = Native.newEventFd();
            try {
                Native.epollCtlAdd(epollFd.intValue(), eventFd.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to add eventFd filedescriptor to epoll", e);
            }
            this.timerFd = timerFd = Native.newTimerFd();
            try {
                Native.epollCtlAdd(epollFd.intValue(), timerFd.intValue(), Native.EPOLLIN | Native.EPOLLET);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to add timerFd filedescriptor to epoll", e);
            }
            success = true;
        }
        finally {
            if (!success) {
                if (epollFd != null) {
                    try {
                        epollFd.close();
                    }
                    catch (Exception exception) {}
                }
                if (eventFd != null) {
                    try {
                        eventFd.close();
                    }
                    catch (Exception exception) {}
                }
                if (timerFd != null) {
                    try {
                        timerFd.close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
    }

    private static Queue<Runnable> newTaskQueue(EventLoopTaskQueueFactory queueFactory) {
        if (queueFactory == null) {
            return EpollEventLoop.newTaskQueue0(DEFAULT_MAX_PENDING_TASKS);
        }
        return queueFactory.newTaskQueue(DEFAULT_MAX_PENDING_TASKS);
    }

    IovArray cleanIovArray() {
        if (this.iovArray == null) {
            this.iovArray = new IovArray();
        } else {
            this.iovArray.clear();
        }
        return this.iovArray;
    }

    NativeDatagramPacketArray cleanDatagramPacketArray() {
        if (this.datagramPacketArray == null) {
            this.datagramPacketArray = new NativeDatagramPacketArray();
        } else {
            this.datagramPacketArray.clear();
        }
        return this.datagramPacketArray;
    }

    @Override
    protected boolean beforeScheduledTaskSubmitted(long deadlineNanos) {
        return false;
    }

    @Override
    protected boolean afterScheduledTaskSubmitted(long deadlineNanos) {
        try {
            this.trySetTimerFd(deadlineNanos);
        }
        catch (IOException e) {
            throw new RejectedExecutionException(e);
        }
        return false;
    }

    @Override
    protected boolean runAllTasks() {
        return this.runScheduledAndExecutorTasks(4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySetTimerFd(long candidateNextDeadline) throws IOException {
        long nextDeadline;
        do {
            if ((nextDeadline = this.nextDeadlineNanos.get()) > candidateNextDeadline) continue;
            return;
        } while (!this.nextDeadlineNanos.compareAndSet(nextDeadline, candidateNextDeadline));
        AtomicLong atomicLong = this.nextDeadlineNanos;
        synchronized (atomicLong) {
            nextDeadline = this.nextDeadlineNanos.get();
            if (nextDeadline == candidateNextDeadline || nextDeadline + Long.MAX_VALUE + 1L == candidateNextDeadline) {
                this.setTimerFd(EpollEventLoop.deadlineToDelayNanos(candidateNextDeadline));
            }
        }
    }

    private void setTimerFd(long candidateNextDelayNanos) throws IOException {
        if (candidateNextDelayNanos > 0L) {
            int delaySeconds = (int)Math.min(candidateNextDelayNanos / 1000000000L, Integer.MAX_VALUE);
            int delayNanos = (int)Math.min(candidateNextDelayNanos - (long)delaySeconds * 1000000000L, Integer.MAX_VALUE);
            Native.timerFdSetTime(this.timerFd.intValue(), delaySeconds, delayNanos);
        } else {
            Native.timerFdSetTime(this.timerFd.intValue(), 0, 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long checkScheduleTaskQueueForNewDelay(long timerFdDeadline) throws IOException {
        assert (this.nextDeadlineNanos.get() < 0L);
        long nextTaskDeadlineNanos = this.nextScheduledTaskDeadlineNanos();
        if (nextTaskDeadlineNanos == -1L || nextTaskDeadlineNanos >= timerFdDeadline) {
            this.nextDeadlineNanos.lazySet(timerFdDeadline);
        } else {
            AtomicLong atomicLong = this.nextDeadlineNanos;
            synchronized (atomicLong) {
                timerFdDeadline = nextTaskDeadlineNanos;
                this.nextDeadlineNanos.lazySet(timerFdDeadline);
                this.setTimerFd(EpollEventLoop.deadlineToDelayNanos(timerFdDeadline));
            }
        }
        return timerFdDeadline;
    }

    @Override
    protected void wakeup(boolean inEventLoop) {
        if (!inEventLoop && this.wakenUp.getAndSet(1) == 0) {
            Native.eventFdWrite(this.eventFd.intValue(), 1L);
        }
    }

    void add(AbstractEpollChannel ch) throws IOException {
        assert (this.inEventLoop());
        int fd = ch.socket.intValue();
        Native.epollCtlAdd(this.epollFd.intValue(), fd, ch.flags);
        ch.activeFlags = ch.flags;
        AbstractEpollChannel old = this.channels.put(fd, ch);
        assert (old == null || !old.isOpen());
    }

    void modify(AbstractEpollChannel ch) throws IOException {
        assert (this.inEventLoop());
        Native.epollCtlMod(this.epollFd.intValue(), ch.socket.intValue(), ch.flags);
        ch.activeFlags = ch.flags;
    }

    void updatePendingFlagsSet(AbstractEpollChannel ch) {
        this.pendingFlagChannels.set(ch.socket.intValue(), ch.flags != ch.activeFlags);
    }

    private void processPendingChannelFlags() {
        if (!this.pendingFlagChannels.isEmpty()) {
            int fd = 0;
            while ((fd = this.pendingFlagChannels.nextSetBit(fd)) >= 0) {
                AbstractEpollChannel ch = this.channels.get(fd);
                if (ch != null) {
                    try {
                        ch.modifyEvents();
                    }
                    catch (IOException e) {
                        ch.pipeline().fireExceptionCaught(e);
                        ch.close();
                    }
                }
                this.pendingFlagChannels.clear(fd);
            }
        }
    }

    void remove(AbstractEpollChannel ch) throws IOException {
        assert (this.inEventLoop());
        int fd = ch.socket.intValue();
        AbstractEpollChannel old = this.channels.remove(fd);
        if (old != null && old != ch) {
            this.channels.put(fd, old);
            assert (!ch.isOpen());
        } else {
            ch.activeFlags = 0;
            this.pendingFlagChannels.clear(fd);
            if (ch.isOpen()) {
                Native.epollCtlDel(this.epollFd.intValue(), fd);
            }
        }
    }

    @Override
    protected Queue<Runnable> newTaskQueue(int maxPendingTasks) {
        return EpollEventLoop.newTaskQueue0(maxPendingTasks);
    }

    private static Queue<Runnable> newTaskQueue0(int maxPendingTasks) {
        return maxPendingTasks == Integer.MAX_VALUE ? PlatformDependent.newMpscQueue() : PlatformDependent.newMpscQueue(maxPendingTasks);
    }

    @Override
    public int registeredChannels() {
        return this.channels.size();
    }

    private int epollWait() throws IOException {
        return Native.epollWait(this.epollFd, this.events, false);
    }

    private int epollWaitNow() throws IOException {
        return Native.epollWait(this.epollFd, this.events, true);
    }

    private int epollWaitTimeboxed() throws IOException {
        return Native.epollWait(this.epollFd, this.events, 1000);
    }

    private int epollBusyWait() throws IOException {
        return Native.epollBusyWait(this.epollFd, this.events);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() {
        long timerFdDeadline = Long.MAX_VALUE;
        while (true) {
            try {
                int strategy;
                block15: while (true) {
                    this.processPendingChannelFlags();
                    strategy = this.selectStrategy.calculateStrategy(this.selectNowSupplier, this.hasTasks());
                    switch (strategy) {
                        case -2: {
                            continue block15;
                        }
                        case -3: {
                            strategy = this.epollBusyWait();
                            break block15;
                        }
                        case -1: {
                            if (this.pendingWakeup) {
                                strategy = this.epollWaitTimeboxed();
                                if (strategy != 0) break block15;
                                this.pendingWakeup = false;
                                if (this.hasTasks()) break block15;
                            }
                            this.wakenUp.lazySet(0);
                            try {
                                timerFdDeadline = this.checkScheduleTaskQueueForNewDelay(timerFdDeadline);
                                if (!this.hasTasks()) {
                                    strategy = this.epollWait();
                                }
                                if (this.wakenUp.get() == 1 || this.wakenUp.getAndSet(1) == 1) {
                                    this.pendingWakeup = true;
                                }
                                if (timerFdDeadline < 0L) break block15;
                                timerFdDeadline = this.nextDeadlineNanos.getAndAdd(Long.MIN_VALUE);
                                break block15;
                            }
                            catch (Throwable throwable) {
                                if (this.wakenUp.get() == 1 || this.wakenUp.getAndSet(1) == 1) {
                                    this.pendingWakeup = true;
                                }
                                if (timerFdDeadline >= 0L) {
                                    timerFdDeadline = this.nextDeadlineNanos.getAndAdd(Long.MIN_VALUE);
                                }
                                throw throwable;
                            }
                        }
                    }
                    break;
                }
                try {
                    if (this.processReady(this.events, strategy)) {
                        timerFdDeadline = Long.MAX_VALUE;
                    }
                }
                finally {
                    this.runAllTasks();
                }
                if (this.allowGrowing && strategy == this.events.length()) {
                    this.events.increase();
                }
            }
            catch (Throwable t) {
                this.handleLoopException(t);
            }
            try {
                if (!this.isShuttingDown()) continue;
                this.closeAll();
                if (!this.confirmShutdown()) continue;
            }
            catch (Throwable t) {
                this.handleLoopException(t);
                continue;
            }
            break;
        }
    }

    void handleLoopException(Throwable t) {
        logger.warn("Unexpected exception in the selector loop.", t);
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private void closeAll() {
        AbstractEpollChannel[] localChannels;
        for (AbstractEpollChannel ch : localChannels = this.channels.values().toArray(new AbstractEpollChannel[0])) {
            ch.unsafe().close(ch.unsafe().voidPromise());
        }
    }

    private boolean processReady(EpollEventArray events, int ready) {
        boolean timerFired = false;
        for (int i = 0; i < ready; ++i) {
            int fd = events.fd(i);
            if (fd == this.eventFd.intValue()) {
                this.pendingWakeup = false;
                continue;
            }
            if (fd == this.timerFd.intValue()) {
                timerFired = true;
                continue;
            }
            long ev = events.events(i);
            AbstractEpollChannel ch = this.channels.get(fd);
            if (ch != null) {
                AbstractEpollChannel.AbstractEpollUnsafe unsafe = (AbstractEpollChannel.AbstractEpollUnsafe)ch.unsafe();
                if ((ev & (long)(Native.EPOLLERR | Native.EPOLLOUT)) != 0L) {
                    unsafe.epollOutReady();
                }
                if ((ev & (long)(Native.EPOLLERR | Native.EPOLLIN)) != 0L) {
                    unsafe.epollInReady();
                }
                if ((ev & (long)Native.EPOLLRDHUP) == 0L) continue;
                unsafe.epollRdHupReady();
                continue;
            }
            try {
                Native.epollCtlDel(this.epollFd.intValue(), fd);
                continue;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return timerFired;
    }

    @Override
    protected void cleanup() {
        try {
            try {
                int count;
                block9: while (this.pendingWakeup && (count = this.epollWaitTimeboxed()) != 0) {
                    for (int i = 0; i < count; ++i) {
                        if (this.events.fd(i) != this.eventFd.intValue()) continue;
                        this.pendingWakeup = false;
                        continue block9;
                    }
                }
                this.eventFd.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the event fd.", e);
            }
            try {
                this.epollFd.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the epoll fd.", e);
            }
            try {
                this.timerFd.close();
            }
            catch (IOException e) {
                logger.warn("Failed to close the timer fd.", e);
            }
        }
        finally {
            if (this.iovArray != null) {
                this.iovArray.release();
                this.iovArray = null;
            }
            if (this.datagramPacketArray != null) {
                this.datagramPacketArray.release();
                this.datagramPacketArray = null;
            }
            this.events.free();
        }
    }

    static {
        Epoll.ensureAvailability();
    }
}

