/*
 * Decompiled with CFR 0.152.
 */
package shaded.io.netty.channel.epoll;

import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import shaded.io.netty.buffer.ByteBuf;
import shaded.io.netty.channel.ChannelOutboundBuffer;
import shaded.io.netty.channel.socket.DatagramPacket;
import shaded.io.netty.channel.unix.IovArray;
import shaded.io.netty.channel.unix.Limits;
import shaded.io.netty.channel.unix.NativeInetAddress;

final class NativeDatagramPacketArray
implements ChannelOutboundBuffer.MessageProcessor {
    private final NativeDatagramPacket[] packets = new NativeDatagramPacket[Limits.UIO_MAX_IOV];
    private int count;

    NativeDatagramPacketArray() {
        for (int i = 0; i < this.packets.length; ++i) {
            this.packets[i] = new NativeDatagramPacket();
        }
    }

    boolean add(DatagramPacket packet) {
        if (this.count == this.packets.length) {
            return false;
        }
        ByteBuf content = (ByteBuf)packet.content();
        int len = content.readableBytes();
        if (len == 0) {
            return true;
        }
        NativeDatagramPacket p = this.packets[this.count];
        InetSocketAddress recipient = (InetSocketAddress)packet.recipient();
        if (!p.init(content, recipient)) {
            return false;
        }
        ++this.count;
        return true;
    }

    @Override
    public boolean processMessage(Object msg) {
        return msg instanceof DatagramPacket && this.add((DatagramPacket)msg);
    }

    int count() {
        return this.count;
    }

    NativeDatagramPacket[] packets() {
        return this.packets;
    }

    void clear() {
        this.count = 0;
    }

    void release() {
        for (NativeDatagramPacket datagramPacket : this.packets) {
            datagramPacket.release();
        }
    }

    static final class NativeDatagramPacket {
        private final IovArray array = new IovArray();
        private long memoryAddress;
        private int count;
        private byte[] addr;
        private int scopeId;
        private int port;

        NativeDatagramPacket() {
        }

        private void release() {
            this.array.release();
        }

        private boolean init(ByteBuf buf, InetSocketAddress recipient) {
            this.array.clear();
            if (!this.array.add(buf)) {
                return false;
            }
            this.memoryAddress = this.array.memoryAddress(0);
            this.count = this.array.count();
            InetAddress address = recipient.getAddress();
            if (address instanceof Inet6Address) {
                this.addr = address.getAddress();
                this.scopeId = ((Inet6Address)address).getScopeId();
            } else {
                this.addr = NativeInetAddress.ipv4MappedIpv6Address(address.getAddress());
                this.scopeId = 0;
            }
            this.port = recipient.getPort();
            return true;
        }
    }
}

