/*
 * Decompiled with CFR 0.152.
 */
package io.netty.osgitests;

import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;

@RunWith(value=PaxExam.class)
public class OsgiBundleTest {
    private static final Collection<String> LINKS;

    @Configuration
    public final Option[] config() {
        ArrayList<Object> options = new ArrayList<Object>();
        options.add(CoreOptions.frameworkProperty((String)"org.osgi.framework.bootdelegation").value((Object)"com.sun.*"));
        options.add(CoreOptions.systemProperty((String)"pax.exam.osgi.unresolved.fail").value("true"));
        options.add(CoreOptions.junitBundles());
        for (String link : LINKS) {
            options.add(CoreOptions.url((String)("link:classpath:" + link)));
        }
        return options.toArray(new Option[0]);
    }

    @Test
    public void testResolvedBundles() {
        Assert.assertFalse((String)"At least one bundle needs to be tested", (boolean)LINKS.isEmpty());
    }

    @Test
    public void testCanLoadPlatformDependent() {
        Assert.assertFalse((PlatformDependent.addressSize() == 0 ? 1 : 0) != 0);
    }

    static {
        HashSet<String> links = new HashSet<String>();
        File directory = new File("target/generated-test-resources/alta/");
        File[] files = directory.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return (name.startsWith("io.netty") || name.startsWith("com.barchart.udt")) && name.endsWith(".link");
            }
        });
        if (files == null) {
            throw new IllegalStateException(directory + " is not found or is not a directory");
        }
        for (File f : files) {
            links.add(f.getName());
        }
        LINKS = links;
    }
}

