/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.MessageList;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.codec.MessageToMessageDecoder;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpObject;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.LastHttpContent;

public abstract class HttpContentDecoder
extends MessageToMessageDecoder<HttpObject> {
    private EmbeddedChannel decoder;
    private HttpMessage message;
    private boolean decodeStarted;
    private boolean continueResponse;

    @Override
    protected void decode(ChannelHandlerContext ctx, HttpObject msg, MessageList<Object> out) throws Exception {
        if (msg instanceof HttpResponse && ((HttpResponse)msg).getStatus().code() == 100) {
            if (!(msg instanceof LastHttpContent)) {
                this.continueResponse = true;
            }
            out.add(ByteBufUtil.retain(msg));
            return;
        }
        if (this.continueResponse) {
            if (msg instanceof LastHttpContent) {
                this.continueResponse = false;
            }
            out.add(ByteBufUtil.retain(msg));
            return;
        }
        if (msg instanceof HttpMessage) {
            assert (this.message == null);
            this.message = (HttpMessage)msg;
            this.decodeStarted = false;
            this.cleanup();
        }
        if (msg instanceof HttpContent) {
            HttpContent c = (HttpContent)msg;
            if (!this.decodeStarted) {
                this.decodeStarted = true;
                HttpMessage message = this.message;
                HttpHeaders headers = message.headers();
                this.message = null;
                String contentEncoding = headers.get("Content-Encoding");
                contentEncoding = contentEncoding != null ? contentEncoding.trim() : "identity";
                this.decoder = this.newContentDecoder(contentEncoding);
                if (this.decoder != null) {
                    String targetContentEncoding = this.getTargetContentEncoding(contentEncoding);
                    if ("identity".equals(targetContentEncoding)) {
                        headers.remove("Content-Encoding");
                    } else {
                        headers.set("Content-Encoding", targetContentEncoding);
                    }
                    Object[] decoded = this.decodeContent(message, c);
                    if (headers.contains("Content-Length")) {
                        headers.set("Content-Length", Integer.toString(((ByteBufHolder)decoded[1]).content().readableBytes()));
                    }
                    out.add((Object[])decoded);
                    return;
                }
                if (c instanceof LastHttpContent) {
                    this.decodeStarted = false;
                }
                out.add(message);
                out.add(c.retain());
                return;
            }
            if (this.decoder != null) {
                out.add((Object[])this.decodeContent(null, c));
            } else {
                if (c instanceof LastHttpContent) {
                    this.decodeStarted = false;
                }
                out.add(c.retain());
            }
        }
    }

    private Object[] decodeContent(HttpMessage header, HttpContent c) {
        ByteBuf newContent = Unpooled.buffer();
        ByteBuf content = c.content();
        this.decode(content, newContent);
        if (c instanceof LastHttpContent) {
            ByteBuf lastProduct = Unpooled.buffer();
            this.finishDecode(lastProduct);
            if (lastProduct.isReadable()) {
                if (header == null) {
                    return new Object[]{new DefaultHttpContent(newContent), new DefaultLastHttpContent(lastProduct)};
                }
                return new Object[]{header, new DefaultHttpContent(newContent), new DefaultLastHttpContent(lastProduct)};
            }
            if (header == null) {
                return new Object[]{new DefaultLastHttpContent(newContent)};
            }
            return new Object[]{header, new DefaultLastHttpContent(newContent)};
        }
        if (header == null) {
            return new Object[]{new DefaultHttpContent(newContent)};
        }
        return new Object[]{header, new DefaultHttpContent(newContent)};
    }

    protected abstract EmbeddedChannel newContentDecoder(String var1) throws Exception;

    protected String getTargetContentEncoding(String contentEncoding) throws Exception {
        return "identity";
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.handlerRemoved(ctx);
    }

    @Override
    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.cleanup();
        super.channelInactive(ctx);
    }

    private void cleanup() {
        if (this.decoder != null) {
            this.finishDecode(Unpooled.buffer());
        }
    }

    private void decode(ByteBuf in, ByteBuf out) {
        this.decoder.writeInbound(in.retain());
        this.fetchDecoderOutput(out);
    }

    private void finishDecode(ByteBuf out) {
        if (this.decoder.finish()) {
            this.fetchDecoderOutput(out);
        }
        this.decodeStarted = false;
        this.decoder = null;
    }

    private void fetchDecoderOutput(ByteBuf out) {
        ByteBuf buf;
        while ((buf = (ByteBuf)this.decoder.readInbound()) != null) {
            out.writeBytes(buf);
        }
    }
}

