/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.aio;

import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ConnectTimeoutException;
import io.netty.channel.EventLoop;
import io.netty.channel.aio.AioEventLoop;
import java.net.ConnectException;
import java.net.SocketAddress;
import java.nio.channels.AsynchronousChannel;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public abstract class AbstractAioChannel
extends AbstractChannel {
    protected volatile AsynchronousChannel ch;
    protected ChannelPromise connectPromise;
    protected ScheduledFuture<?> connectTimeoutFuture;
    private SocketAddress requestedRemoteAddress;

    protected AbstractAioChannel(Channel parent, Integer id, AsynchronousChannel ch) {
        super(parent, id);
        this.ch = ch;
    }

    protected AsynchronousChannel javaChannel() {
        if (this.ch == null) {
            throw new IllegalStateException("Try to access Channel before eventLoop was registered");
        }
        return this.ch;
    }

    @Override
    public boolean isOpen() {
        if (this.ch == null) {
            return true;
        }
        return this.ch.isOpen();
    }

    @Override
    protected boolean isCompatible(EventLoop loop) {
        return loop instanceof AioEventLoop;
    }

    @Override
    protected AbstractChannel.AbstractUnsafe newUnsafe() {
        return new DefaultAioUnsafe();
    }

    protected abstract void doConnect(SocketAddress var1, SocketAddress var2, ChannelPromise var3);

    protected final class DefaultAioUnsafe
    extends AbstractChannel.AbstractUnsafe {
        protected DefaultAioUnsafe() {
        }

        @Override
        public void connect(final SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
            if (!this.ensureOpen(promise)) {
                return;
            }
            try {
                if (AbstractAioChannel.this.connectPromise != null) {
                    throw new IllegalStateException("connection attempt already made");
                }
                AbstractAioChannel.this.connectPromise = promise;
                AbstractAioChannel.this.requestedRemoteAddress = remoteAddress;
                AbstractAioChannel.this.doConnect(remoteAddress, localAddress, promise);
                int connectTimeoutMillis = AbstractAioChannel.this.config().getConnectTimeoutMillis();
                if (connectTimeoutMillis > 0) {
                    AbstractAioChannel.this.connectTimeoutFuture = AbstractAioChannel.this.eventLoop().schedule(new Runnable(){

                        @Override
                        public void run() {
                            ChannelPromise connectFuture = AbstractAioChannel.this.connectPromise;
                            ConnectTimeoutException cause = new ConnectTimeoutException("connection timed out: " + remoteAddress);
                            if (connectFuture != null && connectFuture.tryFailure(cause)) {
                                DefaultAioUnsafe.this.close(AbstractAioChannel.this.voidPromise());
                            }
                        }
                    }, (long)connectTimeoutMillis, TimeUnit.MILLISECONDS);
                }
            }
            catch (Throwable t2) {
                ConnectException t2;
                if (t2 instanceof ConnectException) {
                    ConnectException newT = new ConnectException(t2.getMessage() + ": " + remoteAddress);
                    newT.setStackTrace(t2.getStackTrace());
                    t2 = newT;
                }
                promise.setFailure(t2);
                this.closeIfClosed();
            }
        }

        public void connectFailed(Throwable t) {
            if (t instanceof ConnectException) {
                ConnectException newT = new ConnectException(t.getMessage() + ": " + AbstractAioChannel.this.requestedRemoteAddress);
                newT.setStackTrace(t.getStackTrace());
                t = newT;
            }
            AbstractAioChannel.this.connectPromise.setFailure(t);
            this.closeIfClosed();
        }

        public void connectSuccess() {
            assert (AbstractAioChannel.this.eventLoop().inEventLoop());
            assert (AbstractAioChannel.this.connectPromise != null);
            try {
                AbstractAioChannel.this.connectPromise.setSuccess();
                AbstractAioChannel.this.pipeline().fireChannelActive();
            }
            catch (Throwable t) {
                AbstractAioChannel.this.connectPromise.setFailure(t);
                this.closeIfClosed();
            }
            finally {
                AbstractAioChannel.this.connectTimeoutFuture.cancel(false);
                AbstractAioChannel.this.connectPromise = null;
            }
        }
    }
}

