/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel;

import io.netty.buffer.Buf;
import io.netty.buffer.BufType;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.MessageBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.AbstractChannel;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerUtil;
import io.netty.channel.ChannelInboundByteHandler;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInboundMessageHandler;
import io.netty.channel.ChannelOperationHandler;
import io.netty.channel.ChannelOutboundByteHandler;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundMessageHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPipelineException;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelStateHandler;
import io.netty.channel.DefaultChannelPipeline;
import io.netty.channel.DefaultChannelProgressivePromise;
import io.netty.channel.DefaultChannelPromise;
import io.netty.channel.FailedChannelFuture;
import io.netty.channel.FileRegion;
import io.netty.channel.NoSuchBufferException;
import io.netty.channel.SucceededChannelFuture;
import io.netty.channel.VoidChannelPromise;
import io.netty.util.DefaultAttributeMap;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.PlatformDependent;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Collection;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;

final class DefaultChannelHandlerContext
extends DefaultAttributeMap
implements ChannelHandlerContext {
    private static final int FLAG_REMOVED = 1;
    private static final int FLAG_FREED = 2;
    private static final int FLAG_FREED_INBOUND = 4;
    private static final int FLAG_FREED_OUTBOUND = 8;
    volatile DefaultChannelHandlerContext next;
    volatile DefaultChannelHandlerContext prev;
    private final Channel channel;
    private final DefaultChannelPipeline pipeline;
    private final String name;
    private final ChannelHandler handler;
    final EventExecutor executor;
    private ChannelFuture succeededFuture;
    private final MessageBuf<Object> inMsgBuf;
    private final ByteBuf inByteBuf;
    private MessageBuf<Object> outMsgBuf;
    private ByteBuf outByteBuf;
    private short callDepth;
    private short flags;
    private volatile Queue<Object> inBridge;
    private volatile Queue<Object> outBridge;
    private volatile NextBridgeFeeder nextInBridgeFeeder;
    private volatile NextBridgeFeeder nextOutBridgeFeeder;
    private static final AtomicReferenceFieldUpdater<DefaultChannelHandlerContext, Queue> IN_BRIDGE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelHandlerContext.class, Queue.class, "inBridge");
    private static final AtomicReferenceFieldUpdater<DefaultChannelHandlerContext, Queue> OUT_BRIDGE_UPDATER = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelHandlerContext.class, Queue.class, "outBridge");
    private static final AtomicReferenceFieldUpdater<DefaultChannelHandlerContext, NextBridgeFeeder> NEXT_IN_BRIDGE_FEEDER = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelHandlerContext.class, NextBridgeFeeder.class, "nextInBridgeFeeder");
    private static final AtomicReferenceFieldUpdater<DefaultChannelHandlerContext, NextBridgeFeeder> NEXT_OUT_BRIDGE_FEEDER = AtomicReferenceFieldUpdater.newUpdater(DefaultChannelHandlerContext.class, NextBridgeFeeder.class, "nextOutBridgeFeeder");
    private Runnable invokeInboundBufferUpdatedTask;
    private Runnable fireInboundBufferUpdated0Task;
    private Runnable invokeChannelReadSuspendedTask;
    private Runnable invokeRead0Task;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    DefaultChannelHandlerContext(DefaultChannelPipeline pipeline, EventExecutorGroup group, String name, ChannelHandler handler) {
        Buf buf;
        if (name == null) {
            throw new NullPointerException("name");
        }
        if (handler == null) {
            throw new NullPointerException("handler");
        }
        this.channel = pipeline.channel;
        this.pipeline = pipeline;
        this.name = name;
        this.handler = handler;
        if (group != null) {
            EventExecutor childExecutor = pipeline.childExecutors.get(group);
            if (childExecutor == null) {
                childExecutor = group.next();
                pipeline.childExecutors.put(group, childExecutor);
            }
            this.executor = childExecutor;
        } else {
            this.executor = null;
        }
        if (handler instanceof ChannelInboundHandler) {
            try {
                buf = ((ChannelInboundHandler)handler).newInboundBuffer(this);
            }
            catch (Exception e) {
                throw new ChannelPipelineException(handler.getClass().getSimpleName() + ".newInboundBuffer() raised an exception.", e);
            }
            if (buf instanceof ByteBuf) {
                this.inByteBuf = (ByteBuf)buf;
                this.inMsgBuf = null;
            } else {
                if (!(buf instanceof MessageBuf)) throw new ChannelPipelineException(handler.getClass().getSimpleName() + ".newInboundBuffer() returned neither " + ByteBuf.class.getSimpleName() + " nor " + MessageBuf.class.getSimpleName() + ": " + buf);
                this.inMsgBuf = (MessageBuf)buf;
                this.inByteBuf = null;
            }
        } else {
            this.inByteBuf = null;
            this.inMsgBuf = null;
        }
        if (!(handler instanceof ChannelOutboundHandler)) return;
        try {
            buf = ((ChannelOutboundHandler)handler).newOutboundBuffer(this);
        }
        catch (Exception e) {
            throw new ChannelPipelineException(handler.getClass().getSimpleName() + ".newOutboundBuffer() raised an exception.", e);
        }
        if (buf instanceof ByteBuf) {
            this.outByteBuf = (ByteBuf)buf;
            return;
        } else {
            MessageBuf msgBuf;
            if (!(buf instanceof MessageBuf)) throw new ChannelPipelineException(handler.getClass().getSimpleName() + ".newOutboundBuffer() returned neither " + ByteBuf.class.getSimpleName() + " nor " + MessageBuf.class.getSimpleName() + ": " + buf);
            this.outMsgBuf = msgBuf = (MessageBuf)buf;
        }
    }

    DefaultChannelHandlerContext(DefaultChannelPipeline pipeline, String name, DefaultChannelPipeline.HeadHandler handler) {
        this.channel = pipeline.channel;
        this.pipeline = pipeline;
        this.name = name;
        this.handler = handler;
        this.executor = null;
        this.inByteBuf = null;
        this.inMsgBuf = null;
    }

    DefaultChannelHandlerContext(DefaultChannelPipeline pipeline, String name, DefaultChannelPipeline.TailHandler handler) {
        this.channel = pipeline.channel;
        this.pipeline = pipeline;
        this.name = name;
        this.handler = handler;
        this.executor = null;
        this.inByteBuf = handler.byteSink;
        this.inMsgBuf = handler.msgSink;
        this.outByteBuf = null;
        this.outMsgBuf = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void forwardBufferContentAndFree(final DefaultChannelHandlerContext forwardPrev, final DefaultChannelHandlerContext forwardNext) {
        EventExecutor executor;
        boolean flush = false;
        boolean inboundBufferUpdated = false;
        try {
            if (!this.isOutboundFreed()) {
                Buf forwardPrevBuf;
                if (this.hasOutboundByteBuffer() && this.outboundByteBuffer().isReadable()) {
                    forwardPrevBuf = forwardPrev.hasOutboundByteBuffer() ? forwardPrev.outboundByteBuffer() : forwardPrev.nextOutboundByteBuffer();
                    forwardPrevBuf.writeBytes(this.outboundByteBuffer());
                    flush = true;
                }
                if (this.hasOutboundMessageBuffer() && !this.outboundMessageBuffer().isEmpty()) {
                    forwardPrevBuf = forwardPrev.hasOutboundMessageBuffer() ? forwardPrev.outboundMessageBuffer() : forwardPrev.nextOutboundMessageBuffer();
                    if (this.outboundMessageBuffer().drainTo((Collection)((Object)forwardPrevBuf)) > 0) {
                        flush = true;
                    }
                }
            }
            if (!this.isInboundFreed()) {
                Buf forwardNextBuf;
                if (this.hasInboundByteBuffer() && this.inboundByteBuffer().isReadable()) {
                    forwardNextBuf = forwardNext.hasInboundByteBuffer() ? forwardNext.inboundByteBuffer() : forwardNext.nextInboundByteBuffer();
                    forwardNextBuf.writeBytes(this.inboundByteBuffer());
                    inboundBufferUpdated = true;
                }
                if (this.hasInboundMessageBuffer() && !this.inboundMessageBuffer().isEmpty()) {
                    forwardNextBuf = forwardNext.hasInboundMessageBuffer() ? forwardNext.inboundMessageBuffer() : forwardNext.nextInboundMessageBuffer();
                    if (this.inboundMessageBuffer().drainTo((Collection)((Object)forwardNextBuf)) > 0) {
                        inboundBufferUpdated = true;
                    }
                }
            }
        }
        finally {
            this.flags = (short)(this.flags | 1);
            this.freeAllIfRemoved();
        }
        if (flush) {
            Thread currentThread;
            executor = this.executor();
            if (executor.inEventLoop(currentThread = Thread.currentThread())) {
                this.invokePrevFlush(this.newPromise(), currentThread, DefaultChannelHandlerContext.findContextOutboundInclusive(forwardPrev));
            } else {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelHandlerContext.this.invokePrevFlush(DefaultChannelHandlerContext.this.newPromise(), Thread.currentThread(), DefaultChannelHandlerContext.findContextOutboundInclusive(forwardPrev));
                    }
                });
            }
        }
        if (inboundBufferUpdated) {
            executor = this.executor();
            if (executor.inEventLoop()) {
                this.fireInboundBufferUpdated0(DefaultChannelHandlerContext.findContextInboundInclusive(forwardNext));
            } else {
                executor.execute(new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelHandlerContext.this.fireInboundBufferUpdated0(DefaultChannelHandlerContext.findContextInboundInclusive(forwardNext));
                    }
                });
            }
        }
    }

    private static DefaultChannelHandlerContext findContextOutboundInclusive(DefaultChannelHandlerContext ctx) {
        if (ctx.handler() instanceof ChannelOperationHandler) {
            return ctx;
        }
        return ctx.findContextOutbound();
    }

    private static DefaultChannelHandlerContext findContextInboundInclusive(DefaultChannelHandlerContext ctx) {
        if (ctx.handler() instanceof ChannelStateHandler) {
            return ctx;
        }
        return ctx.findContextInbound();
    }

    void clearBuffer() {
        if (this.hasOutboundByteBuffer()) {
            this.outboundByteBuffer().clear();
        }
        if (this.hasOutboundMessageBuffer()) {
            this.outboundMessageBuffer().clear();
        }
        if (this.hasInboundByteBuffer()) {
            this.inboundByteBuffer().clear();
        }
        if (this.hasInboundMessageBuffer()) {
            this.inboundMessageBuffer().clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initHeadHandler() {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            DefaultChannelPipeline.HeadHandler h = (DefaultChannelPipeline.HeadHandler)this.handler;
            if (h.initialized) {
                return;
            }
            h.init(this);
            h.initialized = true;
            this.outByteBuf = h.byteSink;
            this.outMsgBuf = h.msgSink;
        } else {
            Future<?> f = executor.submit(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.initHeadHandler();
                }
            });
            boolean interrupted = false;
            try {
                while (!f.isDone()) {
                    try {
                        f.get();
                    }
                    catch (InterruptedException e) {
                        interrupted = true;
                    }
                    catch (ExecutionException e) {
                        PlatformDependent.throwException(e);
                    }
                }
            }
            finally {
                if (interrupted) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private boolean flushInboundBridge() {
        Queue<Object> inBridge = this.inBridge;
        if (inBridge == null) {
            return true;
        }
        return DefaultChannelHandlerContext.flushBridge(inBridge, this.inMsgBuf, this.inByteBuf);
    }

    private boolean flushOutboundBridge() {
        Queue<Object> outBridge = this.outBridge;
        if (outBridge == null) {
            return true;
        }
        return DefaultChannelHandlerContext.flushBridge(outBridge, this.outMsgBuf, this.outByteBuf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean flushBridge(Queue<Object> bridge, MessageBuf<Object> msgBuf, ByteBuf byteBuf) {
        Object o;
        if (bridge == null) {
            return true;
        }
        boolean nextBufferHadEnoughRoom = true;
        block7: while ((o = bridge.peek()) != null) {
            try {
                Object data;
                if (o instanceof Object[]) {
                    Object m;
                    data = (Object[])o;
                    for (int i = 0; i < ((Object[])data).length && (m = data[i]) != null; ++i) {
                        if (!msgBuf.offer(m)) {
                            System.arraycopy(data, i, data, 0, ((Object)data).length - i);
                            for (int j = i + 1; j < ((Object)data).length; ++j) {
                                data[j] = null;
                            }
                            nextBufferHadEnoughRoom = false;
                            continue block7;
                        }
                        data[i] = null;
                    }
                    continue;
                }
                if (o instanceof ByteBuf) {
                    data = (ByteBuf)o;
                    if (byteBuf.writerIndex() <= byteBuf.maxCapacity() - data.readableBytes()) {
                        try {
                            byteBuf.writeBytes((ByteBuf)data);
                            continue;
                        }
                        finally {
                            data.release();
                            continue;
                        }
                    }
                } else {
                    throw new Error();
                }
                byteBuf.capacity(byteBuf.maxCapacity());
                byteBuf.writeBytes((ByteBuf)data, byteBuf.writableBytes());
                nextBufferHadEnoughRoom = false;
                break;
            }
            finally {
                if (!nextBufferHadEnoughRoom) continue;
                Object removed = bridge.remove();
                if ($assertionsDisabled || removed == o) continue;
                throw new AssertionError();
            }
        }
        return nextBufferHadEnoughRoom;
    }

    private boolean isInboundFreed() {
        return (this.flags & 4) != 0;
    }

    private boolean isOutboundFreed() {
        return (this.flags & 8) != 0;
    }

    private void freeAllIfRemoved() {
        if (this.callDepth != 0) {
            return;
        }
        short flags = this.flags;
        if ((flags & 1) != 0 && (flags & 2) == 0) {
            try {
                DefaultChannelHandlerContext.safeFree(this.inByteBuf);
                DefaultChannelHandlerContext.safeFree(this.inMsgBuf);
                DefaultChannelHandlerContext.safeFree(this.outByteBuf);
                DefaultChannelHandlerContext.safeFree(this.outMsgBuf);
            }
            finally {
                this.flags = (short)(flags | 2 | 4 | 8);
                this.freeNextInboundBridgeFeeder();
                this.freeNextOutboundBridgeFeeder();
            }
        }
    }

    void freeInbound() {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.freeInbound0();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.freeInbound0();
                }
            });
        }
    }

    private void freeInbound0() {
        try {
            DefaultChannelHandlerContext.safeFree(this.inByteBuf);
            DefaultChannelHandlerContext.safeFree(this.inMsgBuf);
        }
        finally {
            this.flags = (short)(this.flags | 4);
            this.freeNextInboundBridgeFeeder();
        }
        if (this.next != null) {
            DefaultChannelHandlerContext nextCtx = this.findContextInbound();
            nextCtx.freeInbound();
        } else {
            this.pipeline.tail.prev.freeOutboundAndRemove();
        }
    }

    private void freeOutboundAndRemove() {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.freeOutboundAndRemove0();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.freeOutboundAndRemove0();
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void freeOutboundAndRemove0() {
        DefaultChannelHandlerContext prev;
        if (this.handler instanceof ChannelOperationHandler) {
            try {
                DefaultChannelHandlerContext.safeFree(this.outByteBuf);
                DefaultChannelHandlerContext.safeFree(this.outMsgBuf);
            }
            finally {
                this.flags = (short)(this.flags | 0xA);
                this.freeNextOutboundBridgeFeeder();
            }
        }
        if ((prev = this.prev) != null) {
            DefaultChannelPipeline defaultChannelPipeline = this.pipeline;
            synchronized (defaultChannelPipeline) {
                this.pipeline.remove0(this, false);
            }
            prev.freeOutboundAndRemove();
        }
    }

    private void freeNextInboundBridgeFeeder() {
        Queue<Object> bridge;
        NextBridgeFeeder feeder = this.nextInBridgeFeeder;
        if (feeder != null) {
            feeder.release();
            this.nextInBridgeFeeder = null;
        }
        if (DefaultChannelPipeline.logger.isWarnEnabled() && (bridge = this.inBridge) != null && !bridge.isEmpty()) {
            DefaultChannelPipeline.logger.warn("inbound bridge not empty - bug?: {}", (Object)bridge.size());
        }
    }

    private void freeNextOutboundBridgeFeeder() {
        Queue<Object> bridge;
        NextBridgeFeeder feeder = this.nextOutBridgeFeeder;
        if (feeder != null) {
            feeder.release();
            this.nextOutBridgeFeeder = null;
        }
        if (DefaultChannelPipeline.logger.isWarnEnabled() && (bridge = this.outBridge) != null && !bridge.isEmpty()) {
            DefaultChannelPipeline.logger.warn("outbound bridge not empty - bug?: {}", (Object)bridge.size());
        }
    }

    private static void safeFree(Buf buf) {
        if (buf != null) {
            try {
                buf.release();
            }
            catch (Exception e) {
                DefaultChannelPipeline.logger.warn("Failed to release a handler buffer.", e);
            }
        }
    }

    @Override
    public Channel channel() {
        return this.channel;
    }

    @Override
    public ChannelPipeline pipeline() {
        return this.pipeline;
    }

    @Override
    public ByteBufAllocator alloc() {
        return this.channel().config().getAllocator();
    }

    @Override
    public EventExecutor executor() {
        if (this.executor == null) {
            return this.channel().eventLoop();
        }
        return this.executor;
    }

    @Override
    public ChannelHandler handler() {
        return this.handler;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean hasInboundByteBuffer() {
        return this.inByteBuf != null;
    }

    @Override
    public boolean hasInboundMessageBuffer() {
        return this.inMsgBuf != null;
    }

    @Override
    public ByteBuf inboundByteBuffer() {
        if (this.inByteBuf == null) {
            throw new NoSuchBufferException(String.format("the handler '%s' has no inbound byte buffer; it does not implement %s.", this.name, ChannelInboundByteHandler.class.getSimpleName()));
        }
        return this.inByteBuf;
    }

    @Override
    public <T> MessageBuf<T> inboundMessageBuffer() {
        if (this.inMsgBuf == null) {
            throw new NoSuchBufferException(String.format("the handler '%s' has no inbound message buffer; it does not implement %s.", this.name, ChannelInboundMessageHandler.class.getSimpleName()));
        }
        return this.inMsgBuf;
    }

    @Override
    public boolean hasOutboundByteBuffer() {
        return this.outByteBuf != null;
    }

    @Override
    public boolean hasOutboundMessageBuffer() {
        return this.outMsgBuf != null;
    }

    @Override
    public ByteBuf outboundByteBuffer() {
        if (this.outByteBuf == null) {
            throw new NoSuchBufferException(String.format("the handler '%s' has no outbound byte buffer; it does not implement %s.", this.name, ChannelOutboundByteHandler.class.getSimpleName()));
        }
        return this.outByteBuf;
    }

    @Override
    public <T> MessageBuf<T> outboundMessageBuffer() {
        if (this.outMsgBuf == null) {
            throw new NoSuchBufferException(String.format("the handler '%s' has no outbound message buffer; it does not implement %s.", this.name, ChannelOutboundMessageHandler.class.getSimpleName()));
        }
        return this.outMsgBuf;
    }

    @Override
    public ByteBuf nextInboundByteBuffer() {
        DefaultChannelHandlerContext ctx = this.next;
        while (true) {
            if (ctx.hasInboundByteBuffer()) {
                Thread currentThread = Thread.currentThread();
                if (ctx.executor().inEventLoop(currentThread)) {
                    return ctx.inByteBuf;
                }
                if (this.executor().inEventLoop(currentThread)) {
                    return this.nextInBridgeFeeder().byteBuf;
                }
                throw new IllegalStateException("nextInboundByteBuffer() called from outside the eventLoop");
            }
            ctx = ctx.next;
        }
    }

    @Override
    public MessageBuf<Object> nextInboundMessageBuffer() {
        DefaultChannelHandlerContext ctx = this.next;
        while (true) {
            if (ctx.hasInboundMessageBuffer()) {
                Thread currentThread = Thread.currentThread();
                if (ctx.executor().inEventLoop(currentThread)) {
                    return ctx.inMsgBuf;
                }
                if (this.executor().inEventLoop(currentThread)) {
                    return this.nextInBridgeFeeder().msgBuf;
                }
                throw new IllegalStateException("nextInboundMessageBuffer() called from outside the eventLoop");
            }
            ctx = ctx.next;
        }
    }

    private NextBridgeFeeder nextInBridgeFeeder() {
        NextBridgeFeeder feeder = this.nextInBridgeFeeder;
        if (feeder == null && !NEXT_IN_BRIDGE_FEEDER.compareAndSet(this, null, feeder = new NextInboundBridgeFeeder())) {
            feeder.release();
            feeder = this.nextInBridgeFeeder;
        }
        return feeder;
    }

    @Override
    public ByteBuf nextOutboundByteBuffer() {
        DefaultChannelHandlerContext ctx = this.prev;
        while (true) {
            if (ctx.hasOutboundByteBuffer()) {
                Thread currentThread = Thread.currentThread();
                if (ctx.executor().inEventLoop(currentThread)) {
                    return ctx.outboundByteBuffer();
                }
                if (this.executor().inEventLoop(currentThread)) {
                    return this.nextOutBridgeFeeder().byteBuf;
                }
                throw new IllegalStateException("nextOutboundByteBuffer() called from outside the eventLoop");
            }
            ctx = ctx.prev;
        }
    }

    @Override
    public MessageBuf<Object> nextOutboundMessageBuffer() {
        DefaultChannelHandlerContext ctx = this.prev;
        while (true) {
            if (ctx.hasOutboundMessageBuffer()) {
                Thread currentThread = Thread.currentThread();
                if (ctx.executor().inEventLoop(currentThread)) {
                    return ctx.outboundMessageBuffer();
                }
                if (this.executor().inEventLoop(currentThread)) {
                    return this.nextOutBridgeFeeder().msgBuf;
                }
                throw new IllegalStateException("nextOutboundMessageBuffer() called from outside the eventLoop");
            }
            ctx = ctx.prev;
        }
    }

    private NextBridgeFeeder nextOutBridgeFeeder() {
        NextBridgeFeeder feeder = this.nextOutBridgeFeeder;
        if (feeder == null && !NEXT_OUT_BRIDGE_FEEDER.compareAndSet(this, null, feeder = new NextOutboundBridgeFeeder())) {
            feeder.release();
            feeder = this.nextOutBridgeFeeder;
        }
        return feeder;
    }

    @Override
    public ChannelHandlerContext fireChannelRegistered() {
        final DefaultChannelHandlerContext next = this.findContextInbound();
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelRegistered();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    next.invokeChannelRegistered();
                }
            });
        }
        return this;
    }

    private void invokeChannelRegistered() {
        this.callDepth = (short)(this.callDepth + 1);
        try {
            ((ChannelStateHandler)this.handler()).channelRegistered(this);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelUnregistered() {
        final DefaultChannelHandlerContext next = this.findContextInbound();
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelUnregistered();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    next.invokeChannelUnregistered();
                }
            });
        }
        return this;
    }

    private void invokeChannelUnregistered() {
        this.callDepth = (short)(this.callDepth + 1);
        try {
            ((ChannelStateHandler)this.handler()).channelUnregistered(this);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
        }
    }

    @Override
    public ChannelHandlerContext fireChannelActive() {
        final DefaultChannelHandlerContext next = this.findContextInbound();
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelActive();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    next.invokeChannelActive();
                }
            });
        }
        return this;
    }

    private void invokeChannelActive() {
        this.callDepth = (short)(this.callDepth + 1);
        try {
            ((ChannelStateHandler)this.handler()).channelActive(this);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelHandlerContext fireChannelInactive() {
        final DefaultChannelHandlerContext next = this.findContextInbound();
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelInactive();
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    next.invokeChannelInactive();
                }
            });
        }
        return this;
    }

    private void invokeChannelInactive() {
        this.callDepth = (short)(this.callDepth + 1);
        try {
            ((ChannelStateHandler)this.handler()).channelInactive(this);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelHandlerContext fireExceptionCaught(Throwable cause) {
        if (cause == null) {
            throw new NullPointerException("cause");
        }
        this.next.invokeExceptionCaught(cause);
        return this;
    }

    private void invokeExceptionCaught(final Throwable cause) {
        block4: {
            EventExecutor executor = this.executor();
            if (executor.inEventLoop()) {
                this.invokeExceptionCaught0(cause);
            } else {
                try {
                    executor.execute(new Runnable(){

                        @Override
                        public void run() {
                            DefaultChannelHandlerContext.this.invokeExceptionCaught0(cause);
                        }
                    });
                }
                catch (Throwable t) {
                    if (!DefaultChannelPipeline.logger.isWarnEnabled()) break block4;
                    DefaultChannelPipeline.logger.warn("Failed to submit an exceptionCaught() event.", t);
                    DefaultChannelPipeline.logger.warn("The exceptionCaught() event that was failed to submit was:", cause);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeExceptionCaught0(Throwable cause) {
        ChannelHandler handler = this.handler();
        this.callDepth = (short)(this.callDepth + 1);
        try {
            handler.exceptionCaught(this, cause);
        }
        catch (Throwable t) {
            if (DefaultChannelPipeline.logger.isWarnEnabled()) {
                DefaultChannelPipeline.logger.warn("An exception was thrown by a user handler's exceptionCaught() method while handling the following exception:", cause);
            }
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelHandlerContext fireUserEventTriggered(final Object event) {
        if (event == null) {
            throw new NullPointerException("event");
        }
        final DefaultChannelHandlerContext next = this.findContextInbound();
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeUserEventTriggered(event);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    next.invokeUserEventTriggered(event);
                }
            });
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeUserEventTriggered(Object event) {
        ChannelStateHandler handler = (ChannelStateHandler)this.handler();
        this.callDepth = (short)(this.callDepth + 1);
        try {
            handler.userEventTriggered(this, event);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelHandlerContext fireInboundBufferUpdated() {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.fireInboundBufferUpdated0(this.findContextInbound());
        } else {
            Runnable task = this.fireInboundBufferUpdated0Task;
            if (task == null) {
                this.fireInboundBufferUpdated0Task = task = new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelHandlerContext.this.fireInboundBufferUpdated0(DefaultChannelHandlerContext.this.findContextInbound());
                    }
                };
            }
            executor.execute(task);
        }
        return this;
    }

    private void fireInboundBufferUpdated0(final DefaultChannelHandlerContext next) {
        this.feedNextInBridge();
        if (next.executor == this.executor) {
            next.invokeInboundBufferUpdated();
        } else {
            Runnable task = next.invokeInboundBufferUpdatedTask;
            if (task == null) {
                next.invokeInboundBufferUpdatedTask = task = new Runnable(){

                    @Override
                    public void run() {
                        next.invokeInboundBufferUpdated();
                    }
                };
            }
            next.executor().execute(task);
        }
    }

    private void feedNextInBridge() {
        NextBridgeFeeder feeder = this.nextInBridgeFeeder;
        if (feeder != null) {
            feeder.feed();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeInboundBufferUpdated() {
        if (this.isInboundFreed()) {
            return;
        }
        ChannelStateHandler handler = (ChannelStateHandler)this.handler();
        if (handler instanceof ChannelInboundHandler) {
            do {
                this.callDepth = (short)(this.callDepth + 1);
                try {
                    boolean flushedAll = this.flushInboundBridge();
                    handler.inboundBufferUpdated(this);
                    if (!flushedAll) continue;
                    break;
                }
                catch (Throwable t) {
                    this.notifyHandlerException(t);
                    break;
                }
                finally {
                    this.callDepth = (short)(this.callDepth - 1);
                    if (handler instanceof ChannelInboundByteHandler && !this.isInboundFreed()) {
                        try {
                            ((ChannelInboundByteHandler)handler).discardInboundReadBytes(this);
                        }
                        catch (Throwable t) {
                            this.notifyHandlerException(t);
                        }
                    }
                    this.freeAllIfRemoved();
                }
            } while (!this.isInboundFreed());
        } else {
            this.callDepth = (short)(this.callDepth + 1);
            try {
                handler.inboundBufferUpdated(this);
            }
            catch (Throwable t) {
                this.notifyHandlerException(t);
            }
            finally {
                this.callDepth = (short)(this.callDepth - 1);
            }
        }
    }

    @Override
    public ChannelHandlerContext fireChannelReadSuspended() {
        final DefaultChannelHandlerContext next = this.findContextInbound();
        EventExecutor executor = next.executor();
        if (executor.inEventLoop()) {
            next.invokeChannelReadSuspended();
        } else {
            Runnable task = next.invokeChannelReadSuspendedTask;
            if (task == null) {
                next.invokeChannelReadSuspendedTask = task = new Runnable(){

                    @Override
                    public void run() {
                        next.invokeChannelReadSuspended();
                    }
                };
            }
            executor.execute(task);
        }
        return this;
    }

    private void invokeChannelReadSuspended() {
        this.callDepth = (short)(this.callDepth + 1);
        try {
            ((ChannelStateHandler)this.handler()).channelReadSuspended(this);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress) {
        return this.bind(localAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress) {
        return this.connect(remoteAddress, this.newPromise());
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress) {
        return this.connect(remoteAddress, localAddress, this.newPromise());
    }

    @Override
    public ChannelFuture disconnect() {
        return this.disconnect(this.newPromise());
    }

    @Override
    public ChannelFuture close() {
        return this.close(this.newPromise());
    }

    @Override
    public ChannelFuture deregister() {
        return this.deregister(this.newPromise());
    }

    @Override
    public ChannelFuture flush() {
        return this.flush(this.newPromise());
    }

    @Override
    public ChannelFuture write(Object message) {
        return this.write(message, this.newPromise());
    }

    @Override
    public ChannelFuture bind(SocketAddress localAddress, ChannelPromise promise) {
        if (localAddress == null) {
            throw new NullPointerException("localAddress");
        }
        this.validateFuture(promise, false);
        return this.findContextOutbound().invokeBind(localAddress, promise);
    }

    private ChannelFuture invokeBind(final SocketAddress localAddress, final ChannelPromise promise) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeBind0(localAddress, promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeBind0(localAddress, promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeBind0(SocketAddress localAddress, ChannelPromise promise) {
        this.callDepth = (short)(this.callDepth + 1);
        try {
            ((ChannelOperationHandler)this.handler()).bind(this, localAddress, promise);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, ChannelPromise promise) {
        return this.connect(remoteAddress, null, promise);
    }

    @Override
    public ChannelFuture connect(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        if (remoteAddress == null) {
            throw new NullPointerException("remoteAddress");
        }
        this.validateFuture(promise, false);
        return this.findContextOutbound().invokeConnect(remoteAddress, localAddress, promise);
    }

    private ChannelFuture invokeConnect(final SocketAddress remoteAddress, final SocketAddress localAddress, final ChannelPromise promise) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeConnect0(remoteAddress, localAddress, promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeConnect0(remoteAddress, localAddress, promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeConnect0(SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
        this.callDepth = (short)(this.callDepth + 1);
        try {
            ((ChannelOperationHandler)this.handler()).connect(this, remoteAddress, localAddress, promise);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelFuture disconnect(ChannelPromise promise) {
        this.validateFuture(promise, false);
        if (!this.channel().metadata().hasDisconnect()) {
            return this.findContextOutbound().invokeClose(promise);
        }
        return this.findContextOutbound().invokeDisconnect(promise);
    }

    private ChannelFuture invokeDisconnect(final ChannelPromise promise) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeDisconnect0(promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeDisconnect0(promise);
                }
            });
        }
        return promise;
    }

    private void invokeDisconnect0(ChannelPromise promise) {
        this.callDepth = (short)(this.callDepth + 1);
        try {
            ((ChannelOperationHandler)this.handler()).disconnect(this, promise);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelFuture close(ChannelPromise promise) {
        this.validateFuture(promise, false);
        return this.findContextOutbound().invokeClose(promise);
    }

    private ChannelFuture invokeClose(final ChannelPromise promise) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeClose0(promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeClose0(promise);
                }
            });
        }
        return promise;
    }

    private void invokeClose0(ChannelPromise promise) {
        this.callDepth = (short)(this.callDepth + 1);
        try {
            ((ChannelOperationHandler)this.handler()).close(this, promise);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelFuture deregister(ChannelPromise promise) {
        this.validateFuture(promise, false);
        return this.findContextOutbound().invokeDeregister(promise);
    }

    private ChannelFuture invokeDeregister(final ChannelPromise promise) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeDeregister0(promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeDeregister0(promise);
                }
            });
        }
        return promise;
    }

    private void invokeDeregister0(ChannelPromise promise) {
        this.callDepth = (short)(this.callDepth + 1);
        try {
            ((ChannelOperationHandler)this.handler()).deregister(this, promise);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public void read() {
        this.findContextOutbound().invokeRead();
    }

    private void invokeRead() {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeRead0();
        } else {
            Runnable task = this.invokeRead0Task;
            if (task == null) {
                this.invokeRead0Task = task = new Runnable(){

                    @Override
                    public void run() {
                        DefaultChannelHandlerContext.this.invokeRead0();
                    }
                };
            }
            executor.execute(task);
        }
    }

    private void invokeRead0() {
        this.callDepth = (short)(this.callDepth + 1);
        try {
            ((ChannelOperationHandler)this.handler()).read(this);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelFuture flush(final ChannelPromise promise) {
        this.validateFuture(promise, true);
        EventExecutor executor = this.executor();
        Thread currentThread = Thread.currentThread();
        if (executor.inEventLoop(currentThread)) {
            this.invokePrevFlush(promise, currentThread, this.findContextOutbound());
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokePrevFlush(promise, Thread.currentThread(), DefaultChannelHandlerContext.this.findContextOutbound());
                }
            });
        }
        return promise;
    }

    private void invokePrevFlush(ChannelPromise promise, Thread currentThread, DefaultChannelHandlerContext prev) {
        this.feedNextOutBridge();
        prev.invokeFlush(promise, currentThread);
    }

    private void feedNextOutBridge() {
        NextBridgeFeeder feeder = this.nextOutBridgeFeeder;
        if (feeder != null) {
            feeder.feed();
        }
    }

    private ChannelFuture invokeFlush(final ChannelPromise promise, Thread currentThread) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop(currentThread)) {
            this.invokeFlush0(promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeFlush0(promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeFlush0(ChannelPromise promise) {
        if (this.isOutboundFreed()) {
            promise.setFailure(new ChannelPipelineException("Unable to flush as outbound buffer of next handler was freed already"));
            return;
        }
        Channel channel = this.channel();
        if (!channel.isActive() && !channel.isRegistered()) {
            promise.setFailure(new ClosedChannelException());
            return;
        }
        ChannelOperationHandler handler = (ChannelOperationHandler)this.handler();
        if (handler instanceof ChannelOutboundHandler) {
            this.flushOutboundBridge();
        }
        this.callDepth = (short)(this.callDepth + 1);
        try {
            handler.flush(this, promise);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            if (handler instanceof ChannelOutboundByteHandler && !this.isOutboundFreed()) {
                try {
                    ((ChannelOutboundByteHandler)handler).discardOutboundReadBytes(this);
                }
                catch (Throwable t) {
                    this.notifyHandlerException(t);
                }
            }
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelFuture sendFile(FileRegion region) {
        return this.sendFile(region, this.newPromise());
    }

    @Override
    public ChannelFuture sendFile(FileRegion region, ChannelPromise promise) {
        if (region == null) {
            throw new NullPointerException("region");
        }
        this.validateFuture(promise, true);
        return this.findContextOutbound().invokeSendFile(region, promise);
    }

    private ChannelFuture invokeSendFile(final FileRegion region, final ChannelPromise promise) {
        EventExecutor executor = this.executor();
        if (executor.inEventLoop()) {
            this.invokeSendFile0(region, promise);
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    DefaultChannelHandlerContext.this.invokeSendFile0(region, promise);
                }
            });
        }
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void invokeSendFile0(FileRegion region, ChannelPromise promise) {
        ChannelOperationHandler handler = (ChannelOperationHandler)this.handler();
        if (handler instanceof ChannelOutboundHandler) {
            this.flushOutboundBridge();
        }
        this.callDepth = (short)(this.callDepth + 1);
        try {
            handler.sendFile(this, region, promise);
        }
        catch (Throwable t) {
            this.notifyHandlerException(t);
        }
        finally {
            this.callDepth = (short)(this.callDepth - 1);
            this.freeAllIfRemoved();
        }
    }

    @Override
    public ChannelFuture write(final Object message, final ChannelPromise promise) {
        EventExecutor executor;
        boolean msgBuf;
        DefaultChannelHandlerContext ctx;
        block9: {
            if (message instanceof FileRegion) {
                return this.sendFile((FileRegion)message, promise);
            }
            if (message == null) {
                throw new NullPointerException("message");
            }
            this.validateFuture(promise, true);
            ctx = this.prev;
            if (message instanceof ByteBuf) {
                while (true) {
                    if (ctx.hasOutboundByteBuffer()) {
                        msgBuf = false;
                        executor = ctx.executor();
                        break block9;
                    }
                    if (ctx.hasOutboundMessageBuffer()) {
                        msgBuf = true;
                        executor = ctx.executor();
                        break block9;
                    }
                    ctx = ctx.prev;
                }
            }
            msgBuf = true;
            while (true) {
                if (ctx.hasOutboundMessageBuffer()) {
                    executor = ctx.executor();
                    break;
                }
                ctx = ctx.prev;
            }
        }
        if (executor.inEventLoop()) {
            ctx.write0(message, promise, msgBuf);
            return promise;
        }
        final DefaultChannelHandlerContext ctx0 = ctx;
        executor.execute(new Runnable(){

            @Override
            public void run() {
                ctx0.write0(message, promise, msgBuf);
            }
        });
        return promise;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write0(Object message, ChannelPromise promise, boolean msgBuf) {
        Channel channel = this.channel();
        if (!channel.isRegistered() && !channel.isActive()) {
            promise.setFailure(new ClosedChannelException());
            return;
        }
        if (this.isOutboundFreed()) {
            promise.setFailure(new ChannelPipelineException("Unable to write as outbound buffer of next handler was freed already"));
            return;
        }
        if (msgBuf) {
            this.outboundMessageBuffer().add(message);
        } else {
            ByteBuf buf = (ByteBuf)message;
            try {
                this.outboundByteBuffer().writeBytes(buf, buf.readerIndex(), buf.readableBytes());
            }
            finally {
                buf.release();
            }
        }
        this.invokeFlush0(promise);
    }

    private void notifyHandlerException(Throwable cause) {
        if (DefaultChannelHandlerContext.inExceptionCaught(cause)) {
            if (DefaultChannelPipeline.logger.isWarnEnabled()) {
                DefaultChannelPipeline.logger.warn("An exception was thrown by a user handler while handling an exceptionCaught event", cause);
            }
            return;
        }
        this.invokeExceptionCaught(cause);
    }

    private static boolean inExceptionCaught(Throwable cause) {
        do {
            StackTraceElement[] trace;
            if ((trace = cause.getStackTrace()) == null) continue;
            for (StackTraceElement t : trace) {
                if (t == null) break;
                if (!"exceptionCaught".equals(t.getMethodName())) continue;
                return true;
            }
        } while ((cause = cause.getCause()) != null);
        return false;
    }

    @Override
    public ChannelPromise newPromise() {
        return new DefaultChannelPromise(this.channel(), this.executor());
    }

    @Override
    public ChannelProgressivePromise newProgressivePromise() {
        return new DefaultChannelProgressivePromise(this.channel(), this.executor());
    }

    @Override
    public ChannelFuture newSucceededFuture() {
        ChannelFuture succeededFuture = this.succeededFuture;
        if (succeededFuture == null) {
            this.succeededFuture = succeededFuture = new SucceededChannelFuture(this.channel(), this.executor());
        }
        return succeededFuture;
    }

    @Override
    public ChannelFuture newFailedFuture(Throwable cause) {
        return new FailedChannelFuture(this.channel(), this.executor(), cause);
    }

    private void validateFuture(ChannelFuture future, boolean allowUnsafe) {
        if (future == null) {
            throw new NullPointerException("future");
        }
        if (future.channel() != this.channel()) {
            throw new IllegalArgumentException(String.format("future.channel does not match: %s (expected: %s)", future.channel(), this.channel()));
        }
        if (future.isDone()) {
            throw new IllegalArgumentException("future already done");
        }
        if (!allowUnsafe && future instanceof VoidChannelPromise) {
            throw new IllegalArgumentException("VoidChannelPromise not allowed for this operation");
        }
        if (future instanceof AbstractChannel.CloseFuture) {
            throw new IllegalArgumentException("AbstractChannel.CloseFuture may not send through the pipeline");
        }
    }

    private DefaultChannelHandlerContext findContextInbound() {
        DefaultChannelHandlerContext ctx = this;
        while (!((ctx = ctx.next).handler() instanceof ChannelStateHandler)) {
        }
        return ctx;
    }

    @Override
    public BufType nextInboundBufferType() {
        DefaultChannelHandlerContext ctx = this;
        while (!((ctx = ctx.next).handler() instanceof ChannelInboundHandler)) {
        }
        if (ctx.handler() instanceof ChannelInboundByteHandler) {
            return BufType.BYTE;
        }
        return BufType.MESSAGE;
    }

    @Override
    public BufType nextOutboundBufferType() {
        DefaultChannelHandlerContext ctx = this;
        while (!((ctx = ctx.prev).handler() instanceof ChannelOutboundHandler)) {
        }
        if (ctx.handler() instanceof ChannelOutboundByteHandler) {
            return BufType.BYTE;
        }
        return BufType.MESSAGE;
    }

    private DefaultChannelHandlerContext findContextOutbound() {
        DefaultChannelHandlerContext ctx = this;
        while (!((ctx = ctx.prev).handler() instanceof ChannelOperationHandler)) {
        }
        return ctx;
    }

    @Override
    public ChannelPromise voidPromise() {
        return this.channel.voidPromise();
    }

    private final class NextOutboundBridgeFeeder
    extends NextBridgeFeeder {
        private NextOutboundBridgeFeeder() {
        }

        @Override
        protected Queue<Object> nextByteBridge() {
            DefaultChannelHandlerContext ctx = DefaultChannelHandlerContext.this.prev;
            while (!ctx.hasOutboundByteBuffer()) {
                ctx = ctx.prev;
            }
            return this.bridge(ctx);
        }

        @Override
        protected Queue<Object> nextMessageBridge() {
            DefaultChannelHandlerContext ctx = DefaultChannelHandlerContext.this.prev;
            while (!ctx.hasOutboundMessageBuffer()) {
                ctx = ctx.prev;
            }
            return this.bridge(ctx);
        }

        private Queue<Object> bridge(DefaultChannelHandlerContext ctx) {
            Queue bridge = ctx.outBridge;
            if (bridge == null) {
                ConcurrentLinkedQueue newBridge = new ConcurrentLinkedQueue();
                bridge = OUT_BRIDGE_UPDATER.compareAndSet(ctx, null, newBridge) ? newBridge : ctx.outBridge;
            }
            return bridge;
        }
    }

    private final class NextInboundBridgeFeeder
    extends NextBridgeFeeder {
        private NextInboundBridgeFeeder() {
        }

        @Override
        protected Queue<Object> nextByteBridge() {
            DefaultChannelHandlerContext ctx = DefaultChannelHandlerContext.this.next;
            while (!ctx.hasInboundByteBuffer()) {
                ctx = ctx.next;
            }
            return this.bridge(ctx);
        }

        @Override
        protected Queue<Object> nextMessageBridge() {
            DefaultChannelHandlerContext ctx = DefaultChannelHandlerContext.this.next;
            while (!ctx.hasInboundMessageBuffer()) {
                ctx = ctx.next;
            }
            return this.bridge(ctx);
        }

        private Queue<Object> bridge(DefaultChannelHandlerContext ctx) {
            Queue bridge = ctx.inBridge;
            if (bridge == null) {
                ConcurrentLinkedQueue newBridge = new ConcurrentLinkedQueue();
                bridge = IN_BRIDGE_UPDATER.compareAndSet(ctx, null, newBridge) ? newBridge : ctx.inBridge;
            }
            return bridge;
        }
    }

    private abstract class NextBridgeFeeder {
        final MessageBuf<Object> msgBuf = Unpooled.messageBuffer();
        final ByteBuf byteBuf;

        protected NextBridgeFeeder() {
            this.byteBuf = ChannelHandlerUtil.allocate(DefaultChannelHandlerContext.this);
        }

        final void feed() {
            Object data;
            int dataLen = this.byteBuf.readableBytes();
            if (dataLen != 0) {
                data = this.byteBuf.isDirect() ? DefaultChannelHandlerContext.this.alloc().directBuffer(dataLen, dataLen) : DefaultChannelHandlerContext.this.alloc().heapBuffer(dataLen, dataLen);
                this.byteBuf.readBytes((ByteBuf)data).discardSomeReadBytes();
                this.nextByteBridge().add(data);
            }
            if (!this.msgBuf.isEmpty()) {
                data = this.msgBuf.toArray();
                this.msgBuf.clear();
                this.nextMessageBridge().add(data);
            }
        }

        final void release() {
            this.byteBuf.release();
            this.msgBuf.release();
        }

        protected abstract Queue<Object> nextByteBridge();

        protected abstract Queue<Object> nextMessageBridge();
    }
}

