/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelHandlerUtil;
import io.netty.handler.codec.ByteToMessageDecoder;

public class FixedLengthFrameDecoder
extends ByteToMessageDecoder {
    private final int frameLength;
    private final boolean allocateFullBuffer;

    public FixedLengthFrameDecoder(int frameLength) {
        this(frameLength, false);
    }

    public FixedLengthFrameDecoder(int frameLength, boolean allocateFullBuffer) {
        if (frameLength <= 0) {
            throw new IllegalArgumentException("frameLength must be a positive integer: " + frameLength);
        }
        this.frameLength = frameLength;
        this.allocateFullBuffer = allocateFullBuffer;
    }

    @Override
    public ByteBuf newInboundBuffer(ChannelHandlerContext ctx) throws Exception {
        if (this.allocateFullBuffer) {
            return ChannelHandlerUtil.allocate(ctx, this.frameLength);
        }
        return super.newInboundBuffer(ctx);
    }

    @Override
    protected Object decode(ChannelHandlerContext ctx, ByteBuf in) throws Exception {
        if (in.readableBytes() < this.frameLength) {
            return null;
        }
        return in.readBytes(this.frameLength);
    }
}

