/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.aio;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPromise;
import io.netty.channel.ChannelTaskScheduler;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.aio.AioEventLoopGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import java.util.concurrent.ThreadFactory;

final class AioEventLoop
extends SingleThreadEventLoop {
    private final Set<Channel> channels = Collections.newSetFromMap(new IdentityHashMap());
    private final ChannelFutureListener registrationListener = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            if (!future.isSuccess()) {
                return;
            }
            Channel ch = future.channel();
            AioEventLoop.this.channels.add(ch);
            ch.closeFuture().addListener(AioEventLoop.this.deregistrationListener);
        }
    };
    private final ChannelFutureListener deregistrationListener = new ChannelFutureListener(){

        @Override
        public void operationComplete(ChannelFuture future) throws Exception {
            AioEventLoop.this.channels.remove(future.channel());
        }
    };

    AioEventLoop(AioEventLoopGroup parent, ThreadFactory threadFactory, ChannelTaskScheduler scheduler) {
        super(parent, threadFactory, scheduler);
    }

    @Override
    public ChannelFuture register(Channel channel) {
        return super.register(channel).addListener(this.registrationListener);
    }

    @Override
    public ChannelFuture register(Channel channel, ChannelPromise future) {
        return super.register(channel, future).addListener(this.registrationListener);
    }

    @Override
    protected void run() {
        while (true) {
            try {
                Runnable task = this.takeTask();
                task.run();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.isShutdown()) continue;
            this.closeAll();
            if (this.confirmShutdown()) break;
        }
    }

    private void closeAll() {
        ArrayList<Channel> channels = new ArrayList<Channel>(this.channels.size());
        for (Channel ch : this.channels) {
            channels.add(ch);
        }
        for (Channel ch : channels) {
            ch.unsafe().close(ch.unsafe().voidFuture());
        }
    }
}

