/*
 * Decompiled with CFR 0.152.
 */
package com.barchart.udt.net;

import com.barchart.udt.ErrorUDT;
import com.barchart.udt.SocketUDT;
import com.barchart.udt.net.ExceptionReceiveUDT;
import java.io.IOException;
import java.io.InputStream;
import java.nio.channels.IllegalBlockingModeException;

public class NetInputStreamUDT
extends InputStream {
    protected final SocketUDT socketUDT;

    public NetInputStreamUDT(SocketUDT socketUDT) {
        if (!socketUDT.isBlocking()) {
            throw new IllegalBlockingModeException();
        }
        this.socketUDT = socketUDT;
    }

    @Override
    public int read() throws IOException {
        byte[] data = new byte[1];
        int count = this.read(data);
        assert (count == 1);
        return data[0];
    }

    @Override
    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    @Override
    public int read(byte[] bytes, int off, int len) throws IOException {
        int count = this.socketUDT.receive(bytes, off, off + len);
        if (count > 0) {
            assert (count <= len);
            return count;
        }
        if (count == 0) {
            throw new ExceptionReceiveUDT(this.socketUDT.id(), ErrorUDT.USER_DEFINED_MESSAGE, "UDT receive time out"){};
        }
        throw new IllegalStateException("should not happen");
    }

    @Override
    public void close() throws IOException {
        this.socketUDT.close();
    }

    @Override
    public int available() throws IOException {
        return 0;
    }

    @Override
    public long skip(long n) throws IOException {
        throw new UnsupportedOperationException("skip not supported");
    }

    @Override
    public void mark(int readlimit) {
        throw new UnsupportedOperationException("mark not supported");
    }

    @Override
    public void reset() throws IOException {
        throw new UnsupportedOperationException("reset not supported");
    }

    @Override
    public boolean markSupported() {
        return false;
    }
}

