/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoop;
import io.netty.resolver.dns.DefaultDnsCnameCache;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.junit.Assert;
import org.junit.Test;

public class DefaultDnsCnameCacheTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testExpire() throws Throwable {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            final DefaultDnsCnameCache cache = new DefaultDnsCnameCache();
            cache.cache("netty.io", "mapping.netty.io", 1L, loop);
            Throwable error = (Throwable)loop.schedule((Callable)new Callable<Throwable>(){

                @Override
                public Throwable call() {
                    try {
                        Assert.assertNull((Object)cache.get("netty.io"));
                        return null;
                    }
                    catch (Throwable cause) {
                        return cause;
                    }
                }
            }, 1L, TimeUnit.SECONDS).get();
            if (error != null) {
                throw error;
            }
        }
        finally {
            group.shutdownGracefully();
        }
    }

    @Test
    public void testExpireWithDifferentTTLs() {
        DefaultDnsCnameCacheTest.testExpireWithTTL0(1);
        DefaultDnsCnameCacheTest.testExpireWithTTL0(1000);
        DefaultDnsCnameCacheTest.testExpireWithTTL0(1000000);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testExpireWithTTL0(int days) {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultDnsCnameCache cache = new DefaultDnsCnameCache();
            cache.cache("netty.io", "mapping.netty.io", TimeUnit.DAYS.toSeconds(days), loop);
            Assert.assertEquals((Object)"mapping.netty.io", (Object)cache.get("netty.io"));
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMultipleCnamesForSameHostname() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultDnsCnameCache cache = new DefaultDnsCnameCache();
            cache.cache("netty.io", "mapping1.netty.io", 10L, loop);
            cache.cache("netty.io", "mapping2.netty.io", 10000L, loop);
            Assert.assertEquals((Object)"mapping2.netty.io", (Object)cache.get("netty.io"));
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testAddSameCnameForSameHostname() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultDnsCnameCache cache = new DefaultDnsCnameCache();
            cache.cache("netty.io", "mapping.netty.io", 10L, loop);
            cache.cache("netty.io", "mapping.netty.io", 10000L, loop);
            Assert.assertEquals((Object)"mapping.netty.io", (Object)cache.get("netty.io"));
        }
        finally {
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testClear() throws Exception {
        DefaultEventLoopGroup group = new DefaultEventLoopGroup(1);
        try {
            EventLoop loop = group.next();
            DefaultDnsCnameCache cache = new DefaultDnsCnameCache();
            cache.cache("x.netty.io", "mapping.netty.io", 100000L, loop);
            cache.cache("y.netty.io", "mapping.netty.io", 100000L, loop);
            Assert.assertEquals((Object)"mapping.netty.io", (Object)cache.get("x.netty.io"));
            Assert.assertEquals((Object)"mapping.netty.io", (Object)cache.get("y.netty.io"));
            Assert.assertTrue((boolean)cache.clear("x.netty.io"));
            Assert.assertNull((Object)cache.get("x.netty.io"));
            Assert.assertEquals((Object)"mapping.netty.io", (Object)cache.get("y.netty.io"));
            cache.clear();
            Assert.assertNull((Object)cache.get("y.netty.io"));
        }
        finally {
            group.shutdownGracefully();
        }
    }
}

