/*
 * Decompiled with CFR 0.152.
 */
package io.netty.resolver.dns;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufHolder;
import io.netty.channel.AddressedEnvelope;
import io.netty.channel.socket.InternetProtocolFamily;
import io.netty.handler.codec.CorruptedFrameException;
import io.netty.handler.codec.dns.DefaultDnsQuestion;
import io.netty.handler.codec.dns.DefaultDnsRecordDecoder;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsRawRecord;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.handler.codec.dns.DnsResponse;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.handler.codec.dns.DnsSection;
import io.netty.resolver.dns.DnsCache;
import io.netty.resolver.dns.DnsCacheEntry;
import io.netty.resolver.dns.DnsNameResolver;
import io.netty.resolver.dns.DnsServerAddressStream;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.StringUtil;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

abstract class DnsNameResolverContext<T> {
    private static final int INADDRSZ4 = 4;
    private static final int INADDRSZ6 = 16;
    private static final FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>> RELEASE_RESPONSE = new FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>>(){

        public void operationComplete(Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> future) {
            if (future.isSuccess()) {
                ((AddressedEnvelope)future.getNow()).release();
            }
        }
    };
    private final DnsNameResolver parent;
    private final DnsServerAddressStream nameServerAddrs;
    private final String hostname;
    protected String pristineHostname;
    private final DnsCache resolveCache;
    private final boolean traceEnabled;
    private final int maxAllowedQueries;
    private final InternetProtocolFamily[] resolveAddressTypes;
    private final Set<Future<AddressedEnvelope<DnsResponse, InetSocketAddress>>> queriesInProgress = Collections.newSetFromMap(new IdentityHashMap());
    private List<DnsCacheEntry> resolvedEntries;
    private StringBuilder trace;
    private int allowedQueries;
    private boolean triedCNAME;

    protected DnsNameResolverContext(DnsNameResolver parent, String hostname, DnsCache resolveCache) {
        this.parent = parent;
        this.hostname = hostname;
        this.resolveCache = resolveCache;
        this.nameServerAddrs = parent.nameServerAddresses.stream();
        this.maxAllowedQueries = parent.maxQueriesPerResolve();
        this.resolveAddressTypes = parent.resolveAddressTypesUnsafe();
        this.traceEnabled = parent.isTraceEnabled();
        this.allowedQueries = this.maxAllowedQueries;
    }

    void resolve(Promise<T> promise) {
        boolean directSearch;
        boolean bl = directSearch = this.parent.searchDomains().length == 0 || StringUtil.endsWith((CharSequence)this.hostname, (char)'.');
        if (directSearch) {
            this.internalResolve(promise);
        } else {
            final Promise original = promise;
            promise = this.parent.executor().newPromise();
            promise.addListener((GenericFutureListener)new FutureListener<T>(){
                int count;

                public void operationComplete(Future<T> future) throws Exception {
                    if (future.isSuccess()) {
                        original.trySuccess(future.getNow());
                    } else if (this.count < DnsNameResolverContext.this.parent.searchDomains().length) {
                        String searchDomain = DnsNameResolverContext.this.parent.searchDomains()[this.count++];
                        Promise nextPromise = DnsNameResolverContext.this.parent.executor().newPromise();
                        String nextHostname = DnsNameResolverContext.this.hostname + "." + searchDomain;
                        DnsNameResolverContext nextContext = DnsNameResolverContext.this.newResolverContext(DnsNameResolverContext.this.parent, nextHostname, DnsNameResolverContext.this.resolveCache);
                        nextContext.pristineHostname = DnsNameResolverContext.this.hostname;
                        nextContext.internalResolve(nextPromise);
                        nextPromise.addListener((GenericFutureListener)this);
                    } else {
                        original.tryFailure(future.cause());
                    }
                }
            });
            if (this.parent.ndots() == 0) {
                this.internalResolve(promise);
            } else {
                int dots = 0;
                for (int idx = this.hostname.length() - 1; idx >= 0; --idx) {
                    if (this.hostname.charAt(idx) != '.' || ++dots < this.parent.ndots()) continue;
                    this.internalResolve(promise);
                    return;
                }
                promise.tryFailure((Throwable)new UnknownHostException(this.hostname));
            }
        }
    }

    private void internalResolve(Promise<T> promise) {
        InetSocketAddress nameServerAddrToTry = this.nameServerAddrs.next();
        for (InternetProtocolFamily f : this.resolveAddressTypes) {
            DnsRecordType type;
            switch (f) {
                case IPv4: {
                    type = DnsRecordType.A;
                    break;
                }
                case IPv6: {
                    type = DnsRecordType.AAAA;
                    break;
                }
                default: {
                    throw new Error();
                }
            }
            this.query(nameServerAddrToTry, (DnsQuestion)new DefaultDnsQuestion(this.hostname, type), promise);
        }
    }

    private void query(InetSocketAddress nameServerAddr, final DnsQuestion question, final Promise<T> promise) {
        if (this.allowedQueries == 0 || promise.isCancelled()) {
            this.tryToFinishResolve(promise);
            return;
        }
        --this.allowedQueries;
        Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> f = this.parent.query(nameServerAddr, question);
        this.queriesInProgress.add(f);
        f.addListener((GenericFutureListener)new FutureListener<AddressedEnvelope<DnsResponse, InetSocketAddress>>(){

            public void operationComplete(Future<AddressedEnvelope<DnsResponse, InetSocketAddress>> future) {
                DnsNameResolverContext.this.queriesInProgress.remove(future);
                if (promise.isDone() || future.isCancelled()) {
                    return;
                }
                try {
                    if (future.isSuccess()) {
                        DnsNameResolverContext.this.onResponse(question, (AddressedEnvelope<DnsResponse, InetSocketAddress>)((AddressedEnvelope)future.getNow()), promise);
                    } else {
                        if (DnsNameResolverContext.this.traceEnabled) {
                            DnsNameResolverContext.this.addTrace(future.cause());
                        }
                        DnsNameResolverContext.this.query(DnsNameResolverContext.this.nameServerAddrs.next(), question, promise);
                    }
                }
                finally {
                    DnsNameResolverContext.this.tryToFinishResolve(promise);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onResponse(DnsQuestion question, AddressedEnvelope<DnsResponse, InetSocketAddress> envelope, Promise<T> promise) {
        try {
            DnsResponse res = (DnsResponse)envelope.content();
            DnsResponseCode code = res.code();
            if (code == DnsResponseCode.NOERROR) {
                DnsRecordType type = question.type();
                if (type == DnsRecordType.A || type == DnsRecordType.AAAA) {
                    this.onResponseAorAAAA(type, question, envelope, promise);
                } else if (type == DnsRecordType.CNAME) {
                    this.onResponseCNAME(question, envelope, promise);
                }
                return;
            }
            if (this.traceEnabled) {
                this.addTrace((InetSocketAddress)envelope.sender(), "response code: " + code + " with " + res.count(DnsSection.ANSWER) + " answer(s) and " + res.count(DnsSection.AUTHORITY) + " authority resource(s)");
            }
            if (code != DnsResponseCode.NXDOMAIN) {
                this.query(this.nameServerAddrs.next(), question, promise);
            }
        }
        finally {
            ReferenceCountUtil.safeRelease(envelope);
        }
    }

    private void onResponseAorAAAA(DnsRecordType qType, DnsQuestion question, AddressedEnvelope<DnsResponse, InetSocketAddress> envelope, Promise<T> promise) {
        DnsResponse response = (DnsResponse)envelope.content();
        Map<String, String> cnames = DnsNameResolverContext.buildAliasMap(response);
        int answerCount = response.count(DnsSection.ANSWER);
        boolean found = false;
        for (int i = 0; i < answerCount; ++i) {
            InetAddress resolved;
            ByteBuf content;
            int contentLen;
            DnsRecord r = response.recordAt(DnsSection.ANSWER, i);
            DnsRecordType type = r.type();
            if (type != DnsRecordType.A && type != DnsRecordType.AAAA) continue;
            String qName = question.name().toLowerCase(Locale.US);
            String rName = r.name().toLowerCase(Locale.US);
            if (!rName.equals(qName)) {
                String resolved2 = qName;
                while (!rName.equals(resolved2 = cnames.get(resolved2)) && resolved2 != null) {
                }
                if (resolved2 == null) continue;
            }
            if (!(r instanceof DnsRawRecord) || (contentLen = (content = ((ByteBufHolder)r).content()).readableBytes()) != 4 && contentLen != 16) continue;
            byte[] addrBytes = new byte[contentLen];
            content.getBytes(content.readerIndex(), addrBytes);
            try {
                resolved = InetAddress.getByAddress(this.hostname, addrBytes);
            }
            catch (UnknownHostException e) {
                throw new Error(e);
            }
            if (this.resolvedEntries == null) {
                this.resolvedEntries = new ArrayList<DnsCacheEntry>(8);
            }
            DnsCacheEntry e = new DnsCacheEntry(this.hostname, resolved);
            this.resolveCache.cache(this.hostname, resolved, r.timeToLive(), this.parent.ch.eventLoop());
            this.resolvedEntries.add(e);
            found = true;
        }
        if (found) {
            return;
        }
        if (this.traceEnabled) {
            this.addTrace((InetSocketAddress)envelope.sender(), "no matching " + qType + " record found");
        }
        if (!cnames.isEmpty()) {
            this.onResponseCNAME(question, envelope, cnames, false, promise);
        }
    }

    private void onResponseCNAME(DnsQuestion question, AddressedEnvelope<DnsResponse, InetSocketAddress> envelope, Promise<T> promise) {
        this.onResponseCNAME(question, envelope, DnsNameResolverContext.buildAliasMap((DnsResponse)envelope.content()), true, promise);
    }

    private void onResponseCNAME(DnsQuestion question, AddressedEnvelope<DnsResponse, InetSocketAddress> response, Map<String, String> cnames, boolean trace, Promise<T> promise) {
        String next;
        String name;
        String resolved = name = question.name().toLowerCase(Locale.US);
        boolean found = false;
        while (!cnames.isEmpty() && (next = cnames.remove(resolved)) != null) {
            found = true;
            resolved = next;
        }
        if (found) {
            this.followCname((InetSocketAddress)response.sender(), name, resolved, promise);
        } else if (trace && this.traceEnabled) {
            this.addTrace((InetSocketAddress)response.sender(), "no matching CNAME record found");
        }
    }

    private static Map<String, String> buildAliasMap(DnsResponse response) {
        int answerCount = response.count(DnsSection.ANSWER);
        Map<String, String> cnames = null;
        for (int i = 0; i < answerCount; ++i) {
            ByteBuf recordContent;
            String domainName;
            DnsRecord r = response.recordAt(DnsSection.ANSWER, i);
            DnsRecordType type = r.type();
            if (type != DnsRecordType.CNAME || !(r instanceof DnsRawRecord) || (domainName = DnsNameResolverContext.decodeDomainName(recordContent = ((ByteBufHolder)r).content())) == null) continue;
            if (cnames == null) {
                cnames = new HashMap<String, String>();
            }
            cnames.put(r.name().toLowerCase(Locale.US), domainName.toLowerCase(Locale.US));
        }
        return cnames != null ? cnames : Collections.emptyMap();
    }

    void tryToFinishResolve(Promise<T> promise) {
        if (!this.queriesInProgress.isEmpty()) {
            if (this.gotPreferredAddress()) {
                this.finishResolve(promise);
            }
            return;
        }
        if (this.resolvedEntries == null && !this.triedCNAME) {
            this.triedCNAME = true;
            this.query(this.nameServerAddrs.next(), (DnsQuestion)new DefaultDnsQuestion(this.hostname, DnsRecordType.CNAME), promise);
            return;
        }
        this.finishResolve(promise);
    }

    private boolean gotPreferredAddress() {
        if (this.resolvedEntries == null) {
            return false;
        }
        int size = this.resolvedEntries.size();
        switch (this.resolveAddressTypes[0]) {
            case IPv4: {
                for (int i = 0; i < size; ++i) {
                    if (!(this.resolvedEntries.get(i).address() instanceof Inet4Address)) continue;
                    return true;
                }
                break;
            }
            case IPv6: {
                for (int i = 0; i < size; ++i) {
                    if (!(this.resolvedEntries.get(i).address() instanceof Inet6Address)) continue;
                    return true;
                }
                break;
            }
        }
        return false;
    }

    private void finishResolve(Promise<T> promise) {
        if (!this.queriesInProgress.isEmpty()) {
            InternetProtocolFamily[] i = this.queriesInProgress.iterator();
            while (i.hasNext()) {
                Future f = (Future)i.next();
                i.remove();
                if (f.cancel(false)) continue;
                f.addListener(RELEASE_RESPONSE);
            }
        }
        if (this.resolvedEntries != null) {
            for (InternetProtocolFamily f : this.resolveAddressTypes) {
                if (!this.finishResolve(f.addressType(), this.resolvedEntries, promise)) continue;
                return;
            }
        }
        int tries = this.maxAllowedQueries - this.allowedQueries;
        StringBuilder buf = new StringBuilder(64);
        buf.append("failed to resolve '");
        if (this.pristineHostname != null) {
            buf.append(this.pristineHostname);
        } else {
            buf.append(this.hostname);
        }
        buf.append('\'');
        if (tries > 1) {
            if (tries < this.maxAllowedQueries) {
                buf.append(" after ").append(tries).append(" queries ");
            } else {
                buf.append(". Exceeded max queries per resolve ").append(this.maxAllowedQueries).append(' ');
            }
        }
        if (this.trace != null) {
            buf.append(':').append((CharSequence)this.trace);
        }
        UnknownHostException cause = new UnknownHostException(buf.toString());
        this.resolveCache.cache(this.hostname, cause, this.parent.ch.eventLoop());
        promise.tryFailure((Throwable)cause);
    }

    abstract boolean finishResolve(Class<? extends InetAddress> var1, List<DnsCacheEntry> var2, Promise<T> var3);

    abstract DnsNameResolverContext<T> newResolverContext(DnsNameResolver var1, String var2, DnsCache var3);

    static String decodeDomainName(ByteBuf in) {
        in.markReaderIndex();
        try {
            String string = DefaultDnsRecordDecoder.decodeName((ByteBuf)in);
            return string;
        }
        catch (CorruptedFrameException e) {
            String string = null;
            return string;
        }
        finally {
            in.resetReaderIndex();
        }
    }

    private void followCname(InetSocketAddress nameServerAddr, String name, String cname, Promise<T> promise) {
        if (this.traceEnabled) {
            if (this.trace == null) {
                this.trace = new StringBuilder(128);
            }
            this.trace.append(StringUtil.NEWLINE);
            this.trace.append("\tfrom ");
            this.trace.append(nameServerAddr);
            this.trace.append(": ");
            this.trace.append(name);
            this.trace.append(" CNAME ");
            this.trace.append(cname);
        }
        InetSocketAddress nextAddr = this.nameServerAddrs.next();
        this.query(nextAddr, (DnsQuestion)new DefaultDnsQuestion(cname, DnsRecordType.A), promise);
        this.query(nextAddr, (DnsQuestion)new DefaultDnsQuestion(cname, DnsRecordType.AAAA), promise);
    }

    private void addTrace(InetSocketAddress nameServerAddr, String msg) {
        assert (this.traceEnabled);
        if (this.trace == null) {
            this.trace = new StringBuilder(128);
        }
        this.trace.append(StringUtil.NEWLINE);
        this.trace.append("\tfrom ");
        this.trace.append(nameServerAddr);
        this.trace.append(": ");
        this.trace.append(msg);
    }

    private void addTrace(Throwable cause) {
        assert (this.traceEnabled);
        if (this.trace == null) {
            this.trace = new StringBuilder(128);
        }
        this.trace.append(StringUtil.NEWLINE);
        this.trace.append("Caused by: ");
        this.trace.append(cause);
    }
}

