/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.headers;

import io.netty.handler.codec.Headers;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.microbench.headers.ExampleHeaders;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.AsciiString;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Threads(value=1)
@State(value=Scope.Benchmark)
@Fork(value=1)
@Warmup(iterations=10)
@Measurement(iterations=10)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class HeadersBenchmark
extends AbstractMicrobenchmark {
    @Param
    ExampleHeaders.HeaderExample exampleHeader;
    AsciiString[] httpNames;
    AsciiString[] http2Names;
    AsciiString[] httpValues;
    DefaultHttpHeaders httpHeaders;
    DefaultHttp2Headers http2Headers;
    DefaultHttpHeaders emptyHttpHeaders;
    DefaultHttp2Headers emptyHttp2Headers;
    DefaultHttpHeaders emptyHttpHeadersNoValidate;
    DefaultHttp2Headers emptyHttp2HeadersNoValidate;
    SlowHeaders slowHttp2Headers;

    private static String toHttpName(String name) {
        return name.startsWith(":") ? name.substring(1) : name;
    }

    static String toHttp2Name(String name) {
        return (name = name.toLowerCase()).equals("host") ? "xhost" : name;
    }

    @Setup(value=Level.Trial)
    public void setup() {
        Map<String, String> headers = ExampleHeaders.EXAMPLES.get((Object)this.exampleHeader);
        this.httpNames = new AsciiString[headers.size()];
        this.http2Names = new AsciiString[headers.size()];
        this.httpValues = new AsciiString[headers.size()];
        this.httpHeaders = new DefaultHttpHeaders(false);
        this.http2Headers = new DefaultHttp2Headers(false);
        int idx = 0;
        for (Map.Entry<String, String> header : headers.entrySet()) {
            String name = header.getKey();
            String httpName = HeadersBenchmark.toHttpName(name);
            String http2Name = HeadersBenchmark.toHttp2Name(name);
            String value = header.getValue();
            this.httpNames[idx] = new AsciiString((CharSequence)httpName);
            this.http2Names[idx] = new AsciiString((CharSequence)http2Name);
            this.httpValues[idx] = new AsciiString((CharSequence)value);
            this.httpHeaders.add((CharSequence)this.httpNames[idx], (Object)this.httpValues[idx]);
            this.http2Headers.add((Object)this.http2Names[idx], (Object)this.httpValues[idx]);
            ++idx;
        }
        this.slowHttp2Headers = new SlowHeaders((Headers)this.http2Headers);
        this.emptyHttpHeaders = new DefaultHttpHeaders(true);
        this.emptyHttp2Headers = new DefaultHttp2Headers(true);
        this.emptyHttpHeadersNoValidate = new DefaultHttpHeaders(false);
        this.emptyHttp2HeadersNoValidate = new DefaultHttp2Headers(false);
    }

    @Setup(value=Level.Invocation)
    public void setupEmptyHeaders() {
        this.emptyHttpHeaders.clear();
        this.emptyHttp2Headers.clear();
        this.emptyHttpHeadersNoValidate.clear();
        this.emptyHttp2HeadersNoValidate.clear();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void httpRemove(Blackhole bh) {
        for (AsciiString name : this.httpNames) {
            bh.consume((Object)this.httpHeaders.remove((CharSequence)name));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void httpGet(Blackhole bh) {
        for (AsciiString name : this.httpNames) {
            bh.consume((Object)this.httpHeaders.get((CharSequence)name));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public DefaultHttpHeaders httpPut() {
        DefaultHttpHeaders headers = new DefaultHttpHeaders(false);
        for (int i = 0; i < this.httpNames.length; ++i) {
            headers.add((CharSequence)this.httpNames[i], (Object)this.httpValues[i]);
        }
        return headers;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void httpIterate(Blackhole bh) {
        Iterator itr = this.httpHeaders.iteratorCharSequence();
        while (itr.hasNext()) {
            bh.consume(itr.next());
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void http2Remove(Blackhole bh) {
        for (AsciiString name : this.http2Names) {
            bh.consume(this.http2Headers.remove((Object)name));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void http2Get(Blackhole bh) {
        for (AsciiString name : this.http2Names) {
            bh.consume(this.http2Headers.get((Object)name));
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public DefaultHttp2Headers http2Put() {
        DefaultHttp2Headers headers = new DefaultHttp2Headers(false);
        for (int i = 0; i < this.http2Names.length; ++i) {
            headers.add((Object)this.http2Names[i], (Object)this.httpValues[i]);
        }
        return headers;
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void http2Iterate(Blackhole bh) {
        for (Map.Entry entry : this.http2Headers) {
            bh.consume((Object)entry);
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void httpAddAllFastest(Blackhole bh) {
        bh.consume((Object)this.emptyHttpHeadersNoValidate.add((HttpHeaders)this.httpHeaders));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void httpAddAllFast(Blackhole bh) {
        bh.consume((Object)this.emptyHttpHeaders.add((HttpHeaders)this.httpHeaders));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void http2AddAllFastest(Blackhole bh) {
        bh.consume((Object)this.emptyHttp2HeadersNoValidate.add((Headers)this.http2Headers));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void http2AddAllFast(Blackhole bh) {
        bh.consume((Object)this.emptyHttp2Headers.add((Headers)this.http2Headers));
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void http2AddAllSlow(Blackhole bh) {
        bh.consume((Object)this.emptyHttp2Headers.add((Headers)this.slowHttp2Headers));
    }

    private static final class SlowHeaders
    implements Headers<CharSequence, CharSequence, SlowHeaders> {
        private final Headers<CharSequence, CharSequence, ? extends Headers<?, ?, ?>> delegate;

        private SlowHeaders(Headers<CharSequence, CharSequence, ? extends Headers<?, ?, ?>> delegate) {
            this.delegate = delegate;
        }

        public CharSequence get(CharSequence name) {
            return (CharSequence)this.delegate.get((Object)name);
        }

        public CharSequence get(CharSequence name, CharSequence defaultValue) {
            return (CharSequence)this.delegate.get((Object)name, (Object)defaultValue);
        }

        public CharSequence getAndRemove(CharSequence name) {
            return (CharSequence)this.delegate.getAndRemove((Object)name);
        }

        public CharSequence getAndRemove(CharSequence name, CharSequence defaultValue) {
            return (CharSequence)this.delegate.getAndRemove((Object)name, (Object)defaultValue);
        }

        public List<CharSequence> getAll(CharSequence name) {
            return this.delegate.getAll((Object)name);
        }

        public List<CharSequence> getAllAndRemove(CharSequence name) {
            return this.delegate.getAllAndRemove((Object)name);
        }

        public Boolean getBoolean(CharSequence name) {
            return this.delegate.getBoolean((Object)name);
        }

        public boolean getBoolean(CharSequence name, boolean defaultValue) {
            return this.delegate.getBoolean((Object)name, defaultValue);
        }

        public Byte getByte(CharSequence name) {
            return this.delegate.getByte((Object)name);
        }

        public byte getByte(CharSequence name, byte defaultValue) {
            return this.delegate.getByte((Object)name, defaultValue);
        }

        public Character getChar(CharSequence name) {
            return this.delegate.getChar((Object)name);
        }

        public char getChar(CharSequence name, char defaultValue) {
            return this.delegate.getChar((Object)name, defaultValue);
        }

        public Short getShort(CharSequence name) {
            return this.delegate.getShort((Object)name);
        }

        public short getShort(CharSequence name, short defaultValue) {
            return this.delegate.getShort((Object)name, defaultValue);
        }

        public Integer getInt(CharSequence name) {
            return this.delegate.getInt((Object)name);
        }

        public int getInt(CharSequence name, int defaultValue) {
            return this.delegate.getInt((Object)name, defaultValue);
        }

        public Long getLong(CharSequence name) {
            return this.delegate.getLong((Object)name);
        }

        public long getLong(CharSequence name, long defaultValue) {
            return this.delegate.getLong((Object)name, defaultValue);
        }

        public Float getFloat(CharSequence name) {
            return this.delegate.getFloat((Object)name);
        }

        public float getFloat(CharSequence name, float defaultValue) {
            return this.delegate.getFloat((Object)name, defaultValue);
        }

        public Double getDouble(CharSequence name) {
            return this.delegate.getDouble((Object)name);
        }

        public double getDouble(CharSequence name, double defaultValue) {
            return this.delegate.getDouble((Object)name, defaultValue);
        }

        public Long getTimeMillis(CharSequence name) {
            return this.delegate.getTimeMillis((Object)name);
        }

        public long getTimeMillis(CharSequence name, long defaultValue) {
            return this.delegate.getTimeMillis((Object)name, defaultValue);
        }

        public Boolean getBooleanAndRemove(CharSequence name) {
            return this.delegate.getBooleanAndRemove((Object)name);
        }

        public boolean getBooleanAndRemove(CharSequence name, boolean defaultValue) {
            return this.delegate.getBooleanAndRemove((Object)name, defaultValue);
        }

        public Byte getByteAndRemove(CharSequence name) {
            return this.delegate.getByteAndRemove((Object)name);
        }

        public byte getByteAndRemove(CharSequence name, byte defaultValue) {
            return this.delegate.getByteAndRemove((Object)name, defaultValue);
        }

        public Character getCharAndRemove(CharSequence name) {
            return this.delegate.getCharAndRemove((Object)name);
        }

        public char getCharAndRemove(CharSequence name, char defaultValue) {
            return this.delegate.getCharAndRemove((Object)name, defaultValue);
        }

        public Short getShortAndRemove(CharSequence name) {
            return this.delegate.getShortAndRemove((Object)name);
        }

        public short getShortAndRemove(CharSequence name, short defaultValue) {
            return this.delegate.getShortAndRemove((Object)name, defaultValue);
        }

        public Integer getIntAndRemove(CharSequence name) {
            return this.delegate.getIntAndRemove((Object)name);
        }

        public int getIntAndRemove(CharSequence name, int defaultValue) {
            return this.delegate.getIntAndRemove((Object)name, defaultValue);
        }

        public Long getLongAndRemove(CharSequence name) {
            return this.delegate.getLongAndRemove((Object)name);
        }

        public long getLongAndRemove(CharSequence name, long defaultValue) {
            return this.delegate.getLongAndRemove((Object)name, defaultValue);
        }

        public Float getFloatAndRemove(CharSequence name) {
            return this.delegate.getFloatAndRemove((Object)name);
        }

        public float getFloatAndRemove(CharSequence name, float defaultValue) {
            return this.delegate.getFloatAndRemove((Object)name, defaultValue);
        }

        public Double getDoubleAndRemove(CharSequence name) {
            return this.delegate.getDoubleAndRemove((Object)name);
        }

        public double getDoubleAndRemove(CharSequence name, double defaultValue) {
            return this.delegate.getDoubleAndRemove((Object)name, defaultValue);
        }

        public Long getTimeMillisAndRemove(CharSequence name) {
            return this.delegate.getTimeMillisAndRemove((Object)name);
        }

        public long getTimeMillisAndRemove(CharSequence name, long defaultValue) {
            return this.delegate.getTimeMillisAndRemove((Object)name, defaultValue);
        }

        public boolean contains(CharSequence name) {
            return this.delegate.contains((Object)name);
        }

        public boolean contains(CharSequence name, CharSequence value) {
            return this.delegate.contains((Object)name, (Object)value);
        }

        public boolean containsObject(CharSequence name, Object value) {
            return this.delegate.containsObject((Object)name, value);
        }

        public boolean containsBoolean(CharSequence name, boolean value) {
            return this.delegate.containsBoolean((Object)name, value);
        }

        public boolean containsByte(CharSequence name, byte value) {
            return this.delegate.containsByte((Object)name, value);
        }

        public boolean containsChar(CharSequence name, char value) {
            return this.delegate.containsChar((Object)name, value);
        }

        public boolean containsShort(CharSequence name, short value) {
            return this.delegate.containsShort((Object)name, value);
        }

        public boolean containsInt(CharSequence name, int value) {
            return this.delegate.containsInt((Object)name, value);
        }

        public boolean containsLong(CharSequence name, long value) {
            return this.delegate.containsLong((Object)name, value);
        }

        public boolean containsFloat(CharSequence name, float value) {
            return this.delegate.containsFloat((Object)name, value);
        }

        public boolean containsDouble(CharSequence name, double value) {
            return this.delegate.containsDouble((Object)name, value);
        }

        public boolean containsTimeMillis(CharSequence name, long value) {
            return this.delegate.containsTimeMillis((Object)name, value);
        }

        public int size() {
            return this.delegate.size();
        }

        public boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        public Set<CharSequence> names() {
            return this.delegate.names();
        }

        public SlowHeaders add(CharSequence name, CharSequence value) {
            this.delegate.add((Object)name, (Object)value);
            return this;
        }

        public SlowHeaders add(CharSequence name, Iterable<? extends CharSequence> values) {
            this.delegate.add((Object)name, values);
            return this;
        }

        public SlowHeaders add(CharSequence name, CharSequence ... values) {
            this.delegate.add((Object)name, (Object[])values);
            return this;
        }

        public SlowHeaders addObject(CharSequence name, Object value) {
            this.delegate.addObject((Object)name, value);
            return this;
        }

        public SlowHeaders addObject(CharSequence name, Iterable<?> values) {
            this.delegate.addObject((Object)name, values);
            return this;
        }

        public SlowHeaders addObject(CharSequence name, Object ... values) {
            this.delegate.addObject((Object)name, values);
            return this;
        }

        public SlowHeaders addBoolean(CharSequence name, boolean value) {
            this.delegate.addBoolean((Object)name, value);
            return this;
        }

        public SlowHeaders addByte(CharSequence name, byte value) {
            this.delegate.addByte((Object)name, value);
            return this;
        }

        public SlowHeaders addChar(CharSequence name, char value) {
            this.delegate.addChar((Object)name, value);
            return this;
        }

        public SlowHeaders addShort(CharSequence name, short value) {
            this.delegate.addShort((Object)name, value);
            return this;
        }

        public SlowHeaders addInt(CharSequence name, int value) {
            this.delegate.addInt((Object)name, value);
            return this;
        }

        public SlowHeaders addLong(CharSequence name, long value) {
            this.delegate.addLong((Object)name, value);
            return this;
        }

        public SlowHeaders addFloat(CharSequence name, float value) {
            this.delegate.addFloat((Object)name, value);
            return this;
        }

        public SlowHeaders addDouble(CharSequence name, double value) {
            this.delegate.addDouble((Object)name, value);
            return this;
        }

        public SlowHeaders addTimeMillis(CharSequence name, long value) {
            this.delegate.addTimeMillis((Object)name, value);
            return this;
        }

        public SlowHeaders add(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            this.delegate.add(headers);
            return this;
        }

        public SlowHeaders set(CharSequence name, CharSequence value) {
            this.delegate.set((Object)name, (Object)value);
            return this;
        }

        public SlowHeaders set(CharSequence name, Iterable<? extends CharSequence> values) {
            this.delegate.set((Object)name, values);
            return this;
        }

        public SlowHeaders set(CharSequence name, CharSequence ... values) {
            this.delegate.set((Object)name, (Object[])values);
            return this;
        }

        public SlowHeaders setObject(CharSequence name, Object value) {
            this.delegate.setObject((Object)name, value);
            return this;
        }

        public SlowHeaders setObject(CharSequence name, Iterable<?> values) {
            this.delegate.setObject((Object)name, values);
            return this;
        }

        public SlowHeaders setObject(CharSequence name, Object ... values) {
            this.delegate.setObject((Object)name, values);
            return this;
        }

        public SlowHeaders setBoolean(CharSequence name, boolean value) {
            this.delegate.setBoolean((Object)name, value);
            return this;
        }

        public SlowHeaders setByte(CharSequence name, byte value) {
            this.delegate.setByte((Object)name, value);
            return this;
        }

        public SlowHeaders setChar(CharSequence name, char value) {
            this.delegate.setChar((Object)name, value);
            return this;
        }

        public SlowHeaders setShort(CharSequence name, short value) {
            this.delegate.setShort((Object)name, value);
            return this;
        }

        public SlowHeaders setInt(CharSequence name, int value) {
            this.delegate.setInt((Object)name, value);
            return this;
        }

        public SlowHeaders setLong(CharSequence name, long value) {
            this.delegate.setLong((Object)name, value);
            return this;
        }

        public SlowHeaders setFloat(CharSequence name, float value) {
            this.delegate.setFloat((Object)name, value);
            return this;
        }

        public SlowHeaders setDouble(CharSequence name, double value) {
            this.delegate.setDouble((Object)name, value);
            return this;
        }

        public SlowHeaders setTimeMillis(CharSequence name, long value) {
            this.delegate.setTimeMillis((Object)name, value);
            return this;
        }

        public SlowHeaders set(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            this.delegate.set(headers);
            return this;
        }

        public SlowHeaders setAll(Headers<? extends CharSequence, ? extends CharSequence, ?> headers) {
            this.delegate.setAll(headers);
            return this;
        }

        public boolean remove(CharSequence name) {
            return this.delegate.remove((Object)name);
        }

        public SlowHeaders clear() {
            this.delegate.clear();
            return this;
        }

        public Iterator<Map.Entry<CharSequence, CharSequence>> iterator() {
            return this.delegate.iterator();
        }
    }
}

