/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.internal.hpack.Encoder;
import io.netty.microbench.http2.internal.hpack.Header;
import io.netty.microbench.http2.internal.hpack.HeadersSize;
import io.netty.microbench.http2.internal.hpack.Util;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.AsciiString;
import io.netty.util.internal.ConstantTimeUtils;
import io.netty.util.internal.PlatformDependent;
import java.util.List;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@Threads(value=1)
@Warmup(iterations=5)
@Measurement(iterations=5)
public class HpackUtilBenchmark
extends AbstractMicrobenchmark {
    @Param
    public HeadersSize size;
    private List<Header> headers;

    @Setup(value=Level.Trial)
    public void setup() {
        this.headers = Util.headers(this.size, false);
    }

    @Benchmark
    public int oldEquals() {
        int count = 0;
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header = this.headers.get(i);
            if (!HpackUtilBenchmark.oldEquals(header.name, header.name)) continue;
            ++count;
        }
        return count;
    }

    @Benchmark
    public int newEquals() {
        int count = 0;
        for (int i = 0; i < this.headers.size(); ++i) {
            Header header = this.headers.get(i);
            if (!HpackUtilBenchmark.newEquals(header.name, header.name)) continue;
            ++count;
        }
        return count;
    }

    private static boolean oldEquals(CharSequence s1, CharSequence s2) {
        if (s1.length() != s2.length()) {
            return false;
        }
        int c = 0;
        for (int i = 0; i < s1.length(); ++i) {
            c = (char)(c | s1.charAt(i) ^ s2.charAt(i));
        }
        return c == 0;
    }

    private static boolean newEquals(CharSequence s1, CharSequence s2) {
        if (s1 instanceof AsciiString && s2 instanceof AsciiString) {
            if (s1.length() != s2.length()) {
                return false;
            }
            AsciiString s1Ascii = (AsciiString)s1;
            AsciiString s2Ascii = (AsciiString)s2;
            return PlatformDependent.equalsConstantTime((byte[])s1Ascii.array(), (int)s1Ascii.arrayOffset(), (byte[])s2Ascii.array(), (int)s2Ascii.arrayOffset(), (int)s1.length()) != 0;
        }
        return ConstantTimeUtils.equalsConstantTime((CharSequence)s1, (CharSequence)s2) != 0;
    }

    static Encoder newTestEncoder() {
        Encoder encoder = new Encoder();
        ByteBuf buf = Unpooled.buffer();
        try {
            encoder.setMaxHeaderTableSize(buf, 0xFFFFFFFFL);
            encoder.setMaxHeaderListSize(0xFFFFFFFFL);
        }
        catch (Http2Exception e) {
            throw new Error("max size not allowed?", e);
        }
        finally {
            buf.release();
        }
        return encoder;
    }
}

