/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2.internal.hpack;

import io.netty.util.AsciiString;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;

class Header {
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789-_";
    final CharSequence name;
    final CharSequence value;

    Header(byte[] name, byte[] value) {
        this.name = new AsciiString(name, false);
        this.value = new AsciiString(value, false);
    }

    static List<Header> createHeaders(int numHeaders, int nameLength, int valueLength, boolean limitToAscii) {
        ArrayList<Header> headers = new ArrayList<Header>(numHeaders);
        for (int i = 0; i < numHeaders; ++i) {
            byte[] name = Header.randomBytes(new byte[nameLength], limitToAscii);
            byte[] value = Header.randomBytes(new byte[valueLength], limitToAscii);
            headers.add(new Header(name, value));
        }
        return headers;
    }

    private static byte[] randomBytes(byte[] bytes, boolean limitToAscii) {
        Random r = new Random();
        if (limitToAscii) {
            for (int index = 0; index < bytes.length; ++index) {
                int charIndex = r.nextInt(ALPHABET.length());
                bytes[index] = (byte)ALPHABET.charAt(charIndex);
            }
        } else {
            r.nextBytes(bytes);
        }
        return bytes;
    }
}

