/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.handler.codec.http2.internal.hpack.Decoder;
import io.netty.handler.codec.http2.internal.hpack.Encoder;
import io.netty.microbench.http2.internal.hpack.HeadersSize;
import io.netty.microbench.http2.internal.hpack.HpackUtilBenchmark;
import io.netty.microbench.http2.internal.hpack.Util;
import io.netty.microbench.util.AbstractMicrobenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.infra.Blackhole;

public class DecoderBenchmark
extends AbstractMicrobenchmark {
    @Param
    public HeadersSize size;
    @Param(value={"true", "false"})
    public boolean sensitive;
    @Param(value={"true", "false"})
    public boolean limitToAscii;
    private ByteBuf input;

    @Setup(value=Level.Trial)
    public void setup() throws Http2Exception {
        this.input = Unpooled.wrappedBuffer((byte[])this.getSerializedHeaders(Util.http2Headers(this.size, this.limitToAscii), this.sensitive));
    }

    @TearDown(value=Level.Trial)
    public void teardown() {
        this.input.release();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    public void decode(final Blackhole bh) throws Http2Exception {
        Decoder decoder = new Decoder();
        DefaultHttp2Headers headers = new DefaultHttp2Headers(){

            public Http2Headers add(CharSequence name, CharSequence value) {
                bh.consume(DecoderBenchmark.this.sensitive);
                return this;
            }
        };
        decoder.decode(0, this.input.duplicate(), (Http2Headers)headers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getSerializedHeaders(Http2Headers headers, boolean sensitive) throws Http2Exception {
        Encoder encoder = HpackUtilBenchmark.newTestEncoder();
        ByteBuf out = this.size.newOutBuffer();
        try {
            encoder.encodeHeaders(3, out, headers, sensitive ? Http2HeadersEncoder.ALWAYS_SENSITIVE : Http2HeadersEncoder.NEVER_SENSITIVE);
            byte[] bytes = new byte[out.readableBytes()];
            out.readBytes(bytes);
            byte[] byArray = bytes;
            return byArray;
        }
        finally {
            out.release();
        }
    }
}

