/*
 * Decompiled with CFR 0.152.
 */
package io.netty.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@Warmup(iterations=5, time=1, timeUnit=TimeUnit.SECONDS)
@Measurement(iterations=10, time=1, timeUnit=TimeUnit.SECONDS)
public class AbstractByteBufGetCharSequenceBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"8", "64", "1024", "10240", "1073741824"})
    public int size;
    @Param(value={"US-ASCII", "ISO_8859_1"})
    public String charsetName;
    @Param
    public ByteBufType bufferType;
    private ByteBuf buffer;
    private Charset charset;

    @Override
    protected String[] jvmArgs() {
        return new String[]{"-XX:MaxDirectMemorySize=2g", "-Xmx8g", "-Xms8g", "-Xmn6g"};
    }

    @Setup
    public void setup() {
        byte[] bytes = new byte[this.size + 2];
        Arrays.fill(bytes, (byte)97);
        this.buffer = this.bufferType.newBuffer(bytes, this.size);
        this.charset = Charset.forName(this.charsetName);
    }

    @TearDown
    public void teardown() {
        this.buffer.release();
    }

    @Benchmark
    public int getCharSequence() {
        return AbstractByteBufGetCharSequenceBenchmark.traverse(this.buffer.getCharSequence(this.buffer.readerIndex(), this.size, this.charset));
    }

    @Benchmark
    public int getCharSequenceOld() {
        return AbstractByteBufGetCharSequenceBenchmark.traverse(this.buffer.toString(this.buffer.readerIndex(), this.size, this.charset));
    }

    private static int traverse(CharSequence cs) {
        int i = 0;
        int len = cs.length();
        while (i < len && cs.charAt(i++) != '\u0000') {
        }
        return i;
    }

    public static enum ByteBufType {
        DIRECT{

            @Override
            ByteBuf newBuffer(byte[] bytes, int length) {
                ByteBuf buffer = Unpooled.directBuffer((int)length);
                buffer.writeBytes(bytes, 0, length);
                return buffer;
            }
        }
        ,
        HEAP_OFFSET{

            @Override
            ByteBuf newBuffer(byte[] bytes, int length) {
                return Unpooled.wrappedBuffer((byte[])bytes, (int)1, (int)length);
            }
        }
        ,
        HEAP{

            @Override
            ByteBuf newBuffer(byte[] bytes, int length) {
                return Unpooled.wrappedBuffer((byte[])bytes, (int)0, (int)length);
            }
        }
        ,
        COMPOSITE{

            @Override
            ByteBuf newBuffer(byte[] bytes, int length) {
                CompositeByteBuf buffer = Unpooled.compositeBuffer();
                int offset = 0;
                int capacity = length / 8;
                while (length > 0) {
                    buffer.addComponent(true, Unpooled.wrappedBuffer((byte[])bytes, (int)offset, (int)Math.min(length, capacity)));
                    length -= capacity;
                    offset += capacity;
                }
                return buffer;
            }
        };


        abstract ByteBuf newBuffer(byte[] var1, int var2);
    }
}

