/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2.internal.hpack;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.internal.hpack.Encoder;
import io.netty.microbench.http2.internal.hpack.Header;
import io.netty.microbench.http2.internal.hpack.HeadersSize;
import io.netty.microbench.http2.internal.hpack.Util;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Fork(value=1)
@Threads(value=1)
@State(value=Scope.Benchmark)
@Warmup(iterations=5)
@Measurement(iterations=5)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class EncoderBenchmark
extends AbstractMicrobenchmark {
    @Param
    public HeadersSize size;
    @Param(value={"4096"})
    public int maxTableSize;
    @Param(value={"true", "false"})
    public boolean sensitive;
    @Param(value={"true", "false"})
    public boolean duplicates;
    @Param(value={"true", "false"})
    public boolean limitToAscii;
    private List<Header> headers;
    private ByteBuf output;

    @Setup(value=Level.Trial)
    public void setup() {
        this.headers = Util.headers(this.size, this.limitToAscii);
        this.output = this.size.newOutBuffer();
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.output.release();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void encode(Blackhole bh) throws IOException {
        Encoder encoder = new Encoder(this.maxTableSize);
        this.output.clear();
        if (this.duplicates) {
            Header header = this.headers.get(0);
            for (int i = 0; i < this.headers.size(); ++i) {
                encoder.encodeHeader(this.output, header.name, header.value, this.sensitive);
            }
        } else {
            for (int i = 0; i < this.headers.size(); ++i) {
                Header header = this.headers.get(i);
                encoder.encodeHeader(this.output, header.name, header.value, this.sensitive);
            }
        }
        bh.consume((Object)this.output);
    }
}

