/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.http2;

import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.http2.HpackBenchmarkUtil;
import io.netty.handler.codec.http2.HpackEncoder;
import io.netty.handler.codec.http2.HpackHeadersSize;
import io.netty.handler.codec.http2.HpackUtilBenchmark;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2HeadersEncoder;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.OutputTimeUnit;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;
import org.openjdk.jmh.infra.Blackhole;

@Fork(value=1)
@Threads(value=1)
@State(value=Scope.Benchmark)
@Warmup(iterations=5)
@Measurement(iterations=5)
@OutputTimeUnit(value=TimeUnit.NANOSECONDS)
public class HpackEncoderBenchmark
extends AbstractMicrobenchmark {
    @Param
    public HpackHeadersSize size;
    @Param(value={"true", "false"})
    public boolean sensitive;
    @Param(value={"true", "false"})
    public boolean duplicates;
    @Param(value={"true", "false"})
    public boolean limitToAscii;
    private Http2Headers http2Headers;
    private ByteBuf output;
    private Http2HeadersEncoder.SensitivityDetector sensitivityDetector;

    @Setup(value=Level.Trial)
    public void setup() {
        int size;
        this.http2Headers = HpackBenchmarkUtil.http2Headers(this.size, this.limitToAscii);
        if (this.duplicates && (size = this.http2Headers.size()) > 0) {
            Iterator itr = this.http2Headers.iterator();
            Map.Entry entry = (Map.Entry)itr.next();
            this.http2Headers.clear();
            for (int i = 0; i < size; ++i) {
                this.http2Headers.add(entry.getKey(), entry.getValue());
            }
        }
        this.output = this.size.newOutBuffer();
        this.sensitivityDetector = this.sensitive ? Http2HeadersEncoder.ALWAYS_SENSITIVE : Http2HeadersEncoder.NEVER_SENSITIVE;
    }

    @TearDown(value=Level.Trial)
    public void tearDown() {
        this.output.release();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.AverageTime})
    public void encode(Blackhole bh) throws Exception {
        HpackEncoder hpackEncoder = HpackUtilBenchmark.newTestEncoder();
        this.output.clear();
        hpackEncoder.encodeHeaders(3, this.output, this.http2Headers, this.sensitivityDetector);
        bh.consume((Object)this.output);
    }
}

