/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;

public class ByteBufCopyBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"7", "36", "128", "512"})
    private int size;
    @Param(value={"true", "false"})
    private boolean directByteBuff;
    @Param(value={"true", "false"})
    private boolean directByteBuffer;
    @Param(value={"false", "true"})
    private boolean readonlyByteBuffer;
    @Param(value={"true", "false"})
    private boolean pooledByteBuf;
    @Param(value={"true", "false"})
    private boolean alignedCopyByteBuffer;
    @Param(value={"true", "false"})
    private boolean alignedCopyByteBuf;
    @Param(value={"true", "false"})
    private boolean nativeOrderByteBuffer;
    private ByteBuffer byteBuffer;
    private ByteBuf buffer;
    private int index;

    @Setup
    public void setup() {
        int requiredByteBufSize = this.alignedCopyByteBuf ? this.size : this.size + 1;
        int requiredByteBufferSize = this.alignedCopyByteBuffer ? this.size : this.size + 1;
        ByteBuffer byteBuffer = this.byteBuffer = this.directByteBuffer ? ByteBuffer.allocateDirect(requiredByteBufferSize) : ByteBuffer.allocate(requiredByteBufferSize);
        if (this.pooledByteBuf) {
            this.buffer = this.directByteBuff ? PooledByteBufAllocator.DEFAULT.directBuffer(requiredByteBufSize, requiredByteBufSize) : PooledByteBufAllocator.DEFAULT.heapBuffer(requiredByteBufSize, requiredByteBufSize);
        } else {
            ByteBuf byteBuf = this.buffer = this.directByteBuff ? Unpooled.directBuffer((int)requiredByteBufSize, (int)requiredByteBufSize) : Unpooled.buffer((int)requiredByteBufSize, (int)requiredByteBufSize);
        }
        if (!this.alignedCopyByteBuffer) {
            this.byteBuffer.position(1);
            this.byteBuffer = this.byteBuffer.slice();
        }
        if (this.readonlyByteBuffer) {
            this.byteBuffer = this.byteBuffer.asReadOnlyBuffer();
        }
        ByteOrder byteBufferOrder = !this.nativeOrderByteBuffer ? (ByteOrder.LITTLE_ENDIAN == ByteOrder.nativeOrder() ? ByteOrder.BIG_ENDIAN : ByteOrder.LITTLE_ENDIAN) : ByteOrder.nativeOrder();
        this.byteBuffer.order(byteBufferOrder);
        this.index = this.alignedCopyByteBuf ? 0 : 1;
    }

    @Benchmark
    public ByteBuf setBytes() {
        this.byteBuffer.clear();
        return this.buffer.setBytes(this.index, this.byteBuffer);
    }

    @TearDown
    public void tearDown() {
        this.buffer.release();
    }

    static {
        System.setProperty("io.netty.buffer.bytebuf.checkAccessible", "false");
    }
}

