/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.nio.ByteBuffer;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.TearDown;

public class ByteBufBenchmark
extends AbstractMicrobenchmark {
    private static final byte BYTE = 48;
    @Param(value={"true", "false"})
    public String checkBounds;
    private ByteBuffer byteBuffer;
    private ByteBuffer directByteBuffer;
    private ByteBuf buffer;
    private ByteBuf directBuffer;
    private ByteBuf directBufferPooled;

    @Setup
    public void setup() {
        System.setProperty("io.netty.buffer.checkBounds", this.checkBounds);
        this.byteBuffer = ByteBuffer.allocate(8);
        this.directByteBuffer = ByteBuffer.allocateDirect(8);
        this.buffer = Unpooled.buffer((int)8);
        this.directBuffer = Unpooled.directBuffer((int)8);
        this.directBufferPooled = PooledByteBufAllocator.DEFAULT.directBuffer(8);
    }

    @TearDown
    public void tearDown() {
        this.buffer.release();
        this.directBuffer.release();
        this.directBufferPooled.release();
    }

    @Benchmark
    public ByteBuffer setByteBufferHeap() {
        return this.byteBuffer.put(0, (byte)48);
    }

    @Benchmark
    public ByteBuffer setByteBufferDirect() {
        return this.directByteBuffer.put(0, (byte)48);
    }

    @Benchmark
    public ByteBuf setByteBufHeap() {
        return this.buffer.setByte(0, 48);
    }

    @Benchmark
    public ByteBuf setByteBufDirect() {
        return this.directBuffer.setByte(0, 48);
    }

    @Benchmark
    public ByteBuf setByteBufDirectPooled() {
        return this.directBufferPooled.setByte(0, 48);
    }

    static {
        System.setProperty("io.netty.buffer.checkAccessible", "false");
    }
}

