/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultFullHttpRequest;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.DefaultHttpRequest;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.EmptyHttpHeaders;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpRequestEncoder;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.microbench.channel.EmbeddedChannelWriteReleaseHandlerContext;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.microbench.util.AbstractMicrobenchmarkBase;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Threads;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Fork(value=1)
@Threads(value=1)
@Warmup(iterations=5)
@Measurement(iterations=10)
public class HttpObjectEncoderBenchmark
extends AbstractMicrobenchmark {
    private HttpRequestEncoder encoder;
    private FullHttpRequest fullRequest;
    private LastHttpContent lastContent;
    private HttpRequest contentLengthRequest;
    private HttpRequest chunkedRequest;
    private ByteBuf content;
    private ChannelHandlerContext context;
    @Param(value={"true", "false"})
    public boolean pooledAllocator;
    @Param(value={"true", "false"})
    public boolean voidPromise;

    @Setup(value=Level.Trial)
    public void setup() {
        byte[] bytes = new byte[256];
        this.content = Unpooled.buffer((int)bytes.length);
        this.content.writeBytes(bytes);
        ByteBuf testContent = Unpooled.unreleasableBuffer((ByteBuf)this.content.asReadOnly());
        DefaultHttpHeaders headersWithChunked = new DefaultHttpHeaders(false);
        headersWithChunked.add((CharSequence)HttpHeaderNames.TRANSFER_ENCODING, (Object)HttpHeaderValues.CHUNKED);
        DefaultHttpHeaders headersWithContentLength = new DefaultHttpHeaders(false);
        headersWithContentLength.add((CharSequence)HttpHeaderNames.CONTENT_LENGTH, (Object)testContent.readableBytes());
        this.fullRequest = new DefaultFullHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/index", testContent, (HttpHeaders)headersWithContentLength, (HttpHeaders)EmptyHttpHeaders.INSTANCE);
        this.contentLengthRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/index", (HttpHeaders)headersWithContentLength);
        this.chunkedRequest = new DefaultHttpRequest(HttpVersion.HTTP_1_1, HttpMethod.POST, "/index", (HttpHeaders)headersWithChunked);
        this.lastContent = new DefaultLastHttpContent(testContent, false);
        this.encoder = new HttpRequestEncoder();
        this.context = new EmbeddedChannelWriteReleaseHandlerContext((ByteBufAllocator)(this.pooledAllocator ? PooledByteBufAllocator.DEFAULT : UnpooledByteBufAllocator.DEFAULT), (ChannelHandler)this.encoder){

            @Override
            protected void handleException(Throwable t) {
                AbstractMicrobenchmarkBase.handleUnexpectedException(t);
            }
        };
    }

    @TearDown(value=Level.Trial)
    public void teardown() {
        this.content.release();
        this.content = null;
    }

    @Benchmark
    public void fullMessage() throws Exception {
        this.encoder.write(this.context, (Object)this.fullRequest, this.newPromise());
    }

    @Benchmark
    public void contentLength() throws Exception {
        this.encoder.write(this.context, (Object)this.contentLengthRequest, this.newPromise());
        this.encoder.write(this.context, (Object)this.lastContent, this.newPromise());
    }

    @Benchmark
    public void chunked() throws Exception {
        this.encoder.write(this.context, (Object)this.chunkedRequest, this.newPromise());
        this.encoder.write(this.context, (Object)this.lastContent, this.newPromise());
    }

    private ChannelPromise newPromise() {
        return this.voidPromise ? this.context.voidPromise() : this.context.newPromise();
    }
}

