/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbenchmark.common;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.collection.IntObjectHashMap;
import java.util.HashSet;
import java.util.Random;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.infra.Blackhole;
import uk.co.real_logic.agrona.collections.Int2ObjectHashMap;

public class IntObjectHashMapBenchmark
extends AbstractMicrobenchmark {
    private static final Long VALUE = Long.MAX_VALUE;
    @Param(value={"10", "100", "1000", "10000", "100000"})
    public int size;
    @Param
    public MapType mapType;
    @Param
    public KeyDistribution keyDistribution;
    private Environment environment;

    @Setup(value=Level.Trial)
    public void setup() {
        switch (this.mapType) {
            case AGRONA: {
                this.environment = new AgronaEnvironment();
                break;
            }
            case NETTY: {
                this.environment = new NettyEnvironment();
                break;
            }
            default: {
                throw new IllegalStateException("Invalid mapType: " + (Object)((Object)this.mapType));
            }
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    public void put(Blackhole bh) {
        this.environment.put(bh);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    public void lookup(Blackhole bh) {
        this.environment.lookup(bh);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    public void remove(Blackhole bh) {
        this.environment.remove(bh);
    }

    private class NettyEnvironment
    extends Environment {
        private final IntObjectHashMap<Long> map;

        NettyEnvironment() {
            this.map = new IntObjectHashMap();
            for (int key : this.keys) {
                this.map.put(key, (Object)VALUE);
            }
        }

        @Override
        void put(Blackhole bh) {
            IntObjectHashMap map = new IntObjectHashMap();
            for (int key : this.keys) {
                bh.consume(map.put(key, (Object)VALUE));
            }
        }

        @Override
        void lookup(Blackhole bh) {
            for (int key : this.keys) {
                bh.consume(this.map.get(key));
            }
        }

        @Override
        void remove(Blackhole bh) {
            IntObjectHashMap copy = new IntObjectHashMap();
            copy.putAll(this.map);
            for (int key : this.keys) {
                bh.consume(copy.remove(key));
            }
        }
    }

    private class AgronaEnvironment
    extends Environment {
        private final Int2ObjectHashMap<Long> map;

        AgronaEnvironment() {
            this.map = new Int2ObjectHashMap();
            for (int key : this.keys) {
                this.map.put(key, (Object)VALUE);
            }
        }

        @Override
        void put(Blackhole bh) {
            Int2ObjectHashMap map = new Int2ObjectHashMap();
            for (int key : this.keys) {
                bh.consume(map.put(key, (Object)VALUE));
            }
        }

        @Override
        void lookup(Blackhole bh) {
            for (int key : this.keys) {
                bh.consume(this.map.get(key));
            }
        }

        @Override
        void remove(Blackhole bh) {
            Int2ObjectHashMap copy = new Int2ObjectHashMap();
            copy.putAll(this.map);
            for (int key : this.keys) {
                bh.consume(copy.remove(key));
            }
        }
    }

    private abstract class Environment {
        final int[] keys;

        Environment() {
            this.keys = new int[IntObjectHashMapBenchmark.this.size];
            switch (IntObjectHashMapBenchmark.this.keyDistribution) {
                case HTTP2: {
                    int index = 0;
                    int key = 3;
                    while (index < IntObjectHashMapBenchmark.this.size) {
                        this.keys[index] = key;
                        ++index;
                        key += 2;
                    }
                    break;
                }
                case RANDOM: {
                    Random r = new Random();
                    HashSet<Integer> keySet = new HashSet<Integer>();
                    while (keySet.size() < IntObjectHashMapBenchmark.this.size) {
                        keySet.add(r.nextInt());
                    }
                    int index = 0;
                    for (Integer key : keySet) {
                        this.keys[index++] = key;
                    }
                    break;
                }
                default: {
                    throw new IllegalStateException("Unknown keyDistribution: " + (Object)((Object)IntObjectHashMapBenchmark.this.keyDistribution));
                }
            }
        }

        abstract void put(Blackhole var1);

        abstract void lookup(Blackhole var1);

        abstract void remove(Blackhole var1);
    }

    public static enum KeyDistribution {
        HTTP2,
        RANDOM;

    }

    public static enum MapType {
        AGRONA,
        NETTY;

    }
}

