/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2.hpack;

import io.netty.handler.codec.http2.hpack.Decoder;
import io.netty.handler.codec.http2.hpack.Encoder;
import io.netty.handler.codec.http2.hpack.HeaderListener;
import io.netty.microbench.http2.hpack.Header;
import io.netty.microbench.http2.hpack.HeadersSize;
import io.netty.microbench.http2.hpack.Util;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.infra.Blackhole;

public class DecoderBenchmark
extends AbstractMicrobenchmark {
    @Param
    public HeadersSize size;
    @Param(value={"4096"})
    public int maxTableSize;
    @Param(value={"8192"})
    public int maxHeaderSize;
    @Param(value={"true", "false"})
    public boolean sensitive;
    @Param(value={"true", "false"})
    public boolean limitToAscii;
    private byte[] input;

    @Setup(value=Level.Trial)
    public void setup() throws IOException {
        this.input = this.getSerializedHeaders(Util.headers(this.size, this.limitToAscii), this.sensitive);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    public void decode(final Blackhole bh) throws IOException {
        Decoder decoder = new Decoder(this.maxHeaderSize, this.maxTableSize);
        decoder.decode((InputStream)new ByteArrayInputStream(this.input), new HeaderListener(){

            public void addHeader(byte[] name, byte[] value, boolean sensitive) {
                bh.consume(sensitive);
            }
        });
        decoder.endHeaderBlock();
    }

    private byte[] getSerializedHeaders(List<Header> headers, boolean sensitive) throws IOException {
        Encoder encoder = new Encoder(4096);
        ByteArrayOutputStream outputStream = this.size.newOutputStream();
        for (int i = 0; i < headers.size(); ++i) {
            Header header = headers.get(i);
            encoder.encodeHeader((OutputStream)outputStream, header.name, header.value, sensitive);
        }
        return outputStream.toByteArray();
    }
}

