/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2.hpack;

import io.netty.handler.codec.http2.hpack.Encoder;
import io.netty.microbench.http2.hpack.Header;
import io.netty.microbench.http2.hpack.HeadersSize;
import io.netty.microbench.http2.hpack.Util;
import io.netty.microbench.util.AbstractMicrobenchmark;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.List;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.infra.Blackhole;

public class EncoderBenchmark
extends AbstractMicrobenchmark {
    @Param
    public HeadersSize size;
    @Param(value={"4096"})
    public int maxTableSize;
    @Param(value={"true", "false"})
    public boolean sensitive;
    @Param(value={"true", "false"})
    public boolean duplicates;
    @Param(value={"true", "false"})
    public boolean limitToAscii;
    private List<Header> headers;
    private ByteArrayOutputStream outputStream;

    @Setup(value=Level.Trial)
    public void setup() {
        this.headers = Util.headers(this.size, this.limitToAscii);
        this.outputStream = this.size.newOutputStream();
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    public void encode(Blackhole bh) throws IOException {
        Encoder encoder = new Encoder(this.maxTableSize);
        this.outputStream.reset();
        if (this.duplicates) {
            Header header = this.headers.get(0);
            for (int i = 0; i < this.headers.size(); ++i) {
                encoder.encodeHeader((OutputStream)this.outputStream, header.name, header.value, this.sensitive);
            }
        } else {
            for (int i = 0; i < this.headers.size(); ++i) {
                Header header = this.headers.get(i);
                encoder.encodeHeader((OutputStream)this.outputStream, header.name, header.value, this.sensitive);
            }
        }
        bh.consume((Object)this.outputStream);
    }
}

