/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.http2;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.oio.OioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.channel.socket.oio.OioServerSocketChannel;
import io.netty.channel.socket.oio.OioSocketChannel;
import io.netty.handler.codec.http2.DefaultHttp2Connection;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionDecoder;
import io.netty.handler.codec.http2.DefaultHttp2ConnectionEncoder;
import io.netty.handler.codec.http2.DefaultHttp2FrameReader;
import io.netty.handler.codec.http2.DefaultHttp2FrameWriter;
import io.netty.handler.codec.http2.DefaultHttp2Headers;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionDecoder;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2ConnectionHandler;
import io.netty.handler.codec.http2.Http2FlowController;
import io.netty.handler.codec.http2.Http2FrameAdapter;
import io.netty.handler.codec.http2.Http2FrameListener;
import io.netty.handler.codec.http2.Http2FrameReader;
import io.netty.handler.codec.http2.Http2FrameWriter;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.Http2LocalFlowController;
import io.netty.handler.codec.http2.Http2RemoteFlowController;
import io.netty.microbench.channel.EmbeddedChannelWriteReleaseHandlerContext;
import io.netty.microbench.http2.NoopHttp2LocalFlowController;
import io.netty.microbench.http2.NoopHttp2RemoteFlowController;
import io.netty.microbench.util.AbstractSharedExecutorMicrobenchmark;
import io.netty.util.AsciiString;
import io.netty.util.ByteString;
import io.netty.util.concurrent.Future;
import io.netty.util.internal.ObjectUtil;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;

@State(value=Scope.Benchmark)
public class Http2FrameWriterBenchmark
extends AbstractSharedExecutorMicrobenchmark {
    private static final EnvironmentParameters NIO_UNPOOLED_PARAMS = new NioEnvironmentParametersBase((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    private static final EnvironmentParameters NIO_POOLED_PARAMS = new NioEnvironmentParametersBase((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    private static final EnvironmentParameters EPOLL_UNPOOLED_PARAMS = new EpollEnvironmentParametersBase((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    private static final EnvironmentParameters EPOLL_POOLED_PARAMS = new EpollEnvironmentParametersBase((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    private static final EnvironmentParameters OIO_UNPOOLED_PARAMS = new OioEnvironmentParametersBase((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
    private static final EnvironmentParameters OIO_POOLED_PARAMS = new OioEnvironmentParametersBase((ByteBufAllocator)PooledByteBufAllocator.DEFAULT);
    @Param
    public EnvironmentType environmentType;
    @Param
    public DataPayloadType dataType;
    @Param(value={"0", "255"})
    public int padding;
    private Environment environment;
    private BenchmarkTestPayload payload;

    @Setup(value=Level.Trial)
    public void setup() {
        switch (this.environmentType) {
            case EMBEDDED_POOLED: 
            case EMBEDDED_UNPOOLED: {
                this.environment = Http2FrameWriterBenchmark.boostrapEmbeddedEnv(this.environmentType);
                break;
            }
            default: {
                this.environment = Http2FrameWriterBenchmark.boostrapEnvWithTransport(this.environmentType);
            }
        }
        if (this.environment == null) {
            throw new IllegalStateException("Environment type [" + (Object)((Object)this.environmentType) + "] is not supported.");
        }
        AbstractSharedExecutorMicrobenchmark.executor(this.environment.eventLoop());
        this.payload = Http2FrameWriterBenchmark.createPayload(this.dataType);
    }

    @TearDown(value=Level.Trial)
    public void teardown() throws Exception {
        try {
            this.environment.teardown();
        }
        finally {
            this.payload.release();
        }
    }

    @Benchmark
    public void writeData() {
        ChannelHandlerContext context = this.environment.context();
        this.environment.writer().writeData(context, 3, this.payload.data().retain(), this.padding, true, context.voidPromise());
        context.flush();
    }

    @Benchmark
    public void writeHeaders() {
        ChannelHandlerContext context = this.environment.context();
        this.environment.writer().writeHeaders(context, 3, this.payload.headers(), this.padding, true, context.voidPromise());
        context.flush();
    }

    private static Http2Headers createHeaders(int numValues, int nameLength, int valueLength) {
        DefaultHttp2Headers headers = new DefaultHttp2Headers();
        Random r = new Random();
        for (int i = 0; i < numValues; ++i) {
            byte[] tmp = new byte[nameLength];
            r.nextBytes(tmp);
            AsciiString name = new AsciiString(tmp);
            tmp = new byte[valueLength];
            r.nextBytes(tmp);
            headers.add((ByteString)name, (ByteString)new AsciiString(tmp));
        }
        return headers;
    }

    private static ByteBuf createData(int length) {
        byte[] result = new byte[length];
        new Random().nextBytes(result);
        return Unpooled.wrappedBuffer((byte[])result);
    }

    private static BenchmarkTestPayload createPayload(DataPayloadType type) {
        switch (type) {
            case SMALL: {
                return new BenchmarkTestPayload(Http2FrameWriterBenchmark.createData(256), Http2FrameWriterBenchmark.createHeaders(5, 20, 20));
            }
            case MEDIUM: {
                return new BenchmarkTestPayload(Http2FrameWriterBenchmark.createData(16384), Http2FrameWriterBenchmark.createHeaders(20, 40, 40));
            }
            case LARGE: {
                return new BenchmarkTestPayload(Http2FrameWriterBenchmark.createData(0xFFFFFF), Http2FrameWriterBenchmark.createHeaders(100, 100, 100));
            }
            case JUMBO: {
                return new BenchmarkTestPayload(Http2FrameWriterBenchmark.createData(0x9FFFFF6), Http2FrameWriterBenchmark.createHeaders(300, 300, 300));
            }
        }
        throw new Error();
    }

    private static Environment boostrapEnvWithTransport(EnvironmentType environmentType) {
        final EnvironmentParameters params = environmentType.params();
        ServerBootstrap sb = new ServerBootstrap();
        Bootstrap cb = new Bootstrap();
        final TransportEnvironment environment = new TransportEnvironment(cb, sb);
        EventLoopGroup serverEventLoopGroup = params.newEventLoopGroup();
        sb.group(serverEventLoopGroup, serverEventLoopGroup);
        sb.channel(params.serverChannelClass());
        sb.option(ChannelOption.ALLOCATOR, (Object)params.serverAllocator());
        sb.childOption(ChannelOption.ALLOCATOR, (Object)params.serverAllocator());
        sb.childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
            }
        });
        cb.group(params.newEventLoopGroup());
        cb.channel(params.clientChannelClass());
        cb.option(ChannelOption.ALLOCATOR, (Object)params.clientAllocator());
        final CountDownLatch latch = new CountDownLatch(1);
        cb.handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel ch) throws Exception {
                Http2LocalFlowController localFlowController;
                ChannelPipeline p = ch.pipeline();
                DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
                Http2RemoteFlowController remoteFlowController = params.remoteFlowController();
                if (remoteFlowController != null) {
                    connection.remote().flowController((Http2FlowController)params.remoteFlowController());
                }
                if ((localFlowController = params.localFlowController()) != null) {
                    connection.local().flowController((Http2FlowController)localFlowController);
                }
                environment.writer((Http2FrameWriter)new DefaultHttp2FrameWriter());
                DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder((Http2Connection)connection, environment.writer());
                DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder((Http2Connection)connection, (Http2ConnectionEncoder)encoder, (Http2FrameReader)new DefaultHttp2FrameReader());
                Http2ConnectionHandler connectionHandler = ((Http2ConnectionHandler.Builder)((Http2ConnectionHandler.Builder)new Http2ConnectionHandler.Builder().encoderEnforceMaxConcurrentStreams(false)).frameListener((Http2FrameListener)new Http2FrameAdapter())).build((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)encoder);
                p.addLast(new ChannelHandler[]{connectionHandler});
                environment.context(p.lastContext());
                latch.countDown();
            }
        });
        environment.serverChannel(sb.bind(params.address()));
        params.address(environment.serverChannel().localAddress());
        environment.clientChannel(cb.connect(params.address()));
        try {
            if (!latch.await(5L, TimeUnit.SECONDS)) {
                throw new RuntimeException("Channel did not initialize in time");
            }
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(ie);
        }
        return environment;
    }

    private static Environment boostrapEmbeddedEnv(EnvironmentType environmentType) {
        ByteBufAllocator alloc = environmentType.params().clientAllocator();
        EmbeddedEnvironment env = new EmbeddedEnvironment((Http2FrameWriter)new DefaultHttp2FrameWriter());
        DefaultHttp2Connection connection = new DefaultHttp2Connection(false);
        DefaultHttp2ConnectionEncoder encoder = new DefaultHttp2ConnectionEncoder((Http2Connection)connection, env.writer());
        DefaultHttp2ConnectionDecoder decoder = new DefaultHttp2ConnectionDecoder((Http2Connection)connection, (Http2ConnectionEncoder)encoder, (Http2FrameReader)new DefaultHttp2FrameReader());
        Http2ConnectionHandler connectionHandler = ((Http2ConnectionHandler.Builder)((Http2ConnectionHandler.Builder)new Http2ConnectionHandler.Builder().encoderEnforceMaxConcurrentStreams(false)).frameListener((Http2FrameListener)new Http2FrameAdapter())).build((Http2ConnectionDecoder)decoder, (Http2ConnectionEncoder)encoder);
        env.context(new EmbeddedChannelWriteReleaseHandlerContext(alloc, (ChannelHandler)connectionHandler){

            @Override
            protected void handleException(Throwable t) {
                AbstractSharedExecutorMicrobenchmark.handleUnexpectedException(t);
            }
        });
        return env;
    }

    static /* synthetic */ EnvironmentParameters access$000() {
        return NIO_POOLED_PARAMS;
    }

    static /* synthetic */ EnvironmentParameters access$100() {
        return NIO_UNPOOLED_PARAMS;
    }

    static /* synthetic */ EnvironmentParameters access$200() {
        return EPOLL_POOLED_PARAMS;
    }

    static /* synthetic */ EnvironmentParameters access$300() {
        return EPOLL_UNPOOLED_PARAMS;
    }

    static /* synthetic */ EnvironmentParameters access$400() {
        return OIO_POOLED_PARAMS;
    }

    static /* synthetic */ EnvironmentParameters access$500() {
        return OIO_UNPOOLED_PARAMS;
    }

    private static final class EmbeddedEnvironment
    implements Environment {
        private final Http2FrameWriter writer;
        private ChannelHandlerContext context;
        private EventLoop eventLoop;

        public EmbeddedEnvironment(Http2FrameWriter writer) {
            this.writer = (Http2FrameWriter)ObjectUtil.checkNotNull((Object)writer, (String)"writer");
        }

        @Override
        public EventLoop eventLoop() {
            return this.eventLoop;
        }

        public void context(EmbeddedChannelWriteReleaseHandlerContext context) {
            this.context = (ChannelHandlerContext)ObjectUtil.checkNotNull((Object)context, (String)"context");
            Channel channel = (Channel)ObjectUtil.checkNotNull((Object)context.channel(), (String)"context.channel()");
            this.eventLoop = (EventLoop)ObjectUtil.checkNotNull((Object)channel.eventLoop(), (String)"channel.eventLoop()");
        }

        @Override
        public ChannelHandlerContext context() {
            return this.context;
        }

        @Override
        public Http2FrameWriter writer() {
            return this.writer;
        }

        @Override
        public void teardown() throws Exception {
        }
    }

    private static final class TransportEnvironment
    implements Environment {
        private final ServerBootstrap sb;
        private final Bootstrap cb;
        private Channel serverChannel;
        private Channel clientChannel;
        private ChannelHandlerContext clientContext;
        private Http2FrameWriter clientWriter;

        public TransportEnvironment(Bootstrap cb, ServerBootstrap sb) {
            this.sb = (ServerBootstrap)ObjectUtil.checkNotNull((Object)sb, (String)"sb");
            this.cb = (Bootstrap)ObjectUtil.checkNotNull((Object)cb, (String)"cb");
        }

        @Override
        public EventLoop eventLoop() {
            return this.clientChannel.eventLoop();
        }

        public Channel serverChannel() {
            return this.serverChannel;
        }

        public void serverChannel(ChannelFuture bindFuture) {
            this.serverChannel = ((ChannelFuture)ObjectUtil.checkNotNull((Object)bindFuture, (String)"bindFuture")).channel();
        }

        public void clientChannel(ChannelFuture connectFuture) {
            this.clientChannel = ((ChannelFuture)ObjectUtil.checkNotNull((Object)connectFuture, (String)"connectFuture")).channel();
        }

        public void context(ChannelHandlerContext context) {
            this.clientContext = (ChannelHandlerContext)ObjectUtil.checkNotNull((Object)context, (String)"context");
        }

        @Override
        public ChannelHandlerContext context() {
            return this.clientContext;
        }

        @Override
        public void teardown() throws InterruptedException {
            if (this.clientChannel != null) {
                this.clientChannel.close();
            }
            if (this.serverChannel != null) {
                this.serverChannel.close();
            }
            Future serverGroup = null;
            Future serverChildGroup = null;
            Future clientGroup = null;
            if (this.sb != null) {
                serverGroup = this.sb.group().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
                serverChildGroup = this.sb.childGroup().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            }
            if (this.cb != null) {
                clientGroup = this.cb.group().shutdownGracefully(0L, 0L, TimeUnit.MILLISECONDS);
            }
            if (this.sb != null) {
                serverGroup.sync();
                serverChildGroup.sync();
            }
            if (this.cb != null) {
                clientGroup.sync();
            }
        }

        public void writer(Http2FrameWriter writer) {
            this.clientWriter = (Http2FrameWriter)ObjectUtil.checkNotNull((Object)writer, (String)"writer");
        }

        @Override
        public Http2FrameWriter writer() {
            return this.clientWriter;
        }
    }

    private static class OioEnvironmentParametersBase
    extends EnvironmentParametersBase {
        OioEnvironmentParametersBase(ByteBufAllocator clientAlloc) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, clientAlloc, OioServerSocketChannel.class, OioSocketChannel.class);
        }

        @Override
        public EventLoopGroup newEventLoopGroup() {
            return new OioEventLoopGroup(1);
        }
    }

    private static class EpollEnvironmentParametersBase
    extends EnvironmentParametersBase {
        EpollEnvironmentParametersBase(ByteBufAllocator clientAlloc) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, clientAlloc, EpollServerSocketChannel.class, EpollSocketChannel.class);
        }

        @Override
        public EventLoopGroup newEventLoopGroup() {
            return new EpollEventLoopGroup(1);
        }
    }

    private static class NioEnvironmentParametersBase
    extends EnvironmentParametersBase {
        NioEnvironmentParametersBase(ByteBufAllocator clientAlloc) {
            super((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, clientAlloc, NioServerSocketChannel.class, NioSocketChannel.class);
        }

        @Override
        public EventLoopGroup newEventLoopGroup() {
            return new NioEventLoopGroup(1);
        }
    }

    private static abstract class EnvironmentParametersBase
    implements EnvironmentParameters {
        private final ByteBufAllocator clientAlloc;
        private final ByteBufAllocator serverAlloc;
        private final Class<? extends Channel> clientChannelClass;
        private final Class<? extends ServerChannel> serverChannelClass;
        private final Http2RemoteFlowController remoteFlowController;
        private final Http2LocalFlowController localFlowController;
        private SocketAddress address;

        EnvironmentParametersBase(ByteBufAllocator serverAlloc, ByteBufAllocator clientAlloc, Class<? extends ServerChannel> serverChannelClass, Class<? extends Channel> clientChannelClass) {
            this(serverAlloc, clientAlloc, serverChannelClass, clientChannelClass, NoopHttp2RemoteFlowController.INSTANCE, NoopHttp2LocalFlowController.INSTANCE);
        }

        EnvironmentParametersBase(ByteBufAllocator serverAlloc, ByteBufAllocator clientAlloc, Class<? extends ServerChannel> serverChannelClass, Class<? extends Channel> clientChannelClass, Http2RemoteFlowController remoteFlowController, Http2LocalFlowController localFlowController) {
            this.serverAlloc = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)serverAlloc, (String)"serverAlloc");
            this.clientAlloc = (ByteBufAllocator)ObjectUtil.checkNotNull((Object)clientAlloc, (String)"clientAlloc");
            this.clientChannelClass = (Class)ObjectUtil.checkNotNull(clientChannelClass, (String)"clientChannelClass");
            this.serverChannelClass = (Class)ObjectUtil.checkNotNull(serverChannelClass, (String)"serverChannelClass");
            this.remoteFlowController = remoteFlowController;
            this.localFlowController = localFlowController;
        }

        @Override
        public SocketAddress address() {
            if (this.address == null) {
                return new InetSocketAddress(0);
            }
            return this.address;
        }

        @Override
        public void address(SocketAddress address) {
            this.address = address;
        }

        @Override
        public Class<? extends ServerChannel> serverChannelClass() {
            return this.serverChannelClass;
        }

        @Override
        public Class<? extends Channel> clientChannelClass() {
            return this.clientChannelClass;
        }

        @Override
        public ByteBufAllocator clientAllocator() {
            return this.clientAlloc;
        }

        @Override
        public ByteBufAllocator serverAllocator() {
            return this.serverAlloc;
        }

        @Override
        public Http2RemoteFlowController remoteFlowController() {
            return this.remoteFlowController;
        }

        @Override
        public Http2LocalFlowController localFlowController() {
            return this.localFlowController;
        }
    }

    private static interface EnvironmentParameters {
        public EventLoopGroup newEventLoopGroup();

        public Class<? extends ServerChannel> serverChannelClass();

        public Class<? extends Channel> clientChannelClass();

        public ByteBufAllocator clientAllocator();

        public ByteBufAllocator serverAllocator();

        public SocketAddress address();

        public void address(SocketAddress var1);

        public Http2RemoteFlowController remoteFlowController();

        public Http2LocalFlowController localFlowController();
    }

    private static interface Environment {
        public EventLoop eventLoop();

        public ChannelHandlerContext context();

        public Http2FrameWriter writer();

        public void teardown() throws Exception;
    }

    private static final class BenchmarkTestPayload {
        private final ByteBuf data;
        private final Http2Headers headers;

        public BenchmarkTestPayload(ByteBuf data, Http2Headers headers) {
            this.data = data;
            this.headers = headers;
        }

        public ByteBuf data() {
            return this.data;
        }

        public Http2Headers headers() {
            return this.headers;
        }

        public void release() {
            this.data.release();
        }
    }

    public static enum DataPayloadType {
        SMALL,
        MEDIUM,
        LARGE,
        JUMBO;

    }

    public static enum EnvironmentType {
        EMBEDDED_POOLED(Http2FrameWriterBenchmark.access$000()),
        EMBEDDED_UNPOOLED(Http2FrameWriterBenchmark.access$100()),
        NIO_POOLED(Http2FrameWriterBenchmark.access$000()),
        NIO_UNPOOLED(Http2FrameWriterBenchmark.access$100()),
        EPOLL_POOLED(Http2FrameWriterBenchmark.access$200()),
        EPOLL_UNPOOLED(Http2FrameWriterBenchmark.access$300()),
        OIO_POOLED(Http2FrameWriterBenchmark.access$400()),
        OIO_UNPOOLED(Http2FrameWriterBenchmark.access$500());

        private final EnvironmentParameters params;

        private EnvironmentType(EnvironmentParameters params) {
            this.params = params;
        }

        public EnvironmentParameters params() {
            return this.params;
        }
    }
}

