/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.internal;

import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.internal.PlatformDependent;
import java.util.Arrays;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.BenchmarkMode;
import org.openjdk.jmh.annotations.Level;
import org.openjdk.jmh.annotations.Mode;
import org.openjdk.jmh.annotations.Param;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.Threads;

@Threads(value=1)
@State(value=Scope.Benchmark)
public class PlatformDependentBenchmark
extends AbstractMicrobenchmark {
    @Param(value={"10", "50", "100", "1000", "10000", "100000"})
    private int size;
    private byte[] bytes1;
    private byte[] bytes2;

    @Setup(value=Level.Trial)
    public void setup() {
        this.bytes1 = new byte[this.size];
        this.bytes2 = new byte[this.size];
        for (int i = 0; i < this.size; ++i) {
            this.bytes1[i] = this.bytes2[i] = (byte)i;
        }
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    public boolean unsafeBytesEqual() {
        return PlatformDependent.equals((byte[])this.bytes1, (int)0, (int)this.bytes1.length, (byte[])this.bytes2, (int)0, (int)this.bytes2.length);
    }

    @Benchmark
    @BenchmarkMode(value={Mode.Throughput})
    public boolean arraysBytesEqual() {
        return Arrays.equals(this.bytes1, this.bytes2);
    }
}

