/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.util;

import io.netty.microbench.util.AbstractMicrobenchmarkBase;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.SystemPropertyUtil;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.openjdk.jmh.annotations.Fork;
import org.openjdk.jmh.runner.options.ChainedOptionsBuilder;

@Fork(value=2)
public class AbstractMicrobenchmark
extends AbstractMicrobenchmarkBase {
    protected static final int DEFAULT_FORKS = 2;
    protected static final String[] JVM_ARGS;

    @Override
    protected String[] jvmArgs() {
        return JVM_ARGS;
    }

    @Override
    protected ChainedOptionsBuilder newOptionsBuilder() throws Exception {
        ChainedOptionsBuilder runnerOptions = super.newOptionsBuilder();
        if (this.getForks() > 0) {
            runnerOptions.forks(this.getForks());
        }
        return runnerOptions;
    }

    protected int getForks() {
        return SystemPropertyUtil.getInt((String)"forks", (int)-1);
    }

    static {
        String[] customArgs = new String[]{"-Xms768m", "-Xmx768m", "-XX:MaxDirectMemorySize=768m", "-Dharness.executor=CUSTOM", "-Dharness.executor.class=AbstractMicrobenchmark$HarnessExecutor"};
        JVM_ARGS = new String[BASE_JVM_ARGS.length + customArgs.length];
        System.arraycopy(BASE_JVM_ARGS, 0, JVM_ARGS, 0, BASE_JVM_ARGS.length);
        System.arraycopy(customArgs, 0, JVM_ARGS, BASE_JVM_ARGS.length, customArgs.length);
    }

    public static final class HarnessExecutor
    extends ThreadPoolExecutor {
        public HarnessExecutor(int maxThreads, String prefix) {
            super(0, maxThreads, 1L, TimeUnit.DAYS, new SynchronousQueue<Runnable>(), (ThreadFactory)new DefaultThreadFactory(prefix));
            System.out.println("Using harness executor");
        }
    }
}

