/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.buffer;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.SlicedByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.microbench.util.AbstractMicrobenchmark;
import org.openjdk.jmh.annotations.Benchmark;
import org.openjdk.jmh.annotations.Measurement;
import org.openjdk.jmh.annotations.Scope;
import org.openjdk.jmh.annotations.Setup;
import org.openjdk.jmh.annotations.State;
import org.openjdk.jmh.annotations.TearDown;
import org.openjdk.jmh.annotations.Warmup;

@State(value=Scope.Benchmark)
@Warmup(iterations=10)
@Measurement(iterations=25)
public class SlicedByteBufBenchmark
extends AbstractMicrobenchmark {
    private ByteBuf slicedByteBuf;
    private ByteBuf slicedAbstractByteBuf;
    private String ascii;

    @Setup
    public void setup() {
        ByteBuf buffer = Unpooled.buffer((int)512).retain();
        this.slicedByteBuf = new SlicedByteBuf(buffer, 0, 256);
        this.slicedAbstractByteBuf = buffer.slice(0, 256);
        if (this.slicedByteBuf.getClass() == this.slicedAbstractByteBuf.getClass()) {
            throw new IllegalStateException();
        }
        StringBuilder asciiSequence = new StringBuilder(128);
        for (int i = 0; i < 128; ++i) {
            asciiSequence.append('a');
        }
        this.ascii = asciiSequence.toString();
    }

    @TearDown
    public void tearDown() {
        this.slicedByteBuf.release();
        this.slicedAbstractByteBuf.release();
    }

    @Benchmark
    public void writeAsciiStringSlice() {
        this.slicedByteBuf.resetWriterIndex();
        ByteBufUtil.writeAscii((ByteBuf)this.slicedByteBuf, (CharSequence)this.ascii);
    }

    @Benchmark
    public void writeAsciiStringSliceAbstract() {
        this.slicedAbstractByteBuf.resetWriterIndex();
        ByteBufUtil.writeAscii((ByteBuf)this.slicedAbstractByteBuf, (CharSequence)this.ascii);
    }
}

