/*
 * Decompiled with CFR 0.152.
 */
package io.netty.microbench.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.PooledByteBufAllocator;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.microbench.util.AbstractMicrobenchmark;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.nio.ByteBuffer;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import org.openjdk.jmh.annotations.Param;

public class AbstractSslEngineBenchmark
extends AbstractMicrobenchmark {
    private static final String PROTOCOL_TLS_V1_2 = "TLSv1.2";
    @Param
    public SslEngineProvider sslProvider;
    @Param
    public BufferType bufferType;
    @Param(value={"TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA256", "TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256"})
    public String cipher;
    protected SSLEngine clientEngine;
    protected SSLEngine serverEngine;
    private ByteBuffer cTOs;
    private ByteBuffer sTOc;
    private ByteBuffer serverAppReadBuffer;
    private ByteBuffer clientAppReadBuffer;
    private ByteBuffer empty;

    protected final void initEngines() {
        this.clientEngine = this.newClientEngine();
        this.serverEngine = this.newServerEngine();
    }

    protected final void destroyEngines() {
        ReferenceCountUtil.release((Object)this.clientEngine);
        ReferenceCountUtil.release((Object)this.serverEngine);
    }

    protected final void initHandshakeBuffers() {
        this.cTOs = this.allocateBuffer(this.clientEngine.getSession().getPacketBufferSize());
        this.sTOc = this.allocateBuffer(this.serverEngine.getSession().getPacketBufferSize());
        this.serverAppReadBuffer = this.allocateBuffer(this.serverEngine.getSession().getApplicationBufferSize());
        this.clientAppReadBuffer = this.allocateBuffer(this.clientEngine.getSession().getApplicationBufferSize());
        this.empty = this.allocateBuffer(0);
    }

    protected final void destroyHandshakeBuffers() {
        this.freeBuffer(this.cTOs);
        this.freeBuffer(this.sTOc);
        this.freeBuffer(this.serverAppReadBuffer);
        this.freeBuffer(this.clientAppReadBuffer);
        this.freeBuffer(this.empty);
    }

    protected final boolean doHandshake() throws SSLException {
        this.clientEngine.beginHandshake();
        this.serverEngine.beginHandshake();
        SSLEngineResult clientResult = null;
        SSLEngineResult serverResult = null;
        boolean clientHandshakeFinished = false;
        boolean serverHandshakeFinished = false;
        do {
            int cTOsPos = this.cTOs.position();
            int sTOcPos = this.sTOc.position();
            if (!clientHandshakeFinished) {
                clientResult = this.clientEngine.wrap(this.empty, this.cTOs);
                AbstractSslEngineBenchmark.runDelegatedTasks(clientResult, this.clientEngine);
                assert (this.empty.remaining() == clientResult.bytesConsumed());
                assert (this.cTOs.position() - cTOsPos == clientResult.bytesProduced());
                clientHandshakeFinished = AbstractSslEngineBenchmark.isHandshakeFinished(clientResult);
            }
            if (!serverHandshakeFinished) {
                serverResult = this.serverEngine.wrap(this.empty, this.sTOc);
                AbstractSslEngineBenchmark.runDelegatedTasks(serverResult, this.serverEngine);
                assert (this.empty.remaining() == serverResult.bytesConsumed());
                assert (this.sTOc.position() - sTOcPos == serverResult.bytesProduced());
                serverHandshakeFinished = AbstractSslEngineBenchmark.isHandshakeFinished(serverResult);
            }
            this.cTOs.flip();
            this.sTOc.flip();
            cTOsPos = this.cTOs.position();
            sTOcPos = this.sTOc.position();
            if (!clientHandshakeFinished) {
                int clientAppReadBufferPos = this.clientAppReadBuffer.position();
                clientResult = this.clientEngine.unwrap(this.sTOc, this.clientAppReadBuffer);
                AbstractSslEngineBenchmark.runDelegatedTasks(clientResult, this.clientEngine);
                assert (this.sTOc.position() - sTOcPos == clientResult.bytesConsumed());
                assert (this.clientAppReadBuffer.position() - clientAppReadBufferPos == clientResult.bytesProduced());
                clientHandshakeFinished = AbstractSslEngineBenchmark.isHandshakeFinished(clientResult);
            } else assert (!this.sTOc.hasRemaining());
            if (!serverHandshakeFinished) {
                int serverAppReadBufferPos = this.serverAppReadBuffer.position();
                serverResult = this.serverEngine.unwrap(this.cTOs, this.serverAppReadBuffer);
                AbstractSslEngineBenchmark.runDelegatedTasks(serverResult, this.serverEngine);
                assert (this.cTOs.position() - cTOsPos == serverResult.bytesConsumed());
                assert (this.serverAppReadBuffer.position() - serverAppReadBufferPos == serverResult.bytesProduced());
                serverHandshakeFinished = AbstractSslEngineBenchmark.isHandshakeFinished(serverResult);
            } else assert (!this.cTOs.hasRemaining());
            this.sTOc.compact();
            this.cTOs.compact();
        } while (!clientHandshakeFinished || !serverHandshakeFinished);
        return clientResult.getStatus() == SSLEngineResult.Status.OK && serverResult.getStatus() == SSLEngineResult.Status.OK;
    }

    protected final SSLEngine newClientEngine() {
        return this.sslProvider.newClientEngine(this.cipher);
    }

    protected final SSLEngine newServerEngine() {
        return this.sslProvider.newServerEngine(this.cipher);
    }

    protected static boolean checkSslEngineResult(SSLEngineResult result, ByteBuffer src, ByteBuffer dst) {
        return result.getStatus() == SSLEngineResult.Status.OK && !src.hasRemaining() && dst.hasRemaining();
    }

    protected final ByteBuffer allocateBuffer(int size) {
        return this.bufferType.newBuffer(size);
    }

    protected final void freeBuffer(ByteBuffer buffer) {
        this.bufferType.freeBuffer(buffer);
    }

    private static boolean isHandshakeFinished(SSLEngineResult result) {
        return result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.FINISHED;
    }

    private static void runDelegatedTasks(SSLEngineResult result, SSLEngine engine) {
        if (result.getHandshakeStatus() == SSLEngineResult.HandshakeStatus.NEED_TASK) {
            Runnable task;
            while ((task = engine.getDelegatedTask()) != null) {
                task.run();
            }
        }
    }

    public static enum BufferType {
        HEAP{

            @Override
            ByteBuffer newBuffer(int size) {
                return ByteBuffer.allocate(size);
            }
        }
        ,
        DIRECT{

            @Override
            ByteBuffer newBuffer(int size) {
                return ByteBuffer.allocateDirect(size);
            }

            @Override
            void freeBuffer(ByteBuffer buffer) {
                PlatformDependent.freeDirectBuffer((ByteBuffer)buffer);
            }
        };


        abstract ByteBuffer newBuffer(int var1);

        void freeBuffer(ByteBuffer buffer) {
        }
    }

    public static enum SslEngineProvider {
        JDK{

            @Override
            SslProvider sslProvider() {
                return SslProvider.JDK;
            }
        }
        ,
        OPENSSL{

            @Override
            SslProvider sslProvider() {
                return SslProvider.OPENSSL;
            }
        }
        ,
        OPENSSL_REFCNT{

            @Override
            SslProvider sslProvider() {
                return SslProvider.OPENSSL_REFCNT;
            }
        };

        private final SslContext clientContext = this.newClientContext();
        private final SslContext serverContext = this.newServerContext();

        private SslContext newClientContext() {
            try {
                return SslContextBuilder.forClient().sslProvider(this.sslProvider()).trustManager(InsecureTrustManagerFactory.INSTANCE).build();
            }
            catch (SSLException e) {
                throw new IllegalStateException(e);
            }
        }

        private SslContext newServerContext() {
            try {
                File keyFile = new File(((Object)((Object)this)).getClass().getResource("test_unencrypted.pem").getFile());
                File crtFile = new File(((Object)((Object)this)).getClass().getResource("test.crt").getFile());
                return SslContextBuilder.forServer((File)crtFile, (File)keyFile).sslProvider(this.sslProvider()).build();
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        }

        SSLEngine newClientEngine(String cipher) {
            return SslEngineProvider.configureEngine(this.clientContext.newEngine((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), cipher);
        }

        SSLEngine newServerEngine(String cipher) {
            return SslEngineProvider.configureEngine(this.serverContext.newEngine((ByteBufAllocator)PooledByteBufAllocator.DEFAULT), cipher);
        }

        abstract SslProvider sslProvider();

        static SSLEngine configureEngine(SSLEngine engine, String cipher) {
            engine.setEnabledProtocols(new String[]{AbstractSslEngineBenchmark.PROTOCOL_TLS_V1_2});
            engine.setEnabledCipherSuites(new String[]{cipher});
            return engine;
        }
    }
}

