/*
 * Decompiled with CFR 0.152.
 */
package io.netty.monitor.yammer;

import com.yammer.metrics.Metrics;
import com.yammer.metrics.core.Counter;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Histogram;
import com.yammer.metrics.core.Meter;
import com.yammer.metrics.core.MetricsRegistry;
import io.netty.monitor.CounterMonitor;
import io.netty.monitor.EventRateMonitor;
import io.netty.monitor.MonitorName;
import io.netty.monitor.MonitorRegistry;
import io.netty.monitor.ValueDistributionMonitor;
import io.netty.monitor.ValueMonitor;
import io.netty.monitor.yammer.Utils;
import io.netty.monitor.yammer.YammerCounterMonitor;
import io.netty.monitor.yammer.YammerEventRateMonitor;
import io.netty.monitor.yammer.YammerValueDistributionMonitor;
import java.util.concurrent.TimeUnit;

public final class YammerMonitorRegistry
implements MonitorRegistry {
    private final MetricsRegistry delegate;

    public YammerMonitorRegistry() {
        this(Metrics.defaultRegistry());
    }

    public YammerMonitorRegistry(MetricsRegistry delegate) {
        if (delegate == null) {
            throw new NullPointerException("delegate");
        }
        this.delegate = delegate;
    }

    public ValueDistributionMonitor newValueDistributionMonitor(MonitorName monitorName) {
        Histogram histogram = this.delegate.newHistogram(Utils.toMetricName(monitorName), true);
        return new YammerValueDistributionMonitor(histogram);
    }

    public EventRateMonitor newEventRateMonitor(MonitorName monitorName, TimeUnit rateUnit) {
        Meter meter = this.delegate.newMeter(Utils.toMetricName(monitorName), monitorName.getName(), rateUnit);
        return new YammerEventRateMonitor(meter);
    }

    public <T> ValueMonitor<T> registerValueMonitor(MonitorName monitorName, final ValueMonitor<T> valueMonitor) {
        this.delegate.newGauge(Utils.toMetricName(monitorName), new Gauge<T>(){

            public T value() {
                return valueMonitor.currentValue();
            }
        });
        return valueMonitor;
    }

    public CounterMonitor newCounterMonitor(MonitorName monitorName) {
        Counter counter = this.delegate.newCounter(Utils.toMetricName(monitorName));
        return new YammerCounterMonitor(counter);
    }

    public String toString() {
        return "YammerMonitorRegistry(delegate=" + this.delegate + ")";
    }
}

