/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.stream;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.stream.ChunkedFile;
import io.netty.handler.stream.ChunkedInput;
import io.netty.handler.stream.ChunkedNioFile;
import io.netty.handler.stream.ChunkedNioStream;
import io.netty.handler.stream.ChunkedStream;
import io.netty.handler.stream.ChunkedWriteHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.PlatformDependent;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.nio.channels.Channels;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.nio.charset.Charset;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.junit.Assert;
import org.junit.Test;

public class ChunkedWriteHandlerTest {
    private static final byte[] BYTES = new byte[65536];
    private static final File TMP;

    @Test
    public void testChunkedStream() {
        ChunkedWriteHandlerTest.check(new ChunkedStream((InputStream)new ByteArrayInputStream(BYTES)));
        ChunkedWriteHandlerTest.check(new ChunkedStream((InputStream)new ByteArrayInputStream(BYTES)), new ChunkedStream((InputStream)new ByteArrayInputStream(BYTES)), new ChunkedStream((InputStream)new ByteArrayInputStream(BYTES)));
    }

    @Test
    public void testChunkedNioStream() {
        ChunkedWriteHandlerTest.check(new ChunkedNioStream(Channels.newChannel(new ByteArrayInputStream(BYTES))));
        ChunkedWriteHandlerTest.check(new ChunkedNioStream(Channels.newChannel(new ByteArrayInputStream(BYTES))), new ChunkedNioStream(Channels.newChannel(new ByteArrayInputStream(BYTES))), new ChunkedNioStream(Channels.newChannel(new ByteArrayInputStream(BYTES))));
    }

    @Test
    public void testChunkedFile() throws IOException {
        ChunkedWriteHandlerTest.check(new ChunkedFile(TMP));
        ChunkedWriteHandlerTest.check(new ChunkedFile(TMP), new ChunkedFile(TMP), new ChunkedFile(TMP));
    }

    @Test
    public void testChunkedNioFile() throws IOException {
        ChunkedWriteHandlerTest.check(new ChunkedNioFile(TMP));
        ChunkedWriteHandlerTest.check(new ChunkedNioFile(TMP), new ChunkedNioFile(TMP), new ChunkedNioFile(TMP));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testChunkedNioFileLeftPositionUnchanged() throws IOException {
        AbstractInterruptibleChannel in = null;
        long expectedPosition = 10L;
        try {
            in = new RandomAccessFile(TMP, "r").getChannel();
            ((FileChannel)in).position(10L);
            ChunkedWriteHandlerTest.check(new ChunkedNioFile((FileChannel)in){

                public void close() throws Exception {
                }
            });
            Assert.assertTrue((boolean)in.isOpen());
            Assert.assertEquals((long)10L, (long)((FileChannel)in).position());
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
    }

    @Test(expected=ClosedChannelException.class)
    public void testChunkedNioFileFailOnClosedFileChannel() throws IOException {
        FileChannel in = new RandomAccessFile(TMP, "r").getChannel();
        in.close();
        ChunkedWriteHandlerTest.check(new ChunkedNioFile(in){

            public void close() throws Exception {
            }
        });
        Assert.fail();
    }

    @Test
    public void testUnchunkedData() throws IOException {
        ChunkedWriteHandlerTest.check(Unpooled.wrappedBuffer((byte[])BYTES));
        ChunkedWriteHandlerTest.check(Unpooled.wrappedBuffer((byte[])BYTES), Unpooled.wrappedBuffer((byte[])BYTES), Unpooled.wrappedBuffer((byte[])BYTES));
    }

    @Test
    public void testListenerNotifiedWhenIsEnd() {
        ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"Test", (Charset)CharsetUtil.ISO_8859_1);
        ChunkedInput<ByteBuf> input = new ChunkedInput<ByteBuf>(){
            private boolean done;
            private final ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"Test", (Charset)CharsetUtil.ISO_8859_1);

            public boolean isEndOfInput() throws Exception {
                return this.done;
            }

            public void close() throws Exception {
                this.buffer.release();
            }

            @Deprecated
            public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
                return this.readChunk(ctx.alloc());
            }

            public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
                if (this.done) {
                    return null;
                }
                this.done = true;
                return this.buffer.retainedDuplicate();
            }

            public long length() {
                return -1L;
            }

            public long progress() {
                return 1L;
            }
        };
        final AtomicBoolean listenerNotified = new AtomicBoolean(false);
        ChannelFutureListener listener = new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) throws Exception {
                listenerNotified.set(true);
            }
        };
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChunkedWriteHandler()});
        ch.writeAndFlush((Object)input).addListener((GenericFutureListener)listener).syncUninterruptibly();
        Assert.assertTrue((boolean)ch.finish());
        Assert.assertTrue((boolean)listenerNotified.get());
        ByteBuf buffer2 = (ByteBuf)ch.readOutbound();
        Assert.assertEquals((Object)buffer, (Object)buffer2);
        Assert.assertNull((Object)ch.readOutbound());
        buffer.release();
        buffer2.release();
    }

    @Test
    public void testChunkedMessageInput() {
        ChunkedInput<Object> input = new ChunkedInput<Object>(){
            private boolean done;

            public boolean isEndOfInput() throws Exception {
                return this.done;
            }

            public void close() throws Exception {
            }

            @Deprecated
            public Object readChunk(ChannelHandlerContext ctx) throws Exception {
                return this.readChunk(ctx.alloc());
            }

            public Object readChunk(ByteBufAllocator ctx) throws Exception {
                if (this.done) {
                    return false;
                }
                this.done = true;
                return 0;
            }

            public long length() {
                return -1L;
            }

            public long progress() {
                return 1L;
            }
        };
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChunkedWriteHandler()});
        ch.writeAndFlush((Object)input).syncUninterruptibly();
        Assert.assertTrue((boolean)ch.finish());
        Assert.assertEquals((Object)0, (Object)ch.readOutbound());
        Assert.assertNull((Object)ch.readOutbound());
    }

    @Test
    public void testWriteFailureChunkedStream() throws IOException {
        ChunkedWriteHandlerTest.checkFirstFailed(new ChunkedStream((InputStream)new ByteArrayInputStream(BYTES)));
    }

    @Test
    public void testWriteFailureChunkedNioStream() throws IOException {
        ChunkedWriteHandlerTest.checkFirstFailed(new ChunkedNioStream(Channels.newChannel(new ByteArrayInputStream(BYTES))));
    }

    @Test
    public void testWriteFailureChunkedFile() throws IOException {
        ChunkedWriteHandlerTest.checkFirstFailed(new ChunkedFile(TMP));
    }

    @Test
    public void testWriteFailureChunkedNioFile() throws IOException {
        ChunkedWriteHandlerTest.checkFirstFailed(new ChunkedNioFile(TMP));
    }

    @Test
    public void testWriteFailureUnchunkedData() throws IOException {
        ChunkedWriteHandlerTest.checkFirstFailed(Unpooled.wrappedBuffer((byte[])BYTES));
    }

    @Test
    public void testSkipAfterFailedChunkedStream() throws IOException {
        ChunkedWriteHandlerTest.checkSkipFailed(new ChunkedStream((InputStream)new ByteArrayInputStream(BYTES)), new ChunkedStream((InputStream)new ByteArrayInputStream(BYTES)));
    }

    @Test
    public void testSkipAfterFailedChunkedNioStream() throws IOException {
        ChunkedWriteHandlerTest.checkSkipFailed(new ChunkedNioStream(Channels.newChannel(new ByteArrayInputStream(BYTES))), new ChunkedNioStream(Channels.newChannel(new ByteArrayInputStream(BYTES))));
    }

    @Test
    public void testSkipAfterFailedChunkedFile() throws IOException {
        ChunkedWriteHandlerTest.checkSkipFailed(new ChunkedFile(TMP), new ChunkedFile(TMP));
    }

    @Test
    public void testSkipAfterFailedChunkedNioFile() throws IOException {
        ChunkedWriteHandlerTest.checkSkipFailed(new ChunkedNioFile(TMP), new ChunkedFile(TMP));
    }

    @Test
    public void testFailureWhenLastChunkFailed() throws IOException {
        ByteBuf buffer;
        ChannelOutboundHandlerAdapter failLast = new ChannelOutboundHandlerAdapter(){
            private int passedWrites;

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (++this.passedWrites < 4) {
                    ctx.write(msg, promise);
                } else {
                    ReferenceCountUtil.release((Object)msg);
                    promise.tryFailure((Throwable)new RuntimeException());
                }
            }
        };
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{failLast, new ChunkedWriteHandler()});
        ChannelFuture r = ch.writeAndFlush((Object)new ChunkedFile(TMP, 16384));
        Assert.assertTrue((boolean)ch.finish());
        Assert.assertFalse((boolean)r.isSuccess());
        Assert.assertTrue((boolean)(r.cause() instanceof RuntimeException));
        int read = 0;
        while ((buffer = (ByteBuf)ch.readOutbound()) != null) {
            read += buffer.readableBytes();
            buffer.release();
        }
        Assert.assertEquals((long)49152L, (long)read);
    }

    @Test
    public void testDiscardPendingWritesOnInactive() throws IOException {
        final AtomicBoolean closeWasCalled = new AtomicBoolean(false);
        ChunkedInput<ByteBuf> notifiableInput = new ChunkedInput<ByteBuf>(){
            private boolean done;
            private final ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"Test", (Charset)CharsetUtil.ISO_8859_1);

            public boolean isEndOfInput() throws Exception {
                return this.done;
            }

            public void close() throws Exception {
                this.buffer.release();
                closeWasCalled.set(true);
            }

            @Deprecated
            public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
                return this.readChunk(ctx.alloc());
            }

            public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
                if (this.done) {
                    return null;
                }
                this.done = true;
                return this.buffer.retainedDuplicate();
            }

            public long length() {
                return -1L;
            }

            public long progress() {
                return 1L;
            }
        };
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChunkedWriteHandler()});
        ChannelFuture r1 = ch.write((Object)new ChunkedFile(TMP));
        ChannelFuture r2 = ch.write((Object)new ChunkedNioFile(TMP));
        ch.write((Object)notifiableInput);
        Assert.assertFalse((boolean)ch.finish());
        Assert.assertFalse((boolean)r1.isSuccess());
        Assert.assertFalse((boolean)r2.isSuccess());
        Assert.assertTrue((boolean)closeWasCalled.get());
    }

    @Test
    public void testStopConsumingChunksWhenFailed() {
        final ByteBuf buffer = Unpooled.copiedBuffer((CharSequence)"Test", (Charset)CharsetUtil.ISO_8859_1);
        final AtomicInteger chunks = new AtomicInteger(0);
        ChunkedInput<ByteBuf> nonClosableInput = new ChunkedInput<ByteBuf>(){

            public boolean isEndOfInput() throws Exception {
                return chunks.get() >= 5;
            }

            public void close() throws Exception {
            }

            @Deprecated
            public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
                return this.readChunk(ctx.alloc());
            }

            public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
                chunks.incrementAndGet();
                return buffer.retainedDuplicate();
            }

            public long length() {
                return -1L;
            }

            public long progress() {
                return 1L;
            }
        };
        ChannelOutboundHandlerAdapter noOpWrites = new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                ReferenceCountUtil.release((Object)msg);
                promise.tryFailure((Throwable)new RuntimeException());
            }
        };
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{noOpWrites, new ChunkedWriteHandler()});
        ch.writeAndFlush((Object)nonClosableInput).awaitUninterruptibly();
        Assert.assertFalse((boolean)ch.finish());
        buffer.release();
        Assert.assertEquals((long)1L, (long)chunks.get());
    }

    @Test
    public void testCloseSuccessfulChunkedInput() {
        int chunks = 10;
        TestChunkedInput input = new TestChunkedInput(chunks);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChunkedWriteHandler()});
        Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{input}));
        for (int i = 0; i < chunks; ++i) {
            ByteBuf buf = (ByteBuf)ch.readOutbound();
            Assert.assertEquals((long)i, (long)buf.readInt());
            buf.release();
        }
        Assert.assertTrue((boolean)input.isClosed());
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testCloseFailedChunkedInput() {
        Exception error = new Exception("Unable to produce a chunk");
        ThrowingChunkedInput input = new ThrowingChunkedInput(error);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChunkedWriteHandler()});
        try {
            ch.writeOutbound(new Object[]{input});
            Assert.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Assert.assertEquals((Object)error, (Object)e);
        }
        Assert.assertTrue((boolean)input.isClosed());
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testWriteListenerInvokedAfterSuccessfulChunkedInputClosed() throws Exception {
        final TestChunkedInput input = new TestChunkedInput(2);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChunkedWriteHandler()});
        final AtomicBoolean inputClosedWhenListenerInvoked = new AtomicBoolean();
        final CountDownLatch listenerInvoked = new CountDownLatch(1);
        ChannelFuture writeFuture = ch.write((Object)input);
        writeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                inputClosedWhenListenerInvoked.set(input.isClosed());
                listenerInvoked.countDown();
            }
        });
        ch.flush();
        Assert.assertTrue((boolean)listenerInvoked.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)writeFuture.isSuccess());
        Assert.assertTrue((boolean)inputClosedWhenListenerInvoked.get());
        Assert.assertTrue((boolean)ch.finishAndReleaseAll());
    }

    @Test
    public void testWriteListenerInvokedAfterFailedChunkedInputClosed() throws Exception {
        final ThrowingChunkedInput input = new ThrowingChunkedInput(new RuntimeException());
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChunkedWriteHandler()});
        final AtomicBoolean inputClosedWhenListenerInvoked = new AtomicBoolean();
        final CountDownLatch listenerInvoked = new CountDownLatch(1);
        ChannelFuture writeFuture = ch.write((Object)input);
        writeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                inputClosedWhenListenerInvoked.set(input.isClosed());
                listenerInvoked.countDown();
            }
        });
        ch.flush();
        Assert.assertTrue((boolean)listenerInvoked.await(10L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)writeFuture.isSuccess());
        Assert.assertTrue((boolean)inputClosedWhenListenerInvoked.get());
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testWriteListenerInvokedAfterChannelClosedAndInputFullyConsumed() throws Exception {
        final TestChunkedInput input = new TestChunkedInput(0);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChunkedWriteHandler()});
        final AtomicBoolean inputClosedWhenListenerInvoked = new AtomicBoolean();
        final CountDownLatch listenerInvoked = new CountDownLatch(1);
        ChannelFuture writeFuture = ch.write((Object)input);
        writeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                inputClosedWhenListenerInvoked.set(input.isClosed());
                listenerInvoked.countDown();
            }
        });
        ch.close();
        ch.flush();
        Assert.assertTrue((boolean)listenerInvoked.await(10L, TimeUnit.SECONDS));
        Assert.assertTrue((boolean)writeFuture.isSuccess());
        Assert.assertTrue((boolean)inputClosedWhenListenerInvoked.get());
        Assert.assertFalse((boolean)ch.finish());
    }

    @Test
    public void testWriteListenerInvokedAfterChannelClosedAndInputNotFullyConsumed() throws Exception {
        final TestChunkedInput input = new TestChunkedInput(42);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChunkedWriteHandler()});
        final AtomicBoolean inputClosedWhenListenerInvoked = new AtomicBoolean();
        final CountDownLatch listenerInvoked = new CountDownLatch(1);
        ChannelFuture writeFuture = ch.write((Object)input);
        writeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture future) {
                inputClosedWhenListenerInvoked.set(input.isClosed());
                listenerInvoked.countDown();
            }
        });
        ch.close();
        ch.flush();
        Assert.assertTrue((boolean)listenerInvoked.await(10L, TimeUnit.SECONDS));
        Assert.assertFalse((boolean)writeFuture.isSuccess());
        Assert.assertTrue((boolean)inputClosedWhenListenerInvoked.get());
        Assert.assertFalse((boolean)ch.finish());
    }

    private static void check(Object ... inputs) {
        ByteBuf buffer;
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChunkedWriteHandler()});
        for (Object input : inputs) {
            ch.writeOutbound(new Object[]{input});
        }
        Assert.assertTrue((boolean)ch.finish());
        int i = 0;
        int read = 0;
        while ((buffer = (ByteBuf)ch.readOutbound()) != null) {
            while (buffer.isReadable()) {
                Assert.assertEquals((long)BYTES[i++], (long)buffer.readByte());
                ++read;
                if (i != BYTES.length) continue;
                i = 0;
            }
            buffer.release();
        }
        Assert.assertEquals((long)(BYTES.length * inputs.length), (long)read);
    }

    private static void checkFirstFailed(Object input) {
        ChannelOutboundHandlerAdapter noOpWrites = new ChannelOutboundHandlerAdapter(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                ReferenceCountUtil.release((Object)msg);
                promise.tryFailure((Throwable)new RuntimeException());
            }
        };
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{noOpWrites, new ChunkedWriteHandler()});
        ChannelFuture r = ch.writeAndFlush(input);
        Assert.assertFalse((boolean)ch.finish());
        Assert.assertTrue((boolean)(r.cause() instanceof RuntimeException));
    }

    private static void checkSkipFailed(Object input1, Object input2) {
        ByteBuf buffer;
        ChannelOutboundHandlerAdapter failFirst = new ChannelOutboundHandlerAdapter(){
            private boolean alreadyFailed;

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (this.alreadyFailed) {
                    ctx.write(msg, promise);
                } else {
                    this.alreadyFailed = true;
                    ReferenceCountUtil.release((Object)msg);
                    promise.tryFailure((Throwable)new RuntimeException());
                }
            }
        };
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{failFirst, new ChunkedWriteHandler()});
        ChannelFuture r1 = ch.write(input1);
        ChannelFuture r2 = ch.writeAndFlush(input2).awaitUninterruptibly();
        Assert.assertTrue((boolean)ch.finish());
        Assert.assertTrue((boolean)(r1.cause() instanceof RuntimeException));
        Assert.assertTrue((boolean)r2.isSuccess());
        int i = 0;
        int read = 0;
        while ((buffer = (ByteBuf)ch.readOutbound()) != null) {
            while (buffer.isReadable()) {
                Assert.assertEquals((long)BYTES[i++], (long)buffer.readByte());
                ++read;
                if (i != BYTES.length) continue;
                i = 0;
            }
            buffer.release();
        }
        Assert.assertEquals((long)BYTES.length, (long)read);
    }

    static {
        for (int i = 0; i < BYTES.length; ++i) {
            ChunkedWriteHandlerTest.BYTES[i] = (byte)i;
        }
        FileOutputStream out = null;
        try {
            TMP = PlatformDependent.createTempFile((String)"netty-chunk-", (String)".tmp", null);
            TMP.deleteOnExit();
            out = new FileOutputStream(TMP);
            out.write(BYTES);
            out.flush();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (out != null) {
                try {
                    out.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static final class ThrowingChunkedInput
    implements ChunkedInput<ByteBuf> {
        private final Exception error;
        private volatile boolean closed;

        ThrowingChunkedInput(Exception error) {
            this.error = error;
        }

        public boolean isEndOfInput() {
            return false;
        }

        public void close() {
            this.closed = true;
        }

        public ByteBuf readChunk(ChannelHandlerContext ctx) throws Exception {
            return this.readChunk(ctx.alloc());
        }

        public ByteBuf readChunk(ByteBufAllocator allocator) throws Exception {
            throw this.error;
        }

        public long length() {
            return -1L;
        }

        public long progress() {
            return -1L;
        }

        boolean isClosed() {
            return this.closed;
        }
    }

    private static final class TestChunkedInput
    implements ChunkedInput<ByteBuf> {
        private final int chunksToProduce;
        private int chunksProduced;
        private volatile boolean closed;

        TestChunkedInput(int chunksToProduce) {
            this.chunksToProduce = chunksToProduce;
        }

        public boolean isEndOfInput() {
            return this.chunksProduced >= this.chunksToProduce;
        }

        public void close() {
            this.closed = true;
        }

        public ByteBuf readChunk(ChannelHandlerContext ctx) {
            return this.readChunk(ctx.alloc());
        }

        public ByteBuf readChunk(ByteBufAllocator allocator) {
            ByteBuf buf = allocator.buffer();
            buf.writeInt(this.chunksProduced);
            ++this.chunksProduced;
            return buf;
        }

        public long length() {
            return this.chunksToProduce;
        }

        public long progress() {
            return this.chunksProduced;
        }

        boolean isClosed() {
            return this.closed;
        }
    }
}

