/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.SniClientJava8TestUtil;
import io.netty.handler.ssl.SniHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.Mapping;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.net.SocketAddress;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SniClientTest {
    private final SslProvider serverProvider;
    private final SslProvider clientProvider;

    @Parameterized.Parameters(name="{index}: serverSslProvider = {0}, clientSslProvider = {1}")
    public static Collection<Object[]> parameters() {
        ArrayList<SslProvider> providers = new ArrayList<SslProvider>(Arrays.asList(SslProvider.values()));
        if (!OpenSsl.isAvailable()) {
            providers.remove(SslProvider.OPENSSL);
            providers.remove(SslProvider.OPENSSL_REFCNT);
        }
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SslProvider sp : providers) {
            for (SslProvider cp : providers) {
                params.add(new Object[]{sp, cp});
            }
        }
        return params;
    }

    public SniClientTest(SslProvider serverProvider, SslProvider clientProvider) {
        this.serverProvider = serverProvider;
        this.clientProvider = clientProvider;
    }

    @Test(timeout=30000L)
    public void testSniClient() throws Exception {
        SniClientTest.testSniClient(this.serverProvider, this.clientProvider);
    }

    @Test(timeout=30000L)
    public void testSniSNIMatcherMatchesClient() throws Exception {
        Assume.assumeTrue((PlatformDependent.javaVersion() >= 8 ? 1 : 0) != 0);
        SniClientJava8TestUtil.testSniClient(this.serverProvider, this.clientProvider, true);
    }

    @Test(timeout=30000L, expected=SSLException.class)
    public void testSniSNIMatcherDoesNotMatchClient() throws Exception {
        Assume.assumeTrue((PlatformDependent.javaVersion() >= 8 ? 1 : 0) != 0);
        SniClientJava8TestUtil.testSniClient(this.serverProvider, this.clientProvider, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testSniClient(SslProvider sslServerProvider, SslProvider sslClientProvider) throws Exception {
        Channel sc;
        SslContext sslClientContext;
        SslContext sslServerContext;
        SelfSignedCertificate cert;
        DefaultEventLoopGroup group;
        block8: {
            String sniHostName = "sni.netty.io";
            LocalAddress address = new LocalAddress("test");
            group = new DefaultEventLoopGroup(1);
            cert = new SelfSignedCertificate();
            sslServerContext = null;
            sslClientContext = null;
            sc = null;
            Channel cc = null;
            try {
                if (!(sslServerProvider != SslProvider.OPENSSL && sslServerProvider != SslProvider.OPENSSL_REFCNT || OpenSsl.useKeyManagerFactory())) {
                    sslServerContext = SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(sslServerProvider).build();
                } else {
                    KeyManagerFactory kmf = PlatformDependent.javaVersion() >= 8 ? SniClientJava8TestUtil.newSniX509KeyManagerFactory(cert, sniHostName) : SslContext.buildKeyManagerFactory((X509Certificate[])new X509Certificate[]{cert.cert()}, null, (PrivateKey)cert.key(), null, null, null);
                    sslServerContext = SslContextBuilder.forServer((KeyManagerFactory)kmf).sslProvider(sslServerProvider).build();
                }
                final SslContext finalContext = sslServerContext;
                final Promise promise = group.next().newPromise();
                ServerBootstrap sb = new ServerBootstrap();
                sc = ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) throws Exception {
                        ch.pipeline().addFirst(new ChannelHandler[]{new SniHandler((Mapping)new Mapping<String, SslContext>(){

                            public SslContext map(String input) {
                                promise.setSuccess((Object)input);
                                return finalContext;
                            }
                        })});
                    }
                }).bind((SocketAddress)address).syncUninterruptibly().channel();
                TrustManagerFactory tmf = PlatformDependent.javaVersion() >= 8 ? SniClientJava8TestUtil.newSniX509TrustmanagerFactory(sniHostName) : InsecureTrustManagerFactory.INSTANCE;
                sslClientContext = SslContextBuilder.forClient().trustManager(tmf).sslProvider(sslClientProvider).build();
                Bootstrap cb = new Bootstrap();
                SslHandler handler = new SslHandler(sslClientContext.newEngine(ByteBufAllocator.DEFAULT, sniHostName, -1));
                cc = ((Bootstrap)((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)handler)).connect((SocketAddress)address).syncUninterruptibly().channel();
                Assert.assertEquals((Object)sniHostName, (Object)promise.syncUninterruptibly().getNow());
                handler.handshakeFuture().syncUninterruptibly();
                Assert.assertNull((Object)handler.engine().getHandshakeSession());
                if (PlatformDependent.javaVersion() >= 8) {
                    SniClientJava8TestUtil.assertSSLSession(handler.engine().getUseClientMode(), handler.engine().getSession(), sniHostName);
                }
                if (cc == null) break block8;
            }
            catch (Throwable throwable) {
                if (cc != null) {
                    cc.close().syncUninterruptibly();
                }
                if (sc != null) {
                    sc.close().syncUninterruptibly();
                }
                ReferenceCountUtil.release(sslServerContext);
                ReferenceCountUtil.release(sslClientContext);
                cert.delete();
                group.shutdownGracefully();
                throw throwable;
            }
            cc.close().syncUninterruptibly();
        }
        if (sc != null) {
            sc.close().syncUninterruptibly();
        }
        ReferenceCountUtil.release((Object)sslServerContext);
        ReferenceCountUtil.release((Object)sslClientContext);
        cert.delete();
        group.shutdownGracefully();
    }
}

