/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.Java8SslTestUtils;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslContext;
import io.netty.handler.ssl.OpenSslTestUtils;
import io.netty.handler.ssl.ReferenceCountedOpenSslEngine;
import io.netty.handler.ssl.SSLEngineTest;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslProvider;
import java.util.ArrayList;
import java.util.Collection;
import javax.net.ssl.SSLEngine;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdkOpenSslEngineInteroptTest
extends SSLEngineTest {
    private final boolean useTasks;

    @Parameterized.Parameters(name="{index}: bufferType = {0}, combo = {1}, delegate = {2}, useTasks = {3}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (SSLEngineTest.BufferType type : SSLEngineTest.BufferType.values()) {
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), false, false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), false, true});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), true, false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv12(), true, true});
            if (!SslProvider.isTlsv13Supported((SslProvider)SslProvider.JDK) || !SslProvider.isTlsv13Supported((SslProvider)SslProvider.OPENSSL)) continue;
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), false, false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), false, true});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), true, false});
            params.add(new Object[]{type, SSLEngineTest.ProtocolCipherCombo.tlsv13(), true, true});
        }
        return params;
    }

    public JdkOpenSslEngineInteroptTest(SSLEngineTest.BufferType type, SSLEngineTest.ProtocolCipherCombo protocolCipherCombo, boolean delegate, boolean useTasks) {
        super(type, protocolCipherCombo, delegate);
        this.useTasks = useTasks;
    }

    @BeforeClass
    public static void checkOpenSsl() {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.OPENSSL;
    }

    @Override
    @Test
    public void testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCASucceedWithOptionalClientAuth();
    }

    @Override
    @Test
    public void testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCAFailWithOptionalClientAuth();
    }

    @Override
    @Test
    public void testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthInvalidIntermediateCAFailWithRequiredClientAuth();
    }

    @Override
    @Test
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth();
    }

    @Override
    @Test
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testMutualAuthValidClientCertChainTooLongFailRequireClientAuth();
    }

    @Override
    @Test
    public void testSessionAfterHandshakeKeyManagerFactoryMutualAuth() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionAfterHandshakeKeyManagerFactoryMutualAuth();
    }

    @Override
    @Test
    public void testSessionAfterHandshakeKeyManagerFactory() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionAfterHandshakeKeyManagerFactory();
    }

    @Override
    protected void mySetupMutualAuthServerInitSslHandler(SslHandler handler) {
        ReferenceCountedOpenSslEngine engine = (ReferenceCountedOpenSslEngine)handler.engine();
        engine.setVerify(-1, 1);
    }

    @Override
    protected boolean mySetupMutualAuthServerIsValidClientException(Throwable cause) {
        return super.mySetupMutualAuthServerIsValidClientException(cause) || JdkOpenSslEngineInteroptTest.causedBySSLException(cause);
    }

    @Override
    public void testHandshakeSession() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testHandshakeSession();
    }

    @Override
    @Test
    public void testSupportedSignatureAlgorithms() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSupportedSignatureAlgorithms();
    }

    @Override
    @Test
    public void testSessionLocalWhenNonMutualWithKeyManager() throws Exception {
        OpenSslTestUtils.checkShouldUseKeyManagerFactory();
        super.testSessionLocalWhenNonMutualWithKeyManager();
    }

    @Override
    protected SSLEngine wrapEngine(SSLEngine engine) {
        return Java8SslTestUtils.wrapSSLEngineForTesting(engine);
    }

    @Override
    protected SslContext wrapContext(SslContext context) {
        if (context instanceof OpenSslContext) {
            ((OpenSslContext)context).setUseTasks(this.useTasks);
        }
        return context;
    }
}

