/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.OpenSslEngineTest;
import io.netty.handler.ssl.ReferenceCountedOpenSslContext;
import io.netty.handler.ssl.SSLEngineTest;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.util.ReferenceCountUtil;
import javax.net.ssl.SSLEngine;
import junit.framework.TestCase;
import org.junit.Test;

public class ReferenceCountedOpenSslEngineTest
extends OpenSslEngineTest {
    public ReferenceCountedOpenSslEngineTest(SSLEngineTest.BufferType type, SSLEngineTest.ProtocolCipherCombo combo, boolean delegate, boolean useTasks) {
        super(type, combo, delegate, useTasks);
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.OPENSSL_REFCNT;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.OPENSSL_REFCNT;
    }

    @Override
    protected void cleanupClientSslContext(SslContext ctx) {
        ReferenceCountUtil.release((Object)ctx);
    }

    @Override
    protected void cleanupClientSslEngine(SSLEngine engine) {
        ReferenceCountUtil.release((Object)engine);
    }

    @Override
    protected void cleanupServerSslContext(SslContext ctx) {
        ReferenceCountUtil.release((Object)ctx);
    }

    @Override
    protected void cleanupServerSslEngine(SSLEngine engine) {
        ReferenceCountUtil.release((Object)engine);
    }

    @Test(expected=NullPointerException.class)
    public void testNotLeakOnException() throws Exception {
        this.clientSslCtx = this.wrapContext(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build());
        this.clientSslCtx.newEngine(null);
    }

    @Override
    protected SslContext wrapContext(SslContext context) {
        if (context instanceof ReferenceCountedOpenSslContext) {
            ((ReferenceCountedOpenSslContext)context).setUseTasks(this.useTasks);
        }
        return context;
    }

    @Test
    public void parentContextIsRetainedByChildEngines() throws Exception {
        SslContext clientSslCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(this.sslClientProvider()).protocols(this.protocols()).ciphers(this.ciphers()).build();
        SSLEngine engine = clientSslCtx.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        TestCase.assertEquals((int)ReferenceCountUtil.refCnt((Object)clientSslCtx), (int)2);
        this.cleanupClientSslContext(clientSslCtx);
        TestCase.assertEquals((int)ReferenceCountUtil.refCnt((Object)clientSslCtx), (int)1);
        this.cleanupClientSslEngine(engine);
        TestCase.assertEquals((int)ReferenceCountUtil.refCnt((Object)clientSslCtx), (int)0);
    }
}

