/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.pcap;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.buffer.ByteBufUtil;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.DatagramPacket;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.handler.pcap.PcapWriteHandler;
import io.netty.util.CharsetUtil;
import io.netty.util.NetUtil;
import java.io.OutputStream;
import java.net.Inet4Address;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import org.junit.Assert;
import org.junit.Test;

public class PcapWriteHandlerTest {
    @Test
    public void udpV4() throws InterruptedException {
        ByteBuf byteBuf = Unpooled.buffer();
        InetSocketAddress srvAddr = new InetSocketAddress("127.0.0.1", 62001);
        InetSocketAddress cltAddr = new InetSocketAddress("127.0.0.1", 62002);
        NioEventLoopGroup eventLoopGroup = new NioEventLoopGroup(2);
        Bootstrap server = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new SimpleChannelInboundHandler<DatagramPacket>(){

            protected void channelRead0(ChannelHandlerContext ctx, DatagramPacket msg) {
            }
        });
        ChannelFuture channelFutureServer = server.bind((SocketAddress)srvAddr).sync();
        Assert.assertTrue((boolean)channelFutureServer.isSuccess());
        Bootstrap client = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)eventLoopGroup)).channel(NioDatagramChannel.class)).handler((ChannelHandler)new PcapWriteHandler((OutputStream)new ByteBufOutputStream(byteBuf)));
        ChannelFuture channelFutureClient = client.connect((SocketAddress)srvAddr, (SocketAddress)cltAddr).sync();
        Assert.assertTrue((boolean)channelFutureClient.isSuccess());
        Assert.assertTrue((boolean)channelFutureClient.channel().writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])"Meow".getBytes())).sync().isSuccess());
        Assert.assertTrue((boolean)eventLoopGroup.shutdownGracefully().sync().isSuccess());
        Assert.assertEquals((long)-1582119980L, (long)byteBuf.readInt());
        Assert.assertEquals((long)2L, (long)byteBuf.readShort());
        Assert.assertEquals((long)4L, (long)byteBuf.readShort());
        Assert.assertEquals((long)0L, (long)byteBuf.readInt());
        Assert.assertEquals((long)0L, (long)byteBuf.readInt());
        Assert.assertEquals((long)65535L, (long)byteBuf.readInt());
        Assert.assertEquals((long)1L, (long)byteBuf.readInt());
        byteBuf.readInt();
        byteBuf.readInt();
        Assert.assertEquals((long)46L, (long)byteBuf.readInt());
        Assert.assertEquals((long)46L, (long)byteBuf.readInt());
        ByteBuf ethernetPacket = byteBuf.readBytes(46);
        ByteBuf dstMac = ethernetPacket.readBytes(6);
        ByteBuf srcMac = ethernetPacket.readBytes(6);
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, -1}, (byte[])ByteBufUtil.getBytes((ByteBuf)dstMac));
        Assert.assertArrayEquals((byte[])new byte[]{0, 0, 94, 0, 83, 0}, (byte[])ByteBufUtil.getBytes((ByteBuf)srcMac));
        Assert.assertEquals((long)2048L, (long)ethernetPacket.readShort());
        ByteBuf ipv4Packet = ethernetPacket.readBytes(32);
        Assert.assertEquals((long)69L, (long)ipv4Packet.readByte());
        Assert.assertEquals((long)0L, (long)ipv4Packet.readByte());
        Assert.assertEquals((long)32L, (long)ipv4Packet.readShort());
        Assert.assertEquals((long)0L, (long)ipv4Packet.readShort());
        Assert.assertEquals((long)0L, (long)ipv4Packet.readShort());
        Assert.assertEquals((long)-1L, (long)ipv4Packet.readByte());
        Assert.assertEquals((long)17L, (long)ipv4Packet.readByte());
        Assert.assertEquals((long)0L, (long)ipv4Packet.readShort());
        Assert.assertEquals((long)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)srvAddr.getAddress())), (long)ipv4Packet.readInt());
        Assert.assertEquals((long)NetUtil.ipv4AddressToInt((Inet4Address)((Inet4Address)cltAddr.getAddress())), (long)ipv4Packet.readInt());
        ByteBuf udpPacket = ipv4Packet.readBytes(12);
        Assert.assertEquals((long)(cltAddr.getPort() & 0xFFFF), (long)udpPacket.readUnsignedShort());
        Assert.assertEquals((long)(srvAddr.getPort() & 0xFFFF), (long)udpPacket.readUnsignedShort());
        Assert.assertEquals((long)12L, (long)udpPacket.readShort());
        Assert.assertEquals((long)1L, (long)udpPacket.readShort());
        ByteBuf payload = udpPacket.readBytes(4);
        Assert.assertArrayEquals((byte[])"Meow".getBytes(CharsetUtil.UTF_8), (byte[])ByteBufUtil.getBytes((ByteBuf)payload));
        Assert.assertTrue((boolean)dstMac.release());
        Assert.assertTrue((boolean)srcMac.release());
        Assert.assertTrue((boolean)payload.release());
        Assert.assertTrue((boolean)byteBuf.release());
        Assert.assertTrue((boolean)ethernetPacket.release());
        Assert.assertTrue((boolean)ipv4Packet.release());
        Assert.assertTrue((boolean)udpPacket.release());
    }
}

