/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.DelegatingSslContext;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslHandler;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import org.junit.Assert;
import org.junit.Test;

public class DelegatingSslContextTest {
    private static final String[] EXPECTED_PROTOCOLS = new String[]{"TLSv1.1"};

    @Test
    public void testInitEngineOnNewEngine() throws Exception {
        SslContext delegating = DelegatingSslContextTest.newDelegatingSslContext();
        SSLEngine engine = delegating.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertArrayEquals((Object[])EXPECTED_PROTOCOLS, (Object[])engine.getEnabledProtocols());
        engine = delegating.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, "localhost", 9090);
        Assert.assertArrayEquals((Object[])EXPECTED_PROTOCOLS, (Object[])engine.getEnabledProtocols());
    }

    @Test
    public void testInitEngineOnNewSslHandler() throws Exception {
        SslContext delegating = DelegatingSslContextTest.newDelegatingSslContext();
        SslHandler handler = delegating.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        Assert.assertArrayEquals((Object[])EXPECTED_PROTOCOLS, (Object[])handler.engine().getEnabledProtocols());
        handler = delegating.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, "localhost", 9090);
        Assert.assertArrayEquals((Object[])EXPECTED_PROTOCOLS, (Object[])handler.engine().getEnabledProtocols());
    }

    private static SslContext newDelegatingSslContext() throws Exception {
        return new DelegatingSslContext((SslContext)new JdkSslContext(SSLContext.getDefault(), false, ClientAuth.NONE)){

            protected void initEngine(SSLEngine engine) {
                engine.setEnabledProtocols(EXPECTED_PROTOCOLS);
            }
        };
    }
}

