/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelId;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultChannelId;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.channel.local.LocalAddress;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.UnsupportedMessageTypeException;
import io.netty.handler.ssl.OpenSsl;
import io.netty.handler.ssl.OpenSslSessionContext;
import io.netty.handler.ssl.OpenSslSessionTicketKey;
import io.netty.handler.ssl.SslCloseCompletionEvent;
import io.netty.handler.ssl.SslCompletionEvent;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.SslHandshakeCompletionEvent;
import io.netty.handler.ssl.SslHandshakeTimeoutException;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.AbstractReferenceCounted;
import io.netty.util.IllegalReferenceCountException;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.ReferenceCounted;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.FutureListener;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.ImmediateEventExecutor;
import io.netty.util.concurrent.ImmediateExecutor;
import io.netty.util.concurrent.Promise;
import io.netty.util.internal.EmptyArrays;
import io.netty.util.internal.PlatformDependent;
import java.io.File;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLProtocolException;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509ExtendedTrustManager;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public class SslHandlerTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testNonApplicationDataFailureFailsQueuedWrites() throws NoSuchAlgorithmException, InterruptedException {
        final CountDownLatch writeLatch = new CountDownLatch(1);
        final ConcurrentLinkedQueue writesToFail = new ConcurrentLinkedQueue();
        SSLEngine engine = SslHandlerTest.newClientModeSSLEngine();
        SslHandler handler = new SslHandler(engine){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
                super.write(ctx, msg, promise);
                writeLatch.countDown();
            }
        };
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new ChannelDuplexHandler(){

            public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
                if (msg instanceof ByteBuf) {
                    if (((ByteBuf)msg).isReadable()) {
                        writesToFail.add(promise);
                    } else {
                        promise.setSuccess();
                    }
                }
                ReferenceCountUtil.release((Object)msg);
            }
        }, handler});
        try {
            ChannelPromise promiseToFail;
            final CountDownLatch writeCauseLatch = new CountDownLatch(1);
            final AtomicReference failureRef = new AtomicReference();
            ch.write((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1})).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) {
                    failureRef.compareAndSet(null, future.cause());
                    writeCauseLatch.countDown();
                }
            });
            writeLatch.await();
            while ((promiseToFail = (ChannelPromise)writesToFail.poll()) != null) {
                promiseToFail.setFailure((Throwable)new RuntimeException("fake exception"));
            }
            writeCauseLatch.await();
            Throwable writeCause = (Throwable)failureRef.get();
            Assert.assertNotNull((Object)writeCause);
            MatcherAssert.assertThat((Object)writeCause, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SSLException.class)));
            Throwable cause = handler.handshakeFuture().cause();
            Assert.assertNotNull((Object)cause);
            MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SSLException.class)));
        }
        finally {
            Assert.assertFalse((boolean)ch.finishAndReleaseAll());
        }
    }

    @Test
    public void testNoSslHandshakeEventWhenNoHandshake() throws Exception {
        final AtomicBoolean inActive = new AtomicBoolean(false);
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        EmbeddedChannel ch = new EmbeddedChannel((ChannelId)DefaultChannelId.newInstance(), false, false, new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                ctx.close();
            }
        }, new SslHandler(engine){

            public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
                inActive.set(true);
                super.handlerAdded(ctx);
                inActive.set(false);
            }
        }, new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof SslHandshakeCompletionEvent) {
                    throw (Exception)((SslHandshakeCompletionEvent)evt).cause();
                }
            }
        }}){

            public boolean isActive() {
                return !inActive.get() && super.isActive();
            }
        };
        ch.register();
        Assert.assertFalse((boolean)ch.finishAndReleaseAll());
    }

    @Test(expected=SslHandshakeTimeoutException.class, timeout=3000L)
    public void testClientHandshakeTimeout() throws Exception {
        SslHandlerTest.testHandshakeTimeout(true);
    }

    @Test(expected=SslHandshakeTimeoutException.class, timeout=3000L)
    public void testServerHandshakeTimeout() throws Exception {
        SslHandlerTest.testHandshakeTimeout(false);
    }

    private static SSLEngine newServerModeSSLEngine() throws NoSuchAlgorithmException {
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(false);
        return engine;
    }

    private static SSLEngine newClientModeSSLEngine() throws NoSuchAlgorithmException {
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(true);
        return engine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testHandshakeTimeout(boolean client) throws Exception {
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(client);
        SslHandler handler = new SslHandler(engine);
        handler.setHandshakeTimeoutMillis(1L);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler});
        try {
            while (!handler.handshakeFuture().isDone()) {
                Thread.sleep(10L);
                ch.runPendingTasks();
            }
            handler.handshakeFuture().syncUninterruptibly();
        }
        finally {
            ch.finishAndReleaseAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testHandshakeAndClosePromiseFailedOnRemoval() throws Exception {
        SSLEngine engine = SSLContext.getDefault().createSSLEngine();
        engine.setUseClientMode(true);
        SslHandler handler = new SslHandler(engine);
        final AtomicReference handshakeRef = new AtomicReference();
        final AtomicReference closeRef = new AtomicReference();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler, new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                if (evt instanceof SslHandshakeCompletionEvent) {
                    handshakeRef.set(((SslHandshakeCompletionEvent)evt).cause());
                } else if (evt instanceof SslCloseCompletionEvent) {
                    closeRef.set(((SslCloseCompletionEvent)evt).cause());
                }
            }
        }});
        Assert.assertFalse((boolean)handler.handshakeFuture().isDone());
        Assert.assertFalse((boolean)handler.sslCloseFuture().isDone());
        ch.pipeline().remove((ChannelHandler)handler);
        try {
            while (!handler.handshakeFuture().isDone() || handshakeRef.get() == null || !handler.sslCloseFuture().isDone() || closeRef.get() == null) {
                Thread.sleep(10L);
                ch.runPendingTasks();
            }
            Assert.assertSame((Object)handler.handshakeFuture().cause(), handshakeRef.get());
            Assert.assertSame((Object)handler.sslCloseFuture().cause(), closeRef.get());
        }
        finally {
            ch.finishAndReleaseAll();
        }
    }

    @Test
    public void testTruncatedPacket() throws Exception {
        SSLEngine engine = SslHandlerTest.newServerModeSSLEngine();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(engine)});
        ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{22, 3, 1, 0, 5})});
        MatcherAssert.assertThat((Object)ch.readInbound(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.nullValue()));
        try {
            ch.writeInbound(new Object[]{Unpooled.wrappedBuffer((byte[])new byte[]{2, 0, 0, 1, 0})});
            Assert.fail();
        }
        catch (DecoderException e) {
            ch.finishAndReleaseAll();
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SSLProtocolException.class)));
        }
    }

    @Test
    public void testNonByteBufWriteIsReleased() throws Exception {
        SSLEngine engine = SslHandlerTest.newServerModeSSLEngine();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(engine)});
        AbstractReferenceCounted referenceCounted = new AbstractReferenceCounted(){

            public ReferenceCounted touch(Object hint) {
                return this;
            }

            protected void deallocate() {
            }
        };
        try {
            ch.write((Object)referenceCounted).get();
            Assert.fail();
        }
        catch (ExecutionException e) {
            MatcherAssert.assertThat((Object)e.getCause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(UnsupportedMessageTypeException.class)));
        }
        Assert.assertEquals((long)0L, (long)referenceCounted.refCnt());
        Assert.assertTrue((boolean)ch.finishAndReleaseAll());
    }

    @Test(expected=UnsupportedMessageTypeException.class)
    public void testNonByteBufNotPassThrough() throws Exception {
        SSLEngine engine = SslHandlerTest.newServerModeSSLEngine();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(engine)});
        try {
            ch.writeOutbound(new Object[]{new Object()});
        }
        finally {
            ch.finishAndReleaseAll();
        }
    }

    @Test
    public void testIncompleteWriteDoesNotCompletePromisePrematurely() throws NoSuchAlgorithmException {
        SSLEngine engine = SslHandlerTest.newServerModeSSLEngine();
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(engine)});
        ChannelPromise promise = ch.newPromise();
        ByteBuf buf = Unpooled.buffer((int)10).writeZero(10);
        ch.writeAndFlush((Object)buf, promise);
        Assert.assertFalse((boolean)promise.isDone());
        Assert.assertTrue((boolean)ch.finishAndReleaseAll());
        Assert.assertTrue((boolean)promise.isDone());
        MatcherAssert.assertThat((Object)promise.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SSLException.class)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testReleaseSslEngine() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        SelfSignedCertificate cert = new SelfSignedCertificate();
        try {
            SslContext sslContext = SslContextBuilder.forServer((File)cert.certificate(), (File)cert.privateKey()).sslProvider(SslProvider.OPENSSL).build();
            try {
                Assert.assertEquals((long)1L, (long)((ReferenceCounted)sslContext).refCnt());
                SSLEngine sslEngine = sslContext.newEngine(ByteBufAllocator.DEFAULT);
                EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(sslEngine)});
                Assert.assertEquals((long)2L, (long)((ReferenceCounted)sslContext).refCnt());
                Assert.assertEquals((long)1L, (long)((ReferenceCounted)sslEngine).refCnt());
                Assert.assertTrue((boolean)ch.finishAndReleaseAll());
                ch.close().syncUninterruptibly();
                Assert.assertEquals((long)1L, (long)((ReferenceCounted)sslContext).refCnt());
                Assert.assertEquals((long)0L, (long)((ReferenceCounted)sslEngine).refCnt());
            }
            finally {
                ReferenceCountUtil.release((Object)sslContext);
            }
        }
        finally {
            cert.delete();
        }
    }

    @Test
    public void testIssueReadAfterActiveWriteFlush() throws Exception {
        new TlsReadTest().test(false);
    }

    @Test
    public void testIssueReadAfterWriteFlushActive() throws Exception {
        new TlsReadTest().test(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=30000L)
    public void testRemoval() throws Exception {
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        try {
            Promise clientPromise = group.next().newPromise();
            Bootstrap bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler(SslHandlerTest.newHandler(SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build(), (Promise<Void>)clientPromise));
            SelfSignedCertificate ssc = new SelfSignedCertificate();
            Promise serverPromise = group.next().newPromise();
            ServerBootstrap serverBootstrap = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group, (EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler(SslHandlerTest.newHandler(SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build(), (Promise<Void>)serverPromise));
            sc = serverBootstrap.bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            cc = bootstrap.connect(sc.localAddress()).syncUninterruptibly().channel();
            serverPromise.syncUninterruptibly();
            clientPromise.syncUninterruptibly();
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
        }
    }

    private static ChannelHandler newHandler(final SslContext sslCtx, final Promise<Void> promise) {
        return new ChannelInitializer(){

            protected void initChannel(final Channel ch) {
                final SslHandler sslHandler = sslCtx.newHandler(ch.alloc());
                sslHandler.setHandshakeTimeoutMillis(1000L);
                ch.pipeline().addFirst(new ChannelHandler[]{sslHandler});
                sslHandler.handshakeFuture().addListener((GenericFutureListener)new FutureListener<Channel>(){

                    public void operationComplete(Future<Channel> future) {
                        ch.pipeline().remove((ChannelHandler)sslHandler);
                        ch.eventLoop().execute(new Runnable(){

                            @Override
                            public void run() {
                                ch.close();
                            }
                        });
                    }
                });
                ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                        if (cause instanceof CodecException) {
                            cause = cause.getCause();
                        }
                        if (cause instanceof IllegalReferenceCountException) {
                            promise.setFailure(cause);
                        }
                    }

                    public void channelInactive(ChannelHandlerContext ctx) {
                        promise.trySuccess(null);
                    }
                }});
            }
        };
    }

    @Test
    public void testCloseFutureNotified() throws Exception {
        SSLEngine engine = SslHandlerTest.newServerModeSSLEngine();
        SslHandler handler = new SslHandler(engine);
        EmbeddedChannel ch = new EmbeddedChannel(new ChannelHandler[]{handler});
        ch.close();
        ByteBuf buf = (ByteBuf)ch.readOutbound();
        Assert.assertFalse((boolean)buf.isReadable());
        buf.release();
        Assert.assertFalse((boolean)ch.finishAndReleaseAll());
        Assert.assertTrue((boolean)(handler.handshakeFuture().cause() instanceof ClosedChannelException));
        Assert.assertTrue((boolean)(handler.sslCloseFuture().cause() instanceof ClosedChannelException));
    }

    @Test(timeout=5000L)
    public void testEventsFired() throws Exception {
        SSLEngine engine = SslHandlerTest.newServerModeSSLEngine();
        final LinkedBlockingQueue events = new LinkedBlockingQueue();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new SslHandler(engine), new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt instanceof SslCompletionEvent) {
                    events.add((SslCompletionEvent)evt);
                }
            }
        }});
        Assert.assertTrue((boolean)events.isEmpty());
        Assert.assertTrue((boolean)channel.finishAndReleaseAll());
        SslCompletionEvent evt = (SslCompletionEvent)events.take();
        Assert.assertTrue((boolean)(evt instanceof SslHandshakeCompletionEvent));
        Assert.assertTrue((boolean)(evt.cause() instanceof ClosedChannelException));
        evt = (SslCompletionEvent)events.take();
        Assert.assertTrue((boolean)(evt instanceof SslCloseCompletionEvent));
        Assert.assertTrue((boolean)(evt.cause() instanceof ClosedChannelException));
        Assert.assertTrue((boolean)events.isEmpty());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=5000L)
    public void testHandshakeFailBeforeWritePromise() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
        final CountDownLatch latch = new CountDownLatch(2);
        final CountDownLatch latch2 = new CountDownLatch(2);
        final LinkedBlockingQueue events = new LinkedBlockingQueue();
        Channel serverChannel = null;
        Channel clientChannel = null;
        DefaultEventLoopGroup group = new DefaultEventLoopGroup();
        try {
            ServerBootstrap sb = new ServerBootstrap();
            ((ServerBootstrap)sb.group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{sslServerCtx.newHandler(ch.alloc())});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelActive(ChannelHandlerContext ctx) {
                            ByteBuf buf = ctx.alloc().buffer(10);
                            buf.writeZero(buf.capacity());
                            ctx.writeAndFlush((Object)buf).addListener((GenericFutureListener)new ChannelFutureListener(){

                                public void operationComplete(ChannelFuture future) {
                                    events.add(future);
                                    latch.countDown();
                                }
                            });
                        }

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                            if (evt instanceof SslCompletionEvent) {
                                events.add(evt);
                                latch.countDown();
                                latch2.countDown();
                            }
                        }
                    }});
                }
            });
            Bootstrap cb = new Bootstrap();
            ((Bootstrap)((Bootstrap)cb.group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addFirst(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void channelActive(ChannelHandlerContext ctx) {
                            ByteBuf buf = ctx.alloc().buffer(1000);
                            buf.writeZero(buf.capacity());
                            ctx.writeAndFlush((Object)buf);
                        }
                    }});
                }
            });
            serverChannel = sb.bind((SocketAddress)new LocalAddress("SslHandlerTest")).sync().channel();
            clientChannel = cb.connect(serverChannel.localAddress()).sync().channel();
            latch.await();
            SslCompletionEvent evt = (SslCompletionEvent)events.take();
            Assert.assertTrue((boolean)(evt instanceof SslHandshakeCompletionEvent));
            MatcherAssert.assertThat((Object)evt.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SSLException.class)));
            ChannelFuture future = (ChannelFuture)events.take();
            MatcherAssert.assertThat((Object)future.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(SSLException.class)));
            serverChannel.close().sync();
            serverChannel = null;
            clientChannel.close().sync();
            clientChannel = null;
            latch2.await();
            evt = (SslCompletionEvent)events.take();
            Assert.assertTrue((boolean)(evt instanceof SslCloseCompletionEvent));
            MatcherAssert.assertThat((Object)evt.cause(), (Matcher)CoreMatchers.is((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
            Assert.assertTrue((boolean)events.isEmpty());
        }
        finally {
            if (serverChannel != null) {
                serverChannel.close();
            }
            if (clientChannel != null) {
                clientChannel.close();
            }
            group.shutdownGracefully();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writingReadOnlyBufferDoesNotBreakAggregation() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((File)ssc.certificate(), (File)ssc.privateKey()).build();
        final SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final CountDownLatch serverReceiveLatch = new CountDownLatch(1);
        try {
            int expectedBytes = 11;
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{sslServerCtx.newHandler(ch.alloc())});
                    ch.pipeline().addLast(new ChannelHandler[]{new SimpleChannelInboundHandler<ByteBuf>(){
                        private int readBytes;

                        protected void channelRead0(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
                            this.readBytes += msg.readableBytes();
                            if (this.readBytes >= 11) {
                                serverReceiveLatch.countDown();
                            }
                        }
                    }});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            cc = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{sslClientCtx.newHandler(ch.alloc())});
                }
            })).connect(sc.localAddress()).syncUninterruptibly().channel();
            ByteBuf firstBuffer = Unpooled.buffer((int)10);
            firstBuffer.writeByte(0);
            firstBuffer = firstBuffer.asReadOnly();
            ByteBuf secondBuffer = Unpooled.buffer((int)10);
            secondBuffer.writeZero(secondBuffer.capacity());
            cc.write((Object)firstBuffer);
            cc.writeAndFlush((Object)secondBuffer).syncUninterruptibly();
            serverReceiveLatch.countDown();
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslServerCtx);
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testCloseOnHandshakeFailure() throws Exception {
        SelfSignedCertificate ssc = new SelfSignedCertificate();
        final SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)ssc.key(), (X509Certificate[])new X509Certificate[]{ssc.cert()}).build();
        final SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(new X509Certificate[]{new SelfSignedCertificate().cert()}).build();
        NioEventLoopGroup group = new NioEventLoopGroup(1);
        Channel sc = null;
        Channel cc = null;
        try {
            LocalAddress address = new LocalAddress(this.getClass().getSimpleName() + ".testCloseOnHandshakeFailure");
            ServerBootstrap sb = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(LocalServerChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{sslServerCtx.newHandler(ch.alloc())});
                }
            });
            sc = sb.bind((SocketAddress)address).syncUninterruptibly().channel();
            final AtomicReference sslHandlerRef = new AtomicReference();
            Bootstrap b = (Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(LocalChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    SslHandler handler = sslClientCtx.newHandler(ch.alloc());
                    sslHandlerRef.set(handler);
                    ch.pipeline().addLast(new ChannelHandler[]{handler});
                }
            });
            cc = b.connect(sc.localAddress()).syncUninterruptibly().channel();
            SslHandler handler = (SslHandler)sslHandlerRef.get();
            handler.handshakeFuture().awaitUninterruptibly();
            Assert.assertFalse((boolean)handler.handshakeFuture().isSuccess());
            cc.closeFuture().syncUninterruptibly();
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslServerCtx);
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @Test
    public void testOutboundClosedAfterChannelInactive() throws Exception {
        SslContext context = SslContextBuilder.forClient().build();
        SSLEngine engine = context.newEngine((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        EmbeddedChannel channel = new EmbeddedChannel();
        Assert.assertFalse((boolean)channel.finish());
        channel.pipeline().addLast(new ChannelHandler[]{new SslHandler(engine)});
        Assert.assertFalse((boolean)engine.isOutboundDone());
        channel.close().syncUninterruptibly();
        Assert.assertTrue((boolean)engine.isOutboundDone());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testHandshakeFailedByWriteBeforeChannelActive() throws Exception {
        SslContext sslClientCtx = SslContextBuilder.forClient().protocols(new String[]{"SSLv3"}).trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(SslProvider.JDK).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final CountDownLatch activeLatch = new CountDownLatch(1);
        final AtomicReference errorRef = new AtomicReference();
        final SslHandler sslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        try {
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter()).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            cc = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                            if (cause instanceof AssertionError) {
                                errorRef.set((AssertionError)((Object)cause));
                            }
                        }

                        public void channelActive(ChannelHandlerContext ctx) throws Exception {
                            activeLatch.countDown();
                        }
                    }});
                }
            })).connect(sc.localAddress()).addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    future.channel().writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
                }
            }).syncUninterruptibly().channel();
            activeLatch.await(5L, TimeUnit.SECONDS);
            AssertionError error = (AssertionError)errorRef.get();
            if (error != null) {
                throw error;
            }
            MatcherAssert.assertThat((Object)sslHandler.handshakeFuture().await().cause(), (Matcher)CoreMatchers.instanceOf(SSLException.class));
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @Test(timeout=10000L)
    public void testHandshakeTimeoutFlushStartsHandshake() throws Exception {
        SslHandlerTest.testHandshakeTimeout0(false);
    }

    @Test(timeout=10000L)
    public void testHandshakeTimeoutStartTLS() throws Exception {
        SslHandlerTest.testHandshakeTimeout0(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testHandshakeTimeout0(final boolean startTls) throws Exception {
        SslContext sslClientCtx = SslContextBuilder.forClient().startTls(true).trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(SslProvider.JDK).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final SslHandler sslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        sslHandler.setHandshakeTimeout(500L, TimeUnit.MILLISECONDS);
        try {
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInboundHandlerAdapter()).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{sslHandler});
                    if (startTls) {
                        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                                ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
                            }
                        }});
                    }
                }
            })).connect(sc.localAddress());
            if (!startTls) {
                future.addListener((GenericFutureListener)new ChannelFutureListener(){

                    public void operationComplete(ChannelFuture future) throws Exception {
                        future.channel().writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])new byte[]{1, 2, 3, 4}));
                    }
                });
            }
            cc = future.syncUninterruptibly().channel();
            Throwable cause = sslHandler.handshakeFuture().await().cause();
            MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(SSLException.class));
            MatcherAssert.assertThat((Object)cause.getMessage(), (Matcher)CoreMatchers.containsString((String)"timed out"));
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @Test
    public void testHandshakeWithExecutorThatExecuteDirecty() throws Exception {
        SslHandlerTest.testHandshakeWithExecutor(new Executor(){

            @Override
            public void execute(Runnable command) {
                command.run();
            }
        });
    }

    @Test
    public void testHandshakeWithImmediateExecutor() throws Exception {
        SslHandlerTest.testHandshakeWithExecutor((Executor)ImmediateExecutor.INSTANCE);
    }

    @Test
    public void testHandshakeWithImmediateEventExecutor() throws Exception {
        SslHandlerTest.testHandshakeWithExecutor((Executor)ImmediateEventExecutor.INSTANCE);
    }

    @Test
    public void testHandshakeWithExecutor() throws Exception {
        ExecutorService executorService = Executors.newCachedThreadPool();
        try {
            SslHandlerTest.testHandshakeWithExecutor(executorService);
        }
        finally {
            executorService.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testHandshakeWithExecutor(Executor executor) throws Exception {
        SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(SslProvider.JDK).build();
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(SslProvider.JDK).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final SslHandler clientSslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, executor);
        SslHandler serverSslHandler = sslServerCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, executor);
        try {
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)serverSslHandler).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{clientSslHandler});
                }
            })).connect(sc.localAddress());
            cc = future.syncUninterruptibly().channel();
            Assert.assertTrue((boolean)clientSslHandler.handshakeFuture().await().isSuccess());
            Assert.assertTrue((boolean)serverSslHandler.handshakeFuture().await().isSuccess());
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @Test
    public void testClientHandshakeTimeoutBecauseExecutorNotExecute() throws Exception {
        SslHandlerTest.testHandshakeTimeoutBecauseExecutorNotExecute(true);
    }

    @Test
    public void testServerHandshakeTimeoutBecauseExecutorNotExecute() throws Exception {
        SslHandlerTest.testHandshakeTimeoutBecauseExecutorNotExecute(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testHandshakeTimeoutBecauseExecutorNotExecute(final boolean client) throws Exception {
        SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(SslProvider.JDK).build();
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(SslProvider.JDK).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final SslHandler clientSslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, new Executor(){

            @Override
            public void execute(Runnable command) {
                if (!client) {
                    command.run();
                }
            }
        });
        if (client) {
            clientSslHandler.setHandshakeTimeout(100L, TimeUnit.MILLISECONDS);
        }
        SslHandler serverSslHandler = sslServerCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT, new Executor(){

            @Override
            public void execute(Runnable command) {
                if (client) {
                    command.run();
                }
            }
        });
        if (!client) {
            serverSslHandler.setHandshakeTimeout(100L, TimeUnit.MILLISECONDS);
        }
        try {
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)serverSslHandler).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{clientSslHandler});
                }
            })).connect(sc.localAddress());
            cc = future.syncUninterruptibly().channel();
            if (client) {
                Throwable cause = clientSslHandler.handshakeFuture().await().cause();
                MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(SslHandshakeTimeoutException.class));
                Assert.assertFalse((boolean)serverSslHandler.handshakeFuture().await().isSuccess());
            } else {
                Throwable cause = serverSslHandler.handshakeFuture().await().cause();
                MatcherAssert.assertThat((Object)cause, (Matcher)CoreMatchers.instanceOf(SslHandshakeTimeoutException.class));
                Assert.assertFalse((boolean)clientSslHandler.handshakeFuture().await().isSuccess());
            }
        }
        finally {
            if (cc != null) {
                cc.close().syncUninterruptibly();
            }
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    @Test(timeout=5000L)
    public void testSessionTicketsWithTLSv12() throws Throwable {
        SslHandlerTest.testSessionTickets(SslProvider.OPENSSL, "TLSv1.2", true);
    }

    @Test(timeout=5000L)
    public void testSessionTicketsWithTLSv13() throws Throwable {
        Assume.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)SslProvider.OPENSSL));
        SslHandlerTest.testSessionTickets(SslProvider.OPENSSL, "TLSv1.3", true);
    }

    @Test(timeout=5000L)
    public void testSessionTicketsWithTLSv12AndNoKey() throws Throwable {
        SslHandlerTest.testSessionTickets(SslProvider.OPENSSL, "TLSv1.2", false);
    }

    @Test(timeout=5000L)
    public void testSessionTicketsWithTLSv13AndNoKey() throws Throwable {
        Assume.assumeTrue((boolean)OpenSsl.isTlsv13Supported());
        SslHandlerTest.testSessionTickets(SslProvider.OPENSSL, "TLSv1.3", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testSessionTickets(SslProvider provider, String protocol, boolean withKey) throws Throwable {
        block11: {
            Assume.assumeTrue((boolean)OpenSsl.isAvailable());
            SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).sslProvider(provider).protocols(new String[]{protocol}).build();
            SelfSignedCertificate cert = new SelfSignedCertificate();
            SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(provider).protocols(new String[]{protocol}).build();
            if (withKey) {
                OpenSslSessionTicketKey key = new OpenSslSessionTicketKey(new byte[16], new byte[16], new byte[16]);
                ((OpenSslSessionContext)sslClientCtx.sessionContext()).setTicketKeys(new OpenSslSessionTicketKey[]{key});
                ((OpenSslSessionContext)sslServerCtx.sessionContext()).setTicketKeys(new OpenSslSessionTicketKey[]{key});
            } else {
                ((OpenSslSessionContext)sslClientCtx.sessionContext()).setTicketKeys(new OpenSslSessionTicketKey[0]);
                ((OpenSslSessionContext)sslServerCtx.sessionContext()).setTicketKeys(new OpenSslSessionTicketKey[0]);
            }
            NioEventLoopGroup group = new NioEventLoopGroup();
            Channel sc = null;
            Channel cc = null;
            final SslHandler clientSslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
            final SslHandler serverSslHandler = sslServerCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
            final LinkedBlockingQueue queue = new LinkedBlockingQueue();
            final byte[] bytes = new byte[96];
            PlatformDependent.threadLocalRandom().nextBytes(bytes);
            try {
                sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) {
                        ch.pipeline().addLast(new ChannelHandler[]{serverSslHandler});
                        ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) {
                                if (evt instanceof SslHandshakeCompletionEvent) {
                                    ctx.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[])bytes));
                                }
                            }
                        }});
                    }
                }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
                ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                    protected void initChannel(Channel ch) {
                        ch.pipeline().addLast(new ChannelHandler[]{clientSslHandler});
                        ch.pipeline().addLast(new ChannelHandler[]{new ByteToMessageDecoder(){

                            protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
                                if (in.readableBytes() == bytes.length) {
                                    queue.add(in.readBytes(bytes.length));
                                }
                            }

                            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                                queue.add(cause);
                            }
                        }});
                    }
                })).connect(sc.localAddress());
                cc = future.syncUninterruptibly().channel();
                Assert.assertTrue((boolean)clientSslHandler.handshakeFuture().await().isSuccess());
                Assert.assertTrue((boolean)serverSslHandler.handshakeFuture().await().isSuccess());
                Object obj = queue.take();
                if (obj instanceof ByteBuf) {
                    ByteBuf buffer = (ByteBuf)obj;
                    ByteBuf expected = Unpooled.wrappedBuffer((byte[])bytes);
                    try {
                        Assert.assertEquals((Object)expected, (Object)buffer);
                        break block11;
                    }
                    finally {
                        expected.release();
                    }
                }
                throw (Throwable)obj;
            }
            finally {
                if (cc != null) {
                    cc.close().syncUninterruptibly();
                }
                if (sc != null) {
                    sc.close().syncUninterruptibly();
                }
                group.shutdownGracefully();
                ReferenceCountUtil.release((Object)sslClientCtx);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test(timeout=10000L)
    public void testHandshakeFailureOnlyFireExceptionOnce() throws Exception {
        SslContext sslClientCtx = SslContextBuilder.forClient().trustManager((TrustManager)new X509ExtendedTrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                this.failVerification();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, Socket socket) throws CertificateException {
                this.failVerification();
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                this.failVerification();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType, SSLEngine engine) throws CertificateException {
                this.failVerification();
            }

            @Override
            public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                this.failVerification();
            }

            @Override
            public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
                this.failVerification();
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return EmptyArrays.EMPTY_X509_CERTIFICATES;
            }

            private void failVerification() throws CertificateException {
                throw new CertificateException();
            }
        }).sslProvider(SslProvider.JDK).build();
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).sslProvider(SslProvider.JDK).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        final SslHandler clientSslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        final SslHandler serverSslHandler = sslServerCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        try {
            final Object terminalEvent = new Object();
            final LinkedBlockingQueue errorQueue = new LinkedBlockingQueue();
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{serverSslHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                            errorQueue.add(cause);
                        }

                        public void channelInactive(ChannelHandlerContext ctx) {
                            errorQueue.add(terminalEvent);
                        }
                    }});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            final ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{clientSslHandler});
                }
            })).connect(sc.localAddress());
            future.syncUninterruptibly();
            clientSslHandler.handshakeFuture().addListener((GenericFutureListener)new FutureListener<Channel>(){

                public void operationComplete(Future<Channel> f) {
                    future.channel().close();
                }
            });
            Assert.assertFalse((boolean)clientSslHandler.handshakeFuture().await().isSuccess());
            Assert.assertFalse((boolean)serverSslHandler.handshakeFuture().await().isSuccess());
            Object error = errorQueue.take();
            MatcherAssert.assertThat(error, (Matcher)Matchers.instanceOf(DecoderException.class));
            MatcherAssert.assertThat((Object)((Throwable)error).getCause(), (Matcher)Matchers.instanceOf(SSLException.class));
            Object terminal = errorQueue.take();
            Assert.assertSame((Object)terminalEvent, terminal);
            Assert.assertNull(errorQueue.poll(1L, TimeUnit.MILLISECONDS));
        }
        finally {
            if (sc != null) {
                sc.close().syncUninterruptibly();
            }
            group.shutdownGracefully();
        }
    }

    @Test
    public void testHandshakeFailureCipherMissmatchTLSv12Jdk() throws Exception {
        SslHandlerTest.testHandshakeFailureCipherMissmatch(SslProvider.JDK, false);
    }

    @Test
    public void testHandshakeFailureCipherMissmatchTLSv13Jdk() throws Exception {
        Assume.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)SslProvider.JDK));
        SslHandlerTest.testHandshakeFailureCipherMissmatch(SslProvider.JDK, true);
    }

    @Test
    public void testHandshakeFailureCipherMissmatchTLSv12OpenSsl() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        SslHandlerTest.testHandshakeFailureCipherMissmatch(SslProvider.OPENSSL, false);
    }

    @Test
    public void testHandshakeFailureCipherMissmatchTLSv13OpenSsl() throws Exception {
        Assume.assumeTrue((boolean)OpenSsl.isAvailable());
        Assume.assumeTrue((boolean)SslProvider.isTlsv13Supported((SslProvider)SslProvider.OPENSSL));
        Assume.assumeFalse((String)"BoringSSL does not support setting ciphers for TLSv1.3 explicit", (boolean)OpenSsl.isBoringSSL());
        SslHandlerTest.testHandshakeFailureCipherMissmatch(SslProvider.OPENSSL, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void testHandshakeFailureCipherMissmatch(SslProvider provider, boolean tls13) throws Exception {
        String protocol;
        String serverCipher;
        String clientCipher;
        if (tls13) {
            clientCipher = "TLS_AES_128_GCM_SHA256";
            serverCipher = "TLS_AES_256_GCM_SHA384";
            protocol = "TLSv1.3";
        } else {
            clientCipher = "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256";
            serverCipher = "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384";
            protocol = "TLSv1.2";
        }
        SslContext sslClientCtx = SslContextBuilder.forClient().trustManager(InsecureTrustManagerFactory.INSTANCE).protocols(new String[]{protocol}).ciphers(Collections.singleton(clientCipher)).sslProvider(provider).build();
        SelfSignedCertificate cert = new SelfSignedCertificate();
        SslContext sslServerCtx = SslContextBuilder.forServer((PrivateKey)cert.key(), (X509Certificate[])new X509Certificate[]{cert.cert()}).protocols(new String[]{protocol}).ciphers(Collections.singleton(serverCipher)).sslProvider(provider).build();
        NioEventLoopGroup group = new NioEventLoopGroup();
        Channel sc = null;
        Channel cc = null;
        final SslHandler clientSslHandler = sslClientCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        final SslHandler serverSslHandler = sslServerCtx.newHandler((ByteBufAllocator)UnpooledByteBufAllocator.DEFAULT);
        final AtomicReference clientEvent = new AtomicReference();
        final AtomicReference serverEvent = new AtomicReference();
        try {
            sc = ((ServerBootstrap)new ServerBootstrap().group((EventLoopGroup)group).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) throws Exception {
                    ch.pipeline().addLast(new ChannelHandler[]{serverSslHandler});
                    class SslEventHandler
                    extends ChannelInboundHandlerAdapter {
                        private final AtomicReference<SslHandshakeCompletionEvent> ref;

                        SslEventHandler(AtomicReference<SslHandshakeCompletionEvent> ref) {
                            this.ref = ref;
                        }

                        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                            if (evt instanceof SslHandshakeCompletionEvent) {
                                this.ref.set((SslHandshakeCompletionEvent)evt);
                            }
                            super.userEventTriggered(ctx, evt);
                        }
                    }
                    ch.pipeline().addLast(new ChannelHandler[]{new SslEventHandler(serverEvent)});
                }
            }).bind((SocketAddress)new InetSocketAddress(0)).syncUninterruptibly().channel();
            ChannelFuture future = ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)group)).channel(NioSocketChannel.class)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

                protected void initChannel(Channel ch) {
                    ch.pipeline().addLast(new ChannelHandler[]{clientSslHandler});
                    ch.pipeline().addLast(new ChannelHandler[]{new SslEventHandler(clientEvent)});
                }
            })).connect(sc.localAddress());
            cc = future.syncUninterruptibly().channel();
            Throwable clientCause = clientSslHandler.handshakeFuture().await().cause();
            MatcherAssert.assertThat((Object)clientCause, (Matcher)CoreMatchers.instanceOf(SSLException.class));
            MatcherAssert.assertThat((Object)clientCause.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
            Throwable serverCause = serverSslHandler.handshakeFuture().await().cause();
            MatcherAssert.assertThat((Object)serverCause, (Matcher)CoreMatchers.instanceOf(SSLException.class));
            MatcherAssert.assertThat((Object)serverCause.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
            cc.close().syncUninterruptibly();
            sc.close().syncUninterruptibly();
            Throwable eventClientCause = ((SslHandshakeCompletionEvent)clientEvent.get()).cause();
            MatcherAssert.assertThat((Object)eventClientCause, (Matcher)CoreMatchers.instanceOf(SSLException.class));
            MatcherAssert.assertThat((Object)eventClientCause.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
            Throwable serverEventCause = ((SslHandshakeCompletionEvent)serverEvent.get()).cause();
            MatcherAssert.assertThat((Object)serverEventCause, (Matcher)CoreMatchers.instanceOf(SSLException.class));
            MatcherAssert.assertThat((Object)serverEventCause.getCause(), (Matcher)CoreMatchers.not((Matcher)CoreMatchers.instanceOf(ClosedChannelException.class)));
        }
        finally {
            group.shutdownGracefully();
            ReferenceCountUtil.release((Object)sslClientCtx);
        }
    }

    private static final class TlsReadTest
    extends ChannelOutboundHandlerAdapter {
        private volatile boolean readIssued;

        private TlsReadTest() {
        }

        public void read(ChannelHandlerContext ctx) throws Exception {
            this.readIssued = true;
            super.read(ctx);
        }

        public void test(final boolean dropChannelActive) throws Exception {
            SSLEngine engine = SSLContext.getDefault().createSSLEngine();
            engine.setUseClientMode(true);
            EmbeddedChannel ch = new EmbeddedChannel(false, false, new ChannelHandler[]{this, new SslHandler(engine), new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    if (!dropChannelActive) {
                        ctx.fireChannelActive();
                    }
                }
            }});
            ch.config().setAutoRead(false);
            Assert.assertFalse((boolean)ch.config().isAutoRead());
            ch.register();
            Assert.assertTrue((boolean)this.readIssued);
            this.readIssued = false;
            Assert.assertTrue((boolean)ch.writeOutbound(new Object[]{Unpooled.EMPTY_BUFFER}));
            Assert.assertTrue((boolean)this.readIssued);
            Assert.assertTrue((boolean)ch.finishAndReleaseAll());
        }
    }
}

