/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.SslContext;
import io.netty.util.internal.ResourcesUtil;
import java.io.File;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.spec.InvalidKeySpecException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;

public abstract class SslContextTest {
    @Test(expected=IOException.class)
    public void testUnencryptedEmptyPassword() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)ResourcesUtil.getFile(this.getClass(), (String)"test2_unencrypted.pem"), (String)"");
        Assert.assertNotNull((Object)key);
    }

    @Test
    public void testUnEncryptedNullPassword() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)ResourcesUtil.getFile(this.getClass(), (String)"test2_unencrypted.pem"), null);
        Assert.assertNotNull((Object)key);
    }

    @Test
    public void testEncryptedEmptyPassword() throws Exception {
        PrivateKey key = SslContext.toPrivateKey((File)ResourcesUtil.getFile(this.getClass(), (String)"test_encrypted_empty_pass.pem"), (String)"");
        Assert.assertNotNull((Object)key);
    }

    @Test(expected=InvalidKeySpecException.class)
    public void testEncryptedNullPassword() throws Exception {
        SslContext.toPrivateKey((File)ResourcesUtil.getFile(this.getClass(), (String)"test_encrypted_empty_pass.pem"), null);
    }

    @Test
    public void testSslContextWithEncryptedPrivateKey() throws SSLException {
        File keyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_encrypted.pem");
        File crtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        this.newSslContext(crtFile, keyFile, "12345");
    }

    @Test
    public void testSslContextWithEncryptedPrivateKey2() throws SSLException {
        File keyFile = ResourcesUtil.getFile(this.getClass(), (String)"test2_encrypted.pem");
        File crtFile = ResourcesUtil.getFile(this.getClass(), (String)"test2.crt");
        this.newSslContext(crtFile, keyFile, "12345");
    }

    @Test
    public void testSslContextWithUnencryptedPrivateKey() throws SSLException {
        File keyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem");
        File crtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        this.newSslContext(crtFile, keyFile, null);
    }

    @Test(expected=SSLException.class)
    public void testSslContextWithUnencryptedPrivateKeyEmptyPass() throws SSLException {
        File keyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem");
        File crtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        this.newSslContext(crtFile, keyFile, "");
    }

    @Test
    public void testSupportedCiphers() throws KeyManagementException, NoSuchAlgorithmException, SSLException {
        SSLContext jdkSslContext = SSLContext.getInstance("TLS");
        jdkSslContext.init(null, null, null);
        SSLEngine sslEngine = jdkSslContext.createSSLEngine();
        String unsupportedCipher = "TLS_DH_anon_WITH_DES_CBC_SHA";
        IllegalArgumentException exception = null;
        try {
            sslEngine.setEnabledCipherSuites(new String[]{unsupportedCipher});
        }
        catch (IllegalArgumentException e) {
            exception = e;
        }
        Assume.assumeNotNull((Object[])new Object[]{exception});
        File keyFile = ResourcesUtil.getFile(this.getClass(), (String)"test_unencrypted.pem");
        File crtFile = ResourcesUtil.getFile(this.getClass(), (String)"test.crt");
        SslContext sslContext = this.newSslContext(crtFile, keyFile, null);
        Assert.assertFalse((boolean)sslContext.cipherSuites().contains(unsupportedCipher));
    }

    @Test(expected=CertificateException.class)
    public void testUnsupportedParams() throws CertificateException {
        SslContext.toX509Certificates((File)new File(this.getClass().getResource("ec_params_unsupported.pem").getFile()));
    }

    protected abstract SslContext newSslContext(File var1, File var2, String var3) throws SSLException;
}

