/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.Conscrypt;
import io.netty.handler.ssl.DelegatingSslContext;
import io.netty.handler.ssl.IdentityCipherSuiteFilter;
import io.netty.handler.ssl.JdkAlpnApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkAlpnSslUtils;
import io.netty.handler.ssl.JdkApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkBaseApplicationProtocolNegotiator;
import io.netty.handler.ssl.JdkSslClientContext;
import io.netty.handler.ssl.JdkSslServerContext;
import io.netty.handler.ssl.JettyAlpnSslEngine;
import io.netty.handler.ssl.JettyNpnSslEngine;
import io.netty.handler.ssl.SSLEngineTest;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslProvider;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.ssl.util.SelfSignedCertificate;
import io.netty.util.internal.EmptyArrays;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLHandshakeException;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Ignore;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class JdkSslEngineTest
extends SSLEngineTest {
    private static final String PREFERRED_APPLICATION_LEVEL_PROTOCOL = "my-protocol-http2";
    private static final String FALLBACK_APPLICATION_LEVEL_PROTOCOL = "my-protocol-http1_1";
    private static final String APPLICATION_LEVEL_PROTOCOL_NOT_COMPATIBLE = "my-protocol-FOO";
    private final ProviderType providerType;
    private Provider provider;

    @Parameterized.Parameters(name="{index}: providerType = {0}, bufferType = {1}, combo = {2}, delegate = {3}")
    public static Collection<Object[]> data() {
        ArrayList<Object[]> params = new ArrayList<Object[]>();
        for (ProviderType providerType : ProviderType.values()) {
            for (SSLEngineTest.BufferType bufferType : SSLEngineTest.BufferType.values()) {
                params.add(new Object[]{providerType, bufferType, SSLEngineTest.ProtocolCipherCombo.tlsv12(), true});
                params.add(new Object[]{providerType, bufferType, SSLEngineTest.ProtocolCipherCombo.tlsv12(), false});
                if (!SslProvider.isTlsv13Supported((SslProvider)SslProvider.JDK)) continue;
                params.add(new Object[]{providerType, bufferType, SSLEngineTest.ProtocolCipherCombo.tlsv13(), true});
                params.add(new Object[]{providerType, bufferType, SSLEngineTest.ProtocolCipherCombo.tlsv13(), false});
            }
        }
        return params;
    }

    public JdkSslEngineTest(ProviderType providerType, SSLEngineTest.BufferType bufferType, SSLEngineTest.ProtocolCipherCombo protocolCipherCombo, boolean delegate) {
        super(bufferType, protocolCipherCombo, delegate);
        this.providerType = providerType;
    }

    @Test
    public void testTlsExtension() throws Exception {
        try {
            this.providerType.activate(this);
            ApplicationProtocolConfig apn = JdkSslEngineTest.failingNegotiator(this.providerType.protocol(), PREFERRED_APPLICATION_LEVEL_PROTOCOL);
            this.setupHandlers(apn);
            this.runTest();
        }
        catch (SkipTestException e) {
            Assume.assumeNoException((Throwable)e);
        }
    }

    @Test
    public void testTlsExtensionNoCompatibleProtocolsNoHandshakeFailure() throws Exception {
        try {
            this.providerType.activate(this);
            ApplicationProtocolConfig clientApn = JdkSslEngineTest.acceptingNegotiator(this.providerType.protocol(), PREFERRED_APPLICATION_LEVEL_PROTOCOL);
            ApplicationProtocolConfig serverApn = JdkSslEngineTest.acceptingNegotiator(this.providerType.protocol(), APPLICATION_LEVEL_PROTOCOL_NOT_COMPATIBLE);
            this.setupHandlers(serverApn, clientApn);
            this.runTest(null);
        }
        catch (SkipTestException e) {
            Assume.assumeNoException((Throwable)e);
        }
    }

    @Test
    public void testTlsExtensionNoCompatibleProtocolsClientHandshakeFailure() throws Exception {
        try {
            this.providerType.activate(this);
            if (this.providerType == ProviderType.NPN_JETTY) {
                ApplicationProtocolConfig clientApn = JdkSslEngineTest.failingNegotiator(this.providerType.protocol(), PREFERRED_APPLICATION_LEVEL_PROTOCOL);
                ApplicationProtocolConfig serverApn = JdkSslEngineTest.acceptingNegotiator(this.providerType.protocol(), APPLICATION_LEVEL_PROTOCOL_NOT_COMPATIBLE);
                this.setupHandlers(serverApn, clientApn);
                Assert.assertTrue((boolean)this.clientLatch.await(2L, TimeUnit.SECONDS));
                Assert.assertTrue((boolean)(this.clientException instanceof SSLHandshakeException));
            } else {
                SelfSignedCertificate ssc = new SelfSignedCertificate();
                JdkAlpnApplicationProtocolNegotiator clientApn = new JdkAlpnApplicationProtocolNegotiator(true, true, new String[]{PREFERRED_APPLICATION_LEVEL_PROTOCOL});
                JdkAlpnApplicationProtocolNegotiator serverApn = new JdkAlpnApplicationProtocolNegotiator(new JdkApplicationProtocolNegotiator.ProtocolSelectorFactory(){

                    public JdkApplicationProtocolNegotiator.ProtocolSelector newSelector(SSLEngine engine, Set<String> supportedProtocols) {
                        return new JdkApplicationProtocolNegotiator.ProtocolSelector(){

                            public void unsupported() {
                            }

                            public String select(List<String> protocols) {
                                return JdkSslEngineTest.APPLICATION_LEVEL_PROTOCOL_NOT_COMPATIBLE;
                            }
                        };
                    }
                }, JdkBaseApplicationProtocolNegotiator.FAIL_SELECTION_LISTENER_FACTORY, new String[]{APPLICATION_LEVEL_PROTOCOL_NOT_COMPATIBLE});
                JdkSslServerContext serverSslCtx = new JdkSslServerContext(this.providerType.provider(), ssc.certificate(), ssc.privateKey(), null, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, (JdkApplicationProtocolNegotiator)serverApn, 0L, 0L, null);
                JdkSslClientContext clientSslCtx = new JdkSslClientContext(this.providerType.provider(), null, InsecureTrustManagerFactory.INSTANCE, null, (CipherSuiteFilter)IdentityCipherSuiteFilter.INSTANCE, (JdkApplicationProtocolNegotiator)clientApn, 0L, 0L);
                this.setupHandlers((SslContext)new TestDelegatingSslContext((SslContext)serverSslCtx), (SslContext)new TestDelegatingSslContext((SslContext)clientSslCtx));
                Assert.assertTrue((boolean)this.clientLatch.await(2L, TimeUnit.SECONDS));
                Assert.assertTrue((this.clientException instanceof SSLHandshakeException || this.clientException == null ? 1 : 0) != 0);
            }
        }
        catch (SkipTestException e) {
            Assume.assumeNoException((Throwable)e);
        }
    }

    @Test
    public void testTlsExtensionNoCompatibleProtocolsServerHandshakeFailure() throws Exception {
        try {
            this.providerType.activate(this);
            ApplicationProtocolConfig clientApn = JdkSslEngineTest.acceptingNegotiator(this.providerType.protocol(), PREFERRED_APPLICATION_LEVEL_PROTOCOL);
            ApplicationProtocolConfig serverApn = JdkSslEngineTest.failingNegotiator(this.providerType.protocol(), APPLICATION_LEVEL_PROTOCOL_NOT_COMPATIBLE);
            this.setupHandlers(serverApn, clientApn);
            Assert.assertTrue((boolean)this.serverLatch.await(2L, TimeUnit.SECONDS));
            Assert.assertTrue((boolean)(this.serverException instanceof SSLHandshakeException));
        }
        catch (SkipTestException e) {
            Assume.assumeNoException((Throwable)e);
        }
    }

    @Test
    public void testAlpnCompatibleProtocolsDifferentClientOrder() throws Exception {
        try {
            this.providerType.activate(this);
            if (this.providerType == ProviderType.NPN_JETTY) {
                throw JdkSslEngineTest.tlsExtensionNotFound(this.providerType.protocol());
            }
            ApplicationProtocolConfig clientApn = JdkSslEngineTest.acceptingNegotiator(ApplicationProtocolConfig.Protocol.ALPN, FALLBACK_APPLICATION_LEVEL_PROTOCOL, PREFERRED_APPLICATION_LEVEL_PROTOCOL);
            ApplicationProtocolConfig serverApn = JdkSslEngineTest.failingNegotiator(ApplicationProtocolConfig.Protocol.ALPN, PREFERRED_APPLICATION_LEVEL_PROTOCOL, FALLBACK_APPLICATION_LEVEL_PROTOCOL);
            this.setupHandlers(serverApn, clientApn);
            Assert.assertNull((Object)this.serverException);
            this.runTest(PREFERRED_APPLICATION_LEVEL_PROTOCOL);
        }
        catch (SkipTestException e) {
            Assume.assumeNoException((Throwable)e);
        }
    }

    @Test
    public void testEnablingAnAlreadyDisabledSslProtocol() throws Exception {
        this.testEnablingAnAlreadyDisabledSslProtocol(new String[0], new String[]{"TLSv1.2"});
    }

    @Override
    @Ignore
    public void testMutualAuthValidClientCertChainTooLongFailOptionalClientAuth() throws Exception {
    }

    @Override
    @Ignore
    public void testMutualAuthValidClientCertChainTooLongFailRequireClientAuth() throws Exception {
    }

    @Override
    protected boolean mySetupMutualAuthServerIsValidException(Throwable cause) {
        return super.mySetupMutualAuthServerIsValidException(cause) || JdkSslEngineTest.causedBySSLException(cause);
    }

    private void runTest() throws Exception {
        this.runTest(PREFERRED_APPLICATION_LEVEL_PROTOCOL);
    }

    @Override
    protected SslProvider sslClientProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected SslProvider sslServerProvider() {
        return SslProvider.JDK;
    }

    @Override
    protected Provider clientSslContextProvider() {
        return this.provider;
    }

    @Override
    protected Provider serverSslContextProvider() {
        return this.provider;
    }

    private static ApplicationProtocolConfig failingNegotiator(ApplicationProtocolConfig.Protocol protocol, String ... supportedProtocols) {
        return new ApplicationProtocolConfig(protocol, ApplicationProtocolConfig.SelectorFailureBehavior.FATAL_ALERT, ApplicationProtocolConfig.SelectedListenerFailureBehavior.FATAL_ALERT, supportedProtocols);
    }

    private static ApplicationProtocolConfig acceptingNegotiator(ApplicationProtocolConfig.Protocol protocol, String ... supportedProtocols) {
        return new ApplicationProtocolConfig(protocol, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, supportedProtocols);
    }

    private static SkipTestException tlsExtensionNotFound(ApplicationProtocolConfig.Protocol protocol) {
        throw new SkipTestException(protocol + " not on classpath");
    }

    private final class TestDelegatingSslContext
    extends DelegatingSslContext {
        TestDelegatingSslContext(SslContext ctx) {
            super(ctx);
        }

        protected void initEngine(SSLEngine engine) {
            engine.setEnabledProtocols(JdkSslEngineTest.this.protocols());
            engine.setEnabledCipherSuites(JdkSslEngineTest.this.ciphers().toArray(EmptyArrays.EMPTY_STRINGS));
        }
    }

    private static final class SkipTestException
    extends RuntimeException {
        private static final long serialVersionUID = 9214869217774035223L;

        SkipTestException(String message) {
            super(message);
        }
    }

    public static enum ProviderType {
        NPN_JETTY{

            @Override
            boolean isAvailable() {
                return JettyNpnSslEngine.isAvailable();
            }

            @Override
            ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.NPN;
            }

            @Override
            Provider provider() {
                return null;
            }
        }
        ,
        ALPN_JETTY{

            @Override
            boolean isAvailable() {
                return JettyAlpnSslEngine.isAvailable();
            }

            @Override
            ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.ALPN;
            }

            @Override
            Provider provider() {
                return null;
            }
        }
        ,
        ALPN_JAVA{

            @Override
            boolean isAvailable() {
                return JdkAlpnSslUtils.supportsAlpn();
            }

            @Override
            ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.ALPN;
            }

            @Override
            Provider provider() {
                return null;
            }
        }
        ,
        ALPN_CONSCRYPT{
            private Provider provider;

            @Override
            boolean isAvailable() {
                return Conscrypt.isAvailable();
            }

            @Override
            ApplicationProtocolConfig.Protocol protocol() {
                return ApplicationProtocolConfig.Protocol.ALPN;
            }

            @Override
            Provider provider() {
                try {
                    if (this.provider == null) {
                        this.provider = (Provider)Class.forName("org.conscrypt.OpenSSLProvider").getConstructor(new Class[0]).newInstance(new Object[0]);
                    }
                    return this.provider;
                }
                catch (Exception e) {
                    throw new IllegalStateException(e);
                }
            }
        };


        abstract boolean isAvailable();

        abstract ApplicationProtocolConfig.Protocol protocol();

        abstract Provider provider();

        final void activate(JdkSslEngineTest instance) {
            if (!this.isAvailable()) {
                throw JdkSslEngineTest.tlsExtensionNotFound(this.protocol());
            }
            instance.provider = this.provider();
        }
    }
}

