/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.ssl;

import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextTest;
import java.io.InputStream;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.junit.Assert;
import org.junit.Test;

public class SslContextTrustManagerTest {
    @Test
    public void testUsingAllCAs() throws Exception {
        SslContextTrustManagerTest.runTests(new String[]{"tm_test_ca_1a.pem", "tm_test_ca_1b.pem", "tm_test_ca_2.pem"}, new String[]{"tm_test_eec_1.pem", "tm_test_eec_2.pem", "tm_test_eec_3.pem"}, new boolean[]{true, true, true});
    }

    @Test
    public void testUsingAllCAsWithDuplicates() throws Exception {
        SslContextTrustManagerTest.runTests(new String[]{"tm_test_ca_1a.pem", "tm_test_ca_1b.pem", "tm_test_ca_2.pem", "tm_test_ca_2.pem"}, new String[]{"tm_test_eec_1.pem", "tm_test_eec_2.pem", "tm_test_eec_3.pem"}, new boolean[]{true, true, true});
    }

    @Test
    public void testUsingCAsOneAandB() throws Exception {
        SslContextTrustManagerTest.runTests(new String[]{"tm_test_ca_1a.pem", "tm_test_ca_1b.pem"}, new String[]{"tm_test_eec_1.pem", "tm_test_eec_2.pem", "tm_test_eec_3.pem"}, new boolean[]{true, true, false});
    }

    @Test
    public void testUsingCAsOneAandTwo() throws Exception {
        SslContextTrustManagerTest.runTests(new String[]{"tm_test_ca_1a.pem", "tm_test_ca_2.pem"}, new String[]{"tm_test_eec_1.pem", "tm_test_eec_2.pem", "tm_test_eec_3.pem"}, new boolean[]{true, false, true});
    }

    private static void runTests(String[] caResources, String[] eecResources, boolean[] expectations) throws Exception {
        X509TrustManager tm = SslContextTrustManagerTest.getTrustManager(caResources);
        X509Certificate[] eecCerts = SslContextTrustManagerTest.loadCertCollection(eecResources);
        for (int i = 0; i < eecResources.length; ++i) {
            X509Certificate eecCert = eecCerts[i];
            Assert.assertNotNull((String)("Cannot use cert " + eecResources[i]), (Object)eecCert);
            try {
                tm.checkServerTrusted(new X509Certificate[]{eecCert}, "RSA");
                if (expectations[i]) continue;
                Assert.fail((String)String.format("Certificate %s was expected not to be valid when using CAs %s, but its verification passed.", eecResources[i], Arrays.asList(caResources)));
                continue;
            }
            catch (CertificateException e) {
                if (!expectations[i]) continue;
                Assert.fail((String)String.format("Certificate %s was expected to be valid when using CAs %s, but its verification failed.", eecResources[i], Arrays.asList(caResources)));
            }
        }
    }

    private static X509TrustManager getTrustManager(String[] resourceNames) throws Exception {
        X509Certificate[] certCollection = SslContextTrustManagerTest.loadCertCollection(resourceNames);
        TrustManagerFactory tmf = SslContext.buildTrustManagerFactory((X509Certificate[])certCollection, null, null);
        for (TrustManager tm : tmf.getTrustManagers()) {
            if (!(tm instanceof X509TrustManager)) continue;
            return (X509TrustManager)tm;
        }
        throw new Exception("Unable to find any X509TrustManager from this factory.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static X509Certificate[] loadCertCollection(String[] resourceNames) throws Exception {
        CertificateFactory certFactory = CertificateFactory.getInstance("X.509");
        X509Certificate[] certCollection = new X509Certificate[resourceNames.length];
        for (int i = 0; i < resourceNames.length; ++i) {
            String resourceName = resourceNames[i];
            InputStream is = null;
            try {
                is = SslContextTest.class.getResourceAsStream(resourceName);
                Assert.assertNotNull((String)("Cannot find " + resourceName), (Object)is);
                certCollection[i] = (X509Certificate)certFactory.generateCertificate(is);
                continue;
            }
            finally {
                if (is != null) {
                    is.close();
                }
            }
        }
        return certCollection;
    }
}

