/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.address;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPromise;
import io.netty.channel.embedded.EmbeddedChannel;
import io.netty.handler.address.DynamicAddressConnectHandler;
import java.net.SocketAddress;
import org.junit.Assert;
import org.junit.Test;

public class DynamicAddressConnectHandlerTest {
    private static final SocketAddress LOCAL = new SocketAddress(){};
    private static final SocketAddress LOCAL_NEW = new SocketAddress(){};
    private static final SocketAddress REMOTE = new SocketAddress(){};
    private static final SocketAddress REMOTE_NEW = new SocketAddress(){};

    @Test
    public void testReplaceAddresses() {
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new ChannelOutboundHandlerAdapter(){

            public void connect(ChannelHandlerContext ctx, SocketAddress remoteAddress, SocketAddress localAddress, ChannelPromise promise) {
                try {
                    Assert.assertSame((Object)REMOTE_NEW, (Object)remoteAddress);
                    Assert.assertSame((Object)LOCAL_NEW, (Object)localAddress);
                    promise.setSuccess();
                }
                catch (Throwable cause) {
                    promise.setFailure(cause);
                }
            }
        }, new DynamicAddressConnectHandler(){

            protected SocketAddress localAddress(SocketAddress remoteAddress, SocketAddress localAddress) {
                Assert.assertSame((Object)REMOTE, (Object)remoteAddress);
                Assert.assertSame((Object)LOCAL, (Object)localAddress);
                return LOCAL_NEW;
            }

            protected SocketAddress remoteAddress(SocketAddress remoteAddress, SocketAddress localAddress) {
                Assert.assertSame((Object)REMOTE, (Object)remoteAddress);
                Assert.assertSame((Object)LOCAL, (Object)localAddress);
                return REMOTE_NEW;
            }
        }});
        channel.connect(REMOTE, LOCAL).syncUninterruptibly();
        Assert.assertNull((Object)channel.pipeline().get(DynamicAddressConnectHandler.class));
        Assert.assertFalse((boolean)channel.finish());
    }

    @Test
    public void testLocalAddressThrows() {
        DynamicAddressConnectHandlerTest.testThrows0(true);
    }

    @Test
    public void testRemoteAddressThrows() {
        DynamicAddressConnectHandlerTest.testThrows0(false);
    }

    private static void testThrows0(final boolean localThrows) {
        final IllegalStateException exception = new IllegalStateException();
        EmbeddedChannel channel = new EmbeddedChannel(new ChannelHandler[]{new DynamicAddressConnectHandler(){

            protected SocketAddress localAddress(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
                if (localThrows) {
                    throw exception;
                }
                return super.localAddress(remoteAddress, localAddress);
            }

            protected SocketAddress remoteAddress(SocketAddress remoteAddress, SocketAddress localAddress) throws Exception {
                if (!localThrows) {
                    throw exception;
                }
                return super.remoteAddress(remoteAddress, localAddress);
            }
        }});
        Assert.assertSame((Object)exception, (Object)channel.connect(REMOTE, LOCAL).cause());
        Assert.assertNotNull((Object)channel.pipeline().get(DynamicAddressConnectHandler.class));
        Assert.assertFalse((boolean)channel.finish());
    }
}

